open Printf
open Cil

module SG = Graph.Imperative.Digraph.ConcreteBidirectional(struct
  
  type t = Callgraph.callnode
  let hash n = Hashtbl.hash n.Callgraph.cnid
  let compare n1 n2 =
    compare n1.Callgraph.cnid n2.Callgraph.cnid
  let equal n1 n2 =
    n1.Callgraph.cnid = n2.Callgraph.cnid
end)


module D = Graph.Graphviz.Dot(struct

  type t = SG.t
  module V = SG.V
  module E = SG.E
  let iter_vertex = SG.iter_vertex
  let iter_edges_e = SG.iter_edges_e
  let graph_attributes g = []
  let default_vertex_attributes g = []
  let vertex_name v = Callgraph.nodeName v.Callgraph.cnInfo
(*    match v.Callgraph.cnInfo with
    | Callgraph.NIVar (vi, _) -> vi.vname
    | Callgraph.NIIndirect (s, _) -> s *)
  let vertex_attributes v = (*if(Csgconstruct.isChangedFunction v) then [`Style `Filled] else*) []
  let get_subgraph v = None
  let default_edge_attributes g = []
  let edge_attributes e = []


end)
 
let printColoredCallgraph cg =
  (** Print call graph as text **)
  (*   Hashtbl.iter (fun s n -> (
		printf "function %s\n" s;
		Inthash.iter (fun i n' -> printf " -> %s\n" (Callgraph.nodeName n'.Callgraph.cnInfo)) n.Callgraph.cnCallees
    )) cg; *)

  (** Print call graph as dot**)
  let graph =
    let g = SG.create() in
    Hashtbl.iter (fun s n -> SG.add_vertex g n) cg;
    Hashtbl.iter (fun s n -> Inthash.iter (fun i n' -> SG.add_edge g n n') n.Callgraph.cnCallees) cg;
    g in
  
  let callGraphDot = open_out "callgraph.dot" in
  D.output_graph callGraphDot graph;
  close_out callGraphDot

let parseCommandLine = 
  let gitdir = ref "" in
  let difftool = ref "" in
  let difffile = ref "" in
  
  let usage = "usage: " ^ Sys.argv.(0) ^ " [--git git-directory] [--diff diff-tool]" in
  let speclist = [
    ("--git",  Arg.String   (fun s -> gitdir := s),   " : Specify directory containing the git repository");
    ("--diff", Arg.String   (fun s -> difftool := s), ": Specify the utility that returns the changed files and lines");
    ("--use-diff-file", Arg.String   (fun s -> difffile := s), ": The changed lines of code are *not* calculated from the patch in the git repo but from the provided diff-file.");
  ] in
 
  (* Read the arguments *)
  Arg.parse
    speclist
    (fun x -> raise (Arg.Bad ("Bad argument : " ^ x)))
    usage;
  if (String.length !gitdir) = 0 or (String.length !difftool) = 0 then printf "%s\n" usage;
  (!gitdir,!difftool,!difffile)

let () =
  let (gitdir,difftool,difffile) = parseCommandLine in
  if not ((String.length gitdir) = 0 or (String.length difftool) = 0) then begin
    let start_t = Sys.time() in 
    let patch = Csgconstruct.read_patch gitdir difftool difffile in
    let file = Csgconstruct.prepareFile patch gitdir in
    let callgraph = Callgraph.computeGraph file in
    printf "Preparation Time              : %fs\n" (Sys.time() -. start_t);
    printColoredCallgraph callgraph;
    Csgconstruct.constructInterCSG file callgraph patch
  end
