import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class ImmutableSet<T> {
    private final Set<T> internalSet;

    private ImmutableSet(Set<T> set) {
        this.internalSet = Collections.unmodifiableSet(set);
    }

    public static <T> ImmutableSet<T> of() {
        return new ImmutableSet<>(new HashSet<>());
    }

    public static <T> ImmutableSet<T> of(Set<T> set) {
        return new ImmutableSet<>(new HashSet<>(set));
    }

    public ImmutableSet<T> add(T element) {
        Set<T> newSet = new HashSet<>(internalSet);
        newSet.add(element);
        return new ImmutableSet<>(newSet);
    }

    public ImmutableSet<T> remove(T element) {
        Set<T> newSet = new HashSet<>(internalSet);
        newSet.remove(element);
        return new ImmutableSet<>(newSet);
    }

    public ImmutableSet<T> addAll(Set<T> elements) {
        Set<T> newSet = new HashSet<>(internalSet);
        newSet.addAll(elements);
        return new ImmutableSet<>(newSet);
    }

    public ImmutableSet<T> removeAll(Set<T> elements) {
        Set<T> newSet = new HashSet<>(internalSet);
        newSet.removeAll(elements);
        return new ImmutableSet<>(newSet);
    }

    public boolean contains(T element) {
        return internalSet.contains(element);
    }

    public int size() {
        return internalSet.size();
    }

    public boolean isEmpty() {
        return internalSet.isEmpty();
    }

    public Set<T> asSet() {
        return internalSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImmutableSet<?> that = (ImmutableSet<?>) o;
        return internalSet.equals(that.internalSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(internalSet);
    }

    @Override
    public String toString() {
        return internalSet.toString();
    }
}
