/*
 * Decompiled with CFR 0.152.
 */
package lab2;

import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import lab2.ServerConnection;
import lab2.lab2Midlet;

public class SocketSprite
extends GameCanvas
implements CommandListener,
Runnable {
    public static final int FRAME_WIDTH = 21;
    public static final int FRAME_HEIGHT = 21;
    public static final int MOVING_STEP = 3;
    private ServerConnection sc;
    private Sprite sprite1 = this.createSprite("/lab2/sprite1.png", this.getWidth() / 2, this.getHeight() / 2);
    private Sprite sprite2 = this.createSprite("/lab2/sprite2.png", this.getWidth() / 2, this.getHeight() / 2 + 25);
    private boolean running = true;

    public SocketSprite() {
        super(true);
        Thread t = new Thread(this);
        try {
            t.start();
            System.out.println("Sucessfully started");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Sprite createSprite(String path, int x, int y) {
        Image img = null;
        try {
            img = Image.createImage((String)path);
            Sprite aSprite = new Sprite(img, 21, 21);
            aSprite.setPosition(x, y);
            aSprite.defineReferencePixel(10, 10);
            return aSprite;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void run() {
        Graphics gr = this.getGraphics();
        this.sc = new ServerConnection();
        try {
            this.sc.connect();
        }
        catch (IOException e) {
            return;
        }
        boolean positionChanged = false;
        while (this.running) {
            gr.fillRect(0, 0, this.getWidth(), this.getHeight());
            int keyStates = this.getKeyStates();
            if ((keyStates & 4) != 0) {
                positionChanged = true;
                this.sprite1.move(-3, 0);
                this.sprite1.setFrame(3);
            } else if ((keyStates & 0x20) != 0) {
                positionChanged = true;
                this.sprite1.move(3, 0);
                this.sprite1.setFrame(1);
            } else if ((keyStates & 2) != 0) {
                positionChanged = true;
                this.sprite1.move(0, -3);
                this.sprite1.setFrame(0);
            } else if ((keyStates & 0x40) != 0) {
                positionChanged = true;
                this.sprite1.move(0, 3);
                this.sprite1.setFrame(2);
            }
            if (this.sc.receiveUpdate) {
                this.sprite2.move(this.sc.newX - this.sprite2.getRefPixelX(), this.sc.newY - this.sprite2.getRefPixelY());
                this.sprite2.setFrame(this.sc.newFrame);
            }
            this.sprite1.paint(gr);
            this.sprite2.paint(gr);
            this.flushGraphics();
            try {
                if (positionChanged) {
                    this.sc.updatePosition(this.sprite1.getRefPixelX(), this.sprite1.getRefPixelY(), this.sprite1.getFrame());
                    positionChanged = false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.sc.isConnected()) {
            try {
                this.sc.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void jbInit() {
        this.setCommandListener(this);
        this.addCommand(new Command("Exit", 7, 1));
        this.addCommand(new Command("Re-Start", 4, 1));
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            this.running = false;
            lab2Midlet.quitApp();
        }
        if (command.getCommandType() == 4) {
            // empty if block
        }
    }
}

