/*
 * SocketSprite.java
 *
 * Created on September 6, 2006, 11:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package lab2;

import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.*;
import java.io.IOException;
import java.util.Random;
/**
 *
 * @author Administrator
 */
public class SocketSprite extends GameCanvas implements CommandListener, Runnable {
    
    public static final int FRAME_WIDTH = 21;
    public static final int FRAME_HEIGHT = 21;
    public static final int MOVING_STEP = 3;
    private ServerConnection sc;
    private Sprite sprite1, sprite2;
    private boolean running = true;
    
    /** Creates a new instance of SocketSprite */
    public SocketSprite() {
	super(true);
	
	// create the two sprite image
	sprite1 = createSprite("/lab2/sprite1.png", getWidth()/2, getHeight()/2);
	sprite2 = createSprite("/lab2/sprite2.png", getWidth()/2, getHeight()/2+25);
	
	Thread t = new Thread(this);
	try {
	    t.start();
	    System.out.println("Sucessfully started");
	} catch (Exception e) {
	    System.out.println(e.getMessage());
	    e.printStackTrace();
	}
    }
    
    public Sprite createSprite(String path, int x, int y) {
	
	Image img = null;
	
	try {
	    img = Image.createImage(path);
	    
	    Sprite aSprite = new Sprite(img, FRAME_WIDTH, FRAME_HEIGHT);
	    aSprite.setPosition(x,y);
	    aSprite.defineReferencePixel(FRAME_WIDTH/2, FRAME_HEIGHT/2);
	    return aSprite;
	} catch (Exception e) {
	    e.printStackTrace();
	    System.out.println(e.getMessage());
	    return null;
	}
    }
    
    // implement runnable interface
    public void run() {
	Graphics gr = getGraphics();	
	sc = new ServerConnection();
	
	try {
	    sc.connect();
	} catch (IOException e) {
	    return;
	}
	
	
	boolean positionChanged = false;
	while (running)
	{
	    gr.fillRect(0,0,getWidth(),getHeight());
	    
	    int keyStates = getKeyStates();
	    if ((keyStates & LEFT_PRESSED) !=0 ){
		positionChanged = true;
		sprite1.move(-MOVING_STEP, 0);
		sprite1.setFrame(3);
	    } else if ((keyStates & RIGHT_PRESSED) !=0 ){
		positionChanged = true;
		sprite1.move(MOVING_STEP, 0);
		sprite1.setFrame(1);
	    } else if ((keyStates & UP_PRESSED) !=0 ){
		positionChanged = true;
		sprite1.move(0, -MOVING_STEP);
		sprite1.setFrame(0);
	    } else if ((keyStates & DOWN_PRESSED) !=0 ){
		positionChanged = true;
		sprite1.move(0, MOVING_STEP);
		sprite1.setFrame(2);
	    }
	    
	    if (sc.receiveUpdate) {
		sprite2.move(sc.newX-sprite2.getRefPixelX(),sc.newY-sprite2.getRefPixelY());
		sprite2.setFrame(sc.newFrame);
	    }
	    
	    sprite1.paint(gr);
	    sprite2.paint(gr);
	    flushGraphics();
	    
	    try {
		if (positionChanged) {
		    sc.updatePosition(sprite1.getRefPixelX(), sprite1.getRefPixelY(), sprite1.getFrame());
		    positionChanged = false;
		}
	    } catch (IOException e) {
		e.printStackTrace();
	    }
	    
	    try {
		Thread.sleep(50);
	    }
	    catch (InterruptedException ie) {}
	}
	
	if (sc.isConnected()) 
	{
	    try {
		sc.disconnect();
	    } catch (IOException e)
	    {}
	}
    }
    
    // implement command listener interface
    public void jbInit() {
	setCommandListener(this);
	
	addCommand(new Command("Exit", Command.EXIT, 1));
	addCommand(new Command("Re-Start", Command.OK , 1));
    }
    
    public void commandAction(Command command, Displayable displayable) {
	/** @todo Add command handling code */
	if (command.getCommandType() == Command.EXIT) {
            running = false;
	    lab2Midlet.quitApp();
	}
	if (command.getCommandType() == Command.OK) {
	        
	}
    }
    
}
