/*
 * Player.java
 *
 * Created on September 7, 2006, 10:37 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package spritesServer;

import java.io.*;
import java.net.*;

/**
 *
 * @author Administrator
 */
public class Player implements Runnable {
    public int x, y, frameNum;
    private DataInputStream is;
    private DataOutputStream os;
    public boolean change, running;
    private boolean error;
    private Exception reason;
    private String name;
    
    public Player(String name) {
	change = false;
	this.name = name;
    }
    
    public void initializeConnection(Socket s) throws IOException {
	is = new DataInputStream(s.getInputStream()); 
	os = new DataOutputStream(s.getOutputStream());
    }
    
    public void run(){
	running = true;
	error = false;
	while (running) {
	    try {
		x = is.readInt();
		y = is.readInt();
		frameNum = is.readInt();
		change = true;
		System.out.println(name+"'s new pos : ("+x+","+y+","+frameNum+")");
	    } catch (Exception e) {
		reason = e;
		//e.printStackTrace();
                synchronized (this) {
                    running = false;
                    change = false;
                }
	    }
	}
    }
    
    public void stop() {
	running = false;
    }
    
    public void destroy() throws IOException {
	is.close();
	os.close();
    }
    
    public void updatePosition(int x, int y, int frameNum) throws IOException {
	os.writeInt(x);
	os.writeInt(y);
	os.writeInt(frameNum);
    }
}
