`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 05/18/2024 04:57:29 PM
// Design Name: 
// Module Name: picture2pixel
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module picture2pixel(input clk, output [7:0] JB);
    parameter basys3_clk_freq = 100_000_000;
    parameter frame_rate = 12;
    
    wire [31:0] clk_param;
    
    wire frame_begin, sending_pixels, sample_pixel;
    
    wire [12:0] pixel_index_JB;
    wire [15:0] oled_data_JB;
    
    wire clk_25M, clk_6p25M, clk_frameRate;
    
    reg reset = 0;
    
    assign clk_param = (basys3_clk_freq / (frame_rate)) - 1;
    
    flexible_clock_signal clk25M (clk, 1, clk_25M);
    flexible_clock_signal clk6p25M (clk, 7, clk_6p25M);
    flexible_clock_signal clkframeRate (clk, clk_param, clk_frameRate);
    
    Oled_Display oledDisplay_JB (clk_6p25M, reset, frame_begin, sending_pixels, sample_pixel,
                                 pixel_index_JB, oled_data_JB, 
                                 JB[0], JB[1], JB[3], JB[4],JB[5], JB[6], JB[7]);
    
    frame_data framedata (clk_frameRate, pixel_index_JB, oled_data_JB);
endmodule
