/******************************************************************
*  Done by: Tan Keat Houng                                        *
*  Matric No. : U027907U                                          *
*  UIT2201 CS & IT Revolution                                     *
*                                                                 *
*  Automated Smart Functions - Door Colour preference updater     *
*  Description:                                                   *
*     This program is called when a user changes his/her          *
*     preferred door colour. It will connect to the database and  *
*     update the fields corresponding to the input                *
*                                                                 *
*                                                                 *
*  Input:                                                         *
*  2 numbers, seperated by a space, representing the <UserID>     *
*  and the <Colour_code> respectively                             *
*                                                                 *
*  Output:                                                        *
*     The number representing the colour chosen.                  *
*     If DB Error is encountered, "DB Error!" will be returned    *
*     instead                                                     *
******************************************************************/
package IDEA_Change_Colour;
import java.sql.*;   // LHW: this imports sql related classes
import DBClasses.*;  // LHW: imports database manager and other classes

class Change_Colour 
{

	public static void main(String[] args) 
	{
		//success records the status of the update; unless there is a DB error, it will remain true ie 1.
		// 1=true, 0=false
		//int success = 1;   //remove slashes if you want an output to indicate success in the update. See line 51 also.
		
		int error=0;  //this int will determine the output of stdout
		//prepare the dbManager class
		dbManager dbman = new dbManager();

		//open new connection
		Connection conn = dbman.getConnection();

		//store the values of USER_ID and PERS_PREF_DOOR_COLOR
		String curr=args[0];  //USER_ID
		String colour=args[1];  //PERS_PREF_DOORCOLOR

		try 
		{
			// To execute query, 
			// first create the sql statement
			//   execute the statement
			//   "catch" the output in "rs" (rs is a set of tuples)
			Statement stmt = conn.createStatement();
			String sql = "UPDATE PEOPLE SET PERS_PREF_DOORCOLOR ="+ colour+" WHERE PERS_ID ="+curr;      // prepare sql stmt
			ResultSet rs = stmt.executeQuery(sql);          // execute query	
			rs.close();       // close everything (rs, stmt, conn)
			stmt.close();
			conn.close();
		} catch (Exception e) 
		{
			error=1; //there is an error. "DB Error!" will be the output
			//success=0;       //remove slashes if you want an output to indicate success in the update. See line 31 also.
			System.out.println("DB Error!"); // error message if exception occurs
			e.printStackTrace();
		}//catch
		if (error==0) //this will ensure that there will be only 1 output
					  //that either colour or the error message will be printed
		{
			System.out.println(colour);  // colour code is returned after the database 
									 //has been updated with the value of the colour code, 
									 //as specified by controller
		}
	}//main
}//class
