using System;
using System.Collections.Generic;
using System.Text;

namespace PAT
{
    /// <summary>
    /// The math library that can be used in your model.
    /// all methods should be declared as public static.
    /// 
    /// The parameters must be of type "int", or "int array"
    /// The number of parameters are limited to one or two for the simplicity.
    /// 
    /// The return type can be bool and int only.
    /// 
    /// The method name will be used directly in your model.
    /// e.g. call(max, 10, 2), call(dominate, 3, 2), call(amax, [1,3,5]),
    ///  
    /// </summary>
    public class MathFunctions
    {
        //==========================================================
        //the following sections are the functions used by Mailbox 
        //==========================================================
        private static List<int[]> Matrix;

        //dominate(v,w) == CHOOSE x \in 1..7 : GT(x, v) /\ GT(x, w)
        public static int dominate(int v, int w)
        {
            for (int i = 1; i <= 7; i++)
            {
                if (matrix[i - 1][v - 1] == 1 && matrix[i - 1][w - 1] == 1)
                {
                    return i;
                }
            }
            return -1;
        }

        //GT(v,w) == (Edges[v][w]=1)
        public static bool mailorder(int v, int w)
        {
            return matrix[v - 1][w - 1] == 1; 
        }

        private static List<int[]> matrix
        {
            get
            {
                if (Matrix == null)
                {
                    Matrix = new List<int[]>(7);
                    Matrix.Add(new int[] {0, 0, 1, 1, 1, 0, 0});
                    Matrix.Add(new int[] {1, 0, 1, 0, 0, 0, 1});
                    Matrix.Add(new int[] {0, 0, 0, 0, 1, 1, 1});
                    Matrix.Add(new int[] {0, 1, 1, 0, 0, 1, 0});
                    Matrix.Add(new int[] {0, 1, 0, 1, 0, 0, 1});
                    Matrix.Add(new int[] {1, 1, 0, 0, 1, 0, 0});
                    Matrix.Add(new int[] {1, 0, 0, 1, 0, 1, 0});
                }
                return Matrix;
            }
        }

        //==========================================================
        //the following sections are the functions used by Bakery  
        //The maximum value of the array will be returned.
        //==========================================================
        public static int amax(int[] values)
        {
            int max = values[0];
            foreach (int v in values)
            {
                if(max < v)
                {
                    max = v;
                }
            }
            return max;
        }

        public static int asum1(int[] values, int startingIndex)
        {
            int sum = 0;
            int dimention = (int) Math.Sqrt(values.Length);
            for (int i = 0; i < dimention; i++)
            {
                sum += values[startingIndex + i];
            }
            return sum;
        }

        public static int asum2(int[] values, int startingIndex)
        {
            int sum = 0;
            int dimention = (int)Math.Pow(values.Length, 1.0 / 3.0); ;
            for (int i = 0; i < dimention; i++)
            {
                sum += values[startingIndex + i];
            }
            return sum;
        }

       

    }
}
