#pragma once 

#include "global.h"

typedef struct FP_NODE
{
	int nitem_order;
	int	frequency;
	FP_NODE *pchild;
	FP_NODE	*prightsibling;
	FP_NODE *pparent;
	FP_NODE *pnode_link;
	TGT_UNION tgt_union;
} FP_NODE;

typedef struct
{
	int nitem; 
	int nsupport;
	FP_NODE *pconddb;
	int order;
} HEADER_NODE;
typedef HEADER_NODE* HEADER_TABLE;


class FPtree
{
	//------------ on data files -------------------
	void LoadAttrValues(char *szname_filename);
	int ScanDBCountFreqItems(char*sznames_filename, char* szdata_filename);
	FP_NODE* ScanDBBuildFPtree(char* szdata_filename, HEADER_TABLE pheader_table, int *pitem_order_map);

	void OutputAttrValueItemMap(char* szoutput_name);
	void OutputItemStatis(char* szoutput_name);
	void SortNOutputTgtValueMap(char* szoutput_name, map<string, int> *ptgtvalue_sup_map, int *ptgt_sups);


	//----- for multiple hypothesis correction -----
	FILE *mfp_tdb, *mfp_tdb_dir, *mfp_tgt;
	int mfp_tdb_pos, mntrans_num;
	void OpenTdbFiles(char* szoutput_name);
	void OutputTgtValue(FILE *fp, void *ptgt_value);
	void OutputOneTrans(int *ptrans, int nlen, void* ptgt_value);
	void CloseTdbFiles();

	//------------ On FP-tree --------------
	void CountFreqItems(HEADER_TABLE pheader_table, int nitem_order, HEADER_NODE *pitem_sup_map, char* ptgt_stat_array);
	FP_NODE* BuildNewFPTree(FP_NODE *pconddb, HEADER_TABLE pnewheader_table, int *pitem_order_map);

	void InsertTransaction(FP_NODE* &proot, HEADER_TABLE pheader_table, int* ptransaction, int length, int frequency, double dsum, double dsquare_sum);
	void InsertTransaction(FP_NODE* &proot, HEADER_TABLE pheader_table, int* ptransaction, int length, int frequency, int ntgt_sup);
	void InsertTransaction(FP_NODE* &proot, HEADER_TABLE pheader_table, int* ptransaction, int length, int frequency, int* ptgt_sups);
	void InsertTransaction(FP_NODE* &proot, HEADER_TABLE pheader_table, int* ptransaction, int length, int ntgt_value);

	void DepthFGGrowth(FP_NODE *proot, HEADER_TABLE pheader_table, char* ptgt_stat_array, int num_of_freqitems);
	bool IsSinglePath(FP_NODE *proot);

public:

	void MinePats();
	
};

int comp_item_freq_des(const void *e1, const void *e2);

void OutputItemSup(char* szoutput_name);


//====== inline routines for FP-tree nodes allocation 
#define FPNODE_PAGE_SIZE (1<<10)
struct FPNODE_PAGE
{
	FP_NODE *pfpnodes;
	char *pfptgt_stats; 
	FPNODE_PAGE *pnext;
};
struct FPNODE_BUF
{
	FPNODE_PAGE *phead;
	FPNODE_PAGE *pcur_page; 
	int ncur_pos;
	int ntotal_pages;
};
extern FPNODE_BUF gofpnode_buf;
extern int gnfptree_tgt_stat_size;

inline FPNODE_PAGE* NewFPNodePage()
{
	FPNODE_PAGE *pfppage;
	int i;

	pfppage = new FPNODE_PAGE;
	IncMemSize(sizeof(FPNODE_PAGE));
	pfppage->pfpnodes = new FP_NODE[FPNODE_PAGE_SIZE];
	IncMemSize(sizeof(FP_NODE)*FPNODE_PAGE_SIZE);
	if(gnfptree_tgt_stat_size>0)
	{
		pfppage->pfptgt_stats = new char[gnfptree_tgt_stat_size*FPNODE_PAGE_SIZE];
		IncMemSize(gnfptree_tgt_stat_size*FPNODE_PAGE_SIZE);
		if(gntgt_attr_type==CONTINUOUS || gntgt_attr_type==CONTINUOUS_NORMAL)
		{
			for(i=0;i<FPNODE_PAGE_SIZE;i++)
				pfppage->pfpnodes[i].tgt_union.ptgt_sum = (TGT_SUM*)&(pfppage->pfptgt_stats[i*gntgt_stat_size]);
		}
		else
		{
			for(i=0;i<FPNODE_PAGE_SIZE;i++)
				pfppage->pfpnodes[i].tgt_union.ptgt_sups = (int*)&(pfppage->pfptgt_stats[i*gntgt_stat_size]);
		}
	}
	else
		pfppage->pfptgt_stats = NULL;
	pfppage->pnext = NULL;

	return pfppage;
}
inline void DelFFNodePage(FPNODE_PAGE* pfppage)
{
	delete []pfppage->pfpnodes;
	DecMemSize(sizeof(FP_NODE)*FPNODE_PAGE_SIZE);
	if(pfppage->pfptgt_stats!=NULL)
	{
		delete []pfppage->pfptgt_stats;
		DecMemSize(gnfptree_tgt_stat_size*FPNODE_PAGE_SIZE);
	}
	delete pfppage;
	DecMemSize(sizeof(FPNODE_PAGE));
}

inline FP_NODE* NewOneFPNode()
{
	FP_NODE *pfpnode;
	FPNODE_PAGE *pnewfppage;

	if(gofpnode_buf.ncur_pos==FPNODE_PAGE_SIZE)
	{
		if(gofpnode_buf.pcur_page->pnext==NULL)
		{
			pnewfppage = NewFPNodePage();
			gofpnode_buf.pcur_page->pnext = pnewfppage;
			gofpnode_buf.pcur_page = pnewfppage;
			gofpnode_buf.ntotal_pages++;
		}
		else
			gofpnode_buf.pcur_page = gofpnode_buf.pcur_page->pnext;
		gofpnode_buf.ncur_pos = 0;
	}
	
	pfpnode = &(gofpnode_buf.pcur_page->pfpnodes[gofpnode_buf.ncur_pos]);
	gofpnode_buf.ncur_pos++;
	
	return pfpnode;
}
inline void Reset(FPNODE_PAGE *pcur_page, int ncur_pos)
{
	gofpnode_buf.pcur_page = pcur_page;
	gofpnode_buf.ncur_pos = ncur_pos;
}
//======


//------ inline routines for allocating header tables
extern HEADER_TABLE gpdfs_header_array;
extern char* gpdfs_tgtstat_array; 
extern int gndfs_header_size;
extern int gndfs_header_pos;

inline HEADER_TABLE NewHeaderTable(int num_of_freqitems, char* &ptgtstat_array)
{
	HEADER_TABLE pheader_table;

	if(gndfs_header_pos+num_of_freqitems<=gndfs_header_size)
	{
		pheader_table = &(gpdfs_header_array[gndfs_header_pos]);
		ptgtstat_array = &gpdfs_tgtstat_array[gndfs_header_pos*gntgt_stat_size];
		gndfs_header_pos += num_of_freqitems;
	}
	else 
	{
		IncMemSize(num_of_freqitems*sizeof(HEADER_NODE));
		pheader_table = new HEADER_NODE[num_of_freqitems];
		ptgtstat_array = NewCharArray(num_of_freqitems*gntgt_stat_size);
	}

	return pheader_table;
}

inline void DelHeaderTable(HEADER_TABLE pheader_table, char* ptgtstat_array, int num_of_freqitems)
{
	if((unsigned int)pheader_table>=(unsigned int)gpdfs_header_array && (unsigned int)pheader_table<(unsigned int)gpdfs_header_array+sizeof(HEADER_NODE)*gndfs_header_size)
	{
		gndfs_header_pos -= num_of_freqitems;
	}
	else 
	{
		DecMemSize(num_of_freqitems*sizeof(HEADER_NODE));
		delete []pheader_table;
		DelCharArray(ptgtstat_array, num_of_freqitems*gntgt_stat_size);
	}
}
//------

