#include <stdlib.h>
#include "Global.h"

//#include "cfptree_ehta.h"

//--- parameter settings
char gszdata_filename[200];
char gsznames_filename[200];
map<string, int> *gpcontext_attr_map;
map<string, int> *gpcomparing_attr_map;
char gsztarget_attr[100];
char gsztarget_value[100];
int gnsignal_type;

double gdmin_sup;
int gnmin_sup;
double gdmin_diff;
double gdmax_pvalue;
int gnmax_len;

char gszoutput_filename[200];

int gnmaterialization_mode;  //0: frequent only; 1: frequent + infrequent on border. Default: 0.
int gncompare_mode;
int gntest_statisitic_method;
int gnPVALUE_BUF_SIZE;
int gneffect_size_method;
int gnoutput_mode;

double gdmax_local_pvalue;
int gncorrection_method;
bool gbdiff_tid_list;
int gnum_of_repetitions;
int gnseeding_method;
int gndata_perm_method;
bool gbgen_tid_list;
//---

bool gbrule_multiclass_pairwise;


//data statistics
int gndb_size;
double gdtotal_sum;
double gdtotal_square_sum;
TGT_UNION gtgt_stat;
int gnmax_item_num_per_attr;

//pattern statistics
int	gnmax_pattern_len;
int gnmax_sup;
int gnfreq_pat_num;
int gnnonclosed_freq_pat_num;
int gninfreq_pat_num;
int gnum_of_closed_pats;

//CFP-tree statistics
int gntree_size;
int gntree_page_size;
int gnum_of_entries;
int gnmax_tree_depth;
int gnmax_dfsentries_len;
int gnmax_dfs_sup_sum;
int gnum_of_freq_items;

//time statistics
int gntotal_call;
double gdbuild_cfptree_time;
double gdgen_hypotheses_time;
double gdanalyze_hypotheses_time;

double gdgen_tidlist_time;
double gdperm_time;
double gdgen_rule_time;
double gdsort_rule_time;
double gdgen_rep_rule_time;
double gdtotal_run_time;
int gnborder_check_times;


//space statistics
double gdused_mem_size;
double gdmax_used_mem_size;
double gdbuild_tree_max_mem_size;
double gdgenH_max_mem_size;
double gdanalyzeH_max_mem_size;

double gdgen_tidlist_max_mem_size;
double gdgenrule_max_mem_size;
double gdsort_rule_max_mem_size;
double gdgen_rep_rule_max_mem_size;
int gntree_init_size;
int gntree_max_size;


//====== global varibles
int gntgt_attr_no;
int gntgt_attr_type;
int gnum_of_tgt_values;
int gntgt_stat_size;
vector<string> *gsztgt_values;
char* gptgt_stat_array;
double gdconf;

int gnum_of_cmp_attrs;

ATTRIBUTE* gpAttributes;
char *gszattr_name_buf;
int gnattr_name_buf_size;
int gnum_of_attrs;

ATTR_VALUE* gpAttrValues;
char *gszattr_value_buf;
int gnattr_value_buf_size;
int gnum_of_items;
map<string, int> *gpattr2id_map;
map<string, int> *gpattrvalue2item_map;

int comp_int_asc(const void *e1, const void *e2)
{
	int n1, n2;
	n1 = *(int*) e1;
	n2 = *(int*) e2;

	if (n1>n2)
		return 1;
	else if (n1<n2)
		return -1;
	else
		return 0;
}

void OutputPat(FILE *fp, int* ppat, int nlen, int nsup)
{
	int i;

	fprintf(fp, "%d ", nlen);
	for(i=0;i<nlen;i++)
		fprintf(fp, "%d ", ppat[i]);
	fprintf(fp, "%d\n", nsup);
}


int get_intersection(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set)
{
	int i, j, nresult_len;

	i = 0;
	j = 0;
	nresult_len = 0;
	while(i<nlen1 && j<nlen2)
	{
		if(pset1[i]<pset2[j])
			i++;
		else if(pset1[i]>pset2[j])
			j++;			
		else
		{
			presult_set[nresult_len++] = pset1[i++];
			j++;
		}
	}

	return nresult_len;
}

int get_union(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set)
{
	int i, j, nresult_len;

	i = 0;
	j = 0;
	nresult_len = 0;
	while(i<nlen1 && j<nlen2)
	{
		if(pset1[i]==pset2[j])
		{
			presult_set[nresult_len++] = pset1[i++];
			j++;
		}
		else if(pset1[i]<pset2[j])
			presult_set[nresult_len++] = pset1[i++];
		else 
			presult_set[nresult_len++] = pset2[j++];
	}
	while(i<nlen1)
		presult_set[nresult_len++] = pset1[i++];
	while(j<nlen2)
		presult_set[nresult_len++] = pset2[j++];

	return nresult_len;
}


int get_diffset(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set)
{
	int i, j, nresult_len;

	i = 0;
	j = 0;
	nresult_len = 0;
	while(i<nlen1 && j<nlen2)
	{
		if(pset1[i]<pset2[j])
			presult_set[nresult_len++] = pset1[i++];
		else if(pset1[i]==pset2[j])
		{
			i++;
			j++;
		}
		else 
			j++;
	}
	while(i<nlen1)
		presult_set[nresult_len++] = pset1[i++];

	return nresult_len;
}


int get_intersectNdiffset(int nlen1, int *pset1, int nlen2, int *pset2, int* presult_set, int *pdiff_set, int &ndiff_len)
{
	int i, j, nlen;

	i = 0;
	j = 0;
	nlen = 0;
	ndiff_len = 0;
	while (i<nlen1 && j<nlen2)
	{
		if (pset1[i] == pset2[j])
		{
			presult_set[nlen++] = pset1[i++];
			j++;
		}
		else if (pset1[i]<pset2[j])
		{
			pdiff_set[ndiff_len++] = pset1[i];
			i++;
		}
		else
			j++;
	}
	while (i<nlen1)
		pdiff_set[ndiff_len++] = pset1[i++];

	return nlen;
}



