#pragma once 

#pragma warning (disable:4996)

#include <string>
#include <vector>
#include <map>
using namespace std;

#include <stdio.h>

//----- parameter settings
extern char gszdata_filename[200];
extern char gsznames_filename[200];
extern map<string, int> *gpcontext_attr_map;
extern map<string, int> *gpcomparing_attr_map;
extern char gsztarget_attr[100];
extern char gsztarget_value[100];
extern int gnsignal_type;
#define IS_HYPOTHESIS 0
#define IS_RULE 1

extern double gdmin_sup;
extern int gnmin_sup;
extern double gdmin_diff;
extern double gdmax_pvalue;
extern int gnmax_len;


extern char gszoutput_filename[200];

extern int gnmaterialization_mode;  
#define FREQ_ONLY 0
#define FREQ_N_INFREQ_BORDER 1

extern int gncompare_mode;
#define PAIR_WISE 0
#define ATTRIBUTE_WISE 1

extern int gntest_statisitic_method;
#define X2_TEST 0
#define FISHER_EXACT_TEST 1

extern int gnPVALUE_BUF_SIZE;

extern int gneffect_size_method;
#define CONFIDENCE 0
#define ODDS_RATIO 1

extern int gnoutput_mode;
#define OUTPUT_ALL 0
#define OUTPUT_CLOSED 1
#define OUTPUT_CLOSED_N_SINGLETON 2
#define OUTPUT_REPRESENTATIVE 3


//=== not in use in the API
#define REP_ITEM 0
#define REP_TIDLIST 1
#define REP_COLLECTIVE 2

extern double gdmax_local_pvalue;

extern int gncorrection_method;
#define PERMUTATION 0
#define PERMUTATION_SUPERSET 1
#define SIMULATED_PERM 2
#define SIMULATED_PERM_SUBSET 3
#define SIMULATED_PERM_SUBSET_SIB 4
#define SIMULATED_PERM_SUBSET_LEFT_SIB 5
#define SIMULATED_PERM_SUBSET_ALLSIB 6
#define SIMULATED_PERM_SUPERSET 7
#define SIMULATED_PERM_HYBRID 8
#define SIMULATED_PERM_SUBSETS 9

extern bool gbdiff_tid_list;
extern int gnum_of_repetitions;

extern int gnseeding_method;
#define SEEDING_GLOBAL 0
#define SEEDING_PER_RULE 1
#define SEEDING_PER_PERM 2

extern int gndata_perm_method;
#define DATA_PERM_RAND_TID 0
#define DATA_PERM_RAND_TID_CLASS 1
#define DATA_PERM_SWAP 2

extern bool gbgen_tid_list;
//===

//----- 

extern bool gbrule_multiclass_pairwise;


struct TGT_SUM
{
	double dsum;
	double dsquare_sum;
};

union TGT_UNION
{
	int ntgt_sup; //nominal or ordinal attribute with target attribute value given 
	int *ptgt_sups; //nominal or ordinal attribute without specified target attribute value
	TGT_SUM *ptgt_sum; //continuous attribute
};


//data some statistics
extern int gndb_size;
extern double gdtotal_sum;
extern double gdtotal_square_sum;
extern TGT_UNION gtgt_stat;
extern int gnmax_item_num_per_attr;

//CFP-tree statistics
extern int gntree_size;
extern int gntree_page_size;
extern int gnum_of_entries;
extern int gnmax_tree_depth;
extern int gnmax_dfsentries_len;
extern int gnmax_dfs_sup_sum;
extern int gnum_of_freq_items;

//pattern statistics
extern int gnmax_pattern_len;
extern int gnmax_sup;
extern int gnfreq_pat_num;
extern int gnnonclosed_freq_pat_num;
extern int gninfreq_pat_num;
extern int gnum_of_closed_pats;

//time statistics
extern int gntotal_call;
extern double gdbuild_cfptree_time;
extern double gdgen_hypotheses_time;
extern double gdanalyze_hypotheses_time;

extern double gdgen_tidlist_time;
extern double gdperm_time;
extern double gdgen_rule_time;
extern double gdsort_rule_time;
extern double gdgen_rep_rule_time;
extern double gdtotal_run_time;
extern int gnborder_check_times;


//space statistics
extern double gdused_mem_size;
extern double gdmax_used_mem_size;
extern double gdbuild_tree_max_mem_size;
extern double gdgenH_max_mem_size;
extern double gdanalyzeH_max_mem_size;

extern double gdgen_tidlist_max_mem_size;
extern double gdgenrule_max_mem_size;
extern double gdsort_rule_max_mem_size;
extern double gdgen_rep_rule_max_mem_size;
extern int gntree_init_size;
extern int gntree_max_size;


//====== global variables
extern int gntgt_attr_no;
extern int gntgt_attr_type;
extern int gnum_of_tgt_values;
extern int gntgt_stat_size;
extern vector<string> *gsztgt_values;
extern char* gptgt_stat_array;
extern double gdconf;


extern int gnum_of_cmp_attrs;

#define NOMINAL    0
#define ORDINAL    1  //3<=#distinct values<=10, and the values are ordered
#define CONTINUOUS 3
#define CONTINUOUS_NORMAL 4

#define CLT_THRESHOLD  100

struct ATTRIBUTE
{
	char *szattr_name;
	int nattr_no;
	int nattr_type;
	int num_of_values;
	int nstart_item_id;
	int nmax_freq;
	int norder; 
	bool bis_context_attr;
	bool bis_comparing_attr;
};


struct ATTR_VALUE
{
	char *szattr_value;
	int nattr_no;
	int norder;
	int nsup;
	union 
	{
		int ntgt_sup; 
		int *ptgt_sups; 
		TGT_SUM *ptgt_sum; 
	};
	bool bis_context_item;
	bool bis_comparing_item;
};

extern ATTRIBUTE* gpAttributes;
extern char *gszattr_name_buf;
extern int gnattr_name_buf_size;
extern int gnum_of_attrs;

extern ATTR_VALUE* gpAttrValues;
extern char *gszattr_value_buf;
extern int gnattr_value_buf_size;
extern int gnum_of_items;
extern map<string, int> *gpattr2id_map;
extern map<string, int> *gpattrvalue2item_map;
//======


//global varibles
extern int *gpprefix_itemset;
extern int gnprefix_len;
extern int gndepth;
extern int gnnon_context_comp_item_num;
extern int gnother_item_num;
extern int gntree_level;
extern int *gpsingle_branch;
extern int gnfirst_level_len;

extern int *gptransaction;
extern int *gpdfs_item_order_map;

extern map<string, int> *gpattrvalue_item_map;
extern map<string, int> *gptgt_attrvalue_map;

extern double *gptgt_values; //for storing the target value of individual records
extern int *gpint_tgt_values;



int comp_int_asc(const void *e1, const void *e2);

void OutputPat(FILE *fp, int* ppat, int nlen, int nsup);
int get_union(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set);
int get_diffset(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set);
int get_intersection(int nlen1, int *pset1, int nlen2, int *pset2, int *presult_set);



//======== loading routines ============
int GetParameters(char* szpara_filename);
void ReadTreeStatis(char* szcfp_stat_filename);
void LoadAttrNValues(char* szattrvalue_filename);
void LoadAttrType(char *sznames_filename);
void LoadTgtValues(char* sztgtvalue_filename);
void LoadTransTgtValues(char* szoutput_name, void *ptgt_values);
void LoadTransTgtValues(char* szoutput_name);
void DelTransTgtValues();

#define EXCLUDE 0
#define INCLUDE 1
#define OPTIONAL 2
#define IS_COMPARE 4
void LoadFilterConds(char* szfilter_filename, map<string, int> *pname2id_map, char* pbitmap, int nmax_id);
void CheckAttrNValueStatus(char* pattr_bitmap, char* pitem_bitmap);
void LoadCompAttr(char* szcomp_filename, map<string, int> *pname2id_map, char* pbitmap, int nmax_id);
void CheckCompAttrNItems(char* pattr_bitmap, char* pitem_bitmap);

void PickAttrFromPat(int *ppattern, int npat_len, char* pattr_bitmap, char* szattr_name);
void PickAttrOutsidePat(int *ppattern, int npat_len, char* pattr_bitmap, char* szattr_name);
void GenFilterConds(char* szattr_filename, int num_of_include_attrs, char* szitem_filename);
void GenCompAttrs(char *szattr_filename, int num_of_comp_attrs, char* szitem_filename);
//========


//---------
void OpenLogFile();
void LogErrMsg(char* szclass, char* szmethod, char* szerrmsg);
void CloseLogFile();
//---------



//-------- inline routines for memory allocation
inline void IncMemSize(int size)
{
	gdused_mem_size += size;
	if(gdused_mem_size>gdmax_used_mem_size)
		gdmax_used_mem_size = gdused_mem_size;
}
inline void DecMemSize(int size)
{
	gdused_mem_size -= size;
}

inline int* NewIntArray(int length)
{
	IncMemSize(length*sizeof(int));
	return new int[length];
}
inline void DelIntArray(int* parray, int length)
{
	DecMemSize(length*sizeof(int));
	delete []parray;
}
inline int** NewIntPointerArray(int length)
{
	IncMemSize(length*sizeof(int*));
	return new int*[length];
}
inline void DelIntPointerArray(int** ppitemsets, int length)
{
	DecMemSize(length*sizeof(int*));
	delete []ppitemsets;
}
inline int* NewIntArray(int length, int value)
{
	int *parray;

	parray = NewIntArray(length);
	memset(parray, value, sizeof(int)*length);
	return parray;
}
inline char* NewCharArray(int length)
{
	IncMemSize(length*sizeof(char));
	return new char[length];
}
inline void DelCharArray(char* parray, int length)
{
	DecMemSize(length*sizeof(char));
	delete []parray;
}
inline double* NewDoubleArray(int length)
{
	IncMemSize(length*sizeof(double));
	return new double[length];
}
inline void DelDoubleArray(double* parray, int length)
{
	DecMemSize(length*sizeof(double));
	delete []parray;
}
//--------






