#pragma once 

#include <stdio.h>
#include "Global.h"
#include "FPtree.h"

#define CFP_HASH_LEN  31
#define CFP_HASH_MASK  0x7fffffff

#define DEFAULT_TREE_OUTBUF_SIZE		(1<<24)
#define DEFAULT_TREE_BUF_PAGE_SIZE		(1<<12)


struct ENTRY
{
	int support;
	int hash_bitmap;
	int npreorder;
	int child;
	union
	{
		int item;
		int *pitems;
	};
};

typedef struct
{
	ENTRY *pentries;
	int num_of_entries;
	int ncur_order;
	int cfpnode_size;
	int nfull_node_size;
	int ndisk_pos;
	int mem_page_no;
	int mem_page_pos;
	int nprefix_len;
	int nsup_sum;
	char* ptgt_stat_array;
	bool in_mem;
} ACTIVE_NODE;


class CTreeOutBufManager
{
	FILE* mfpcfp_file;
	FILE *mfpread_file;

	int mntree_outbuf_size;
	int mntree_buf_page_size;
	int mntree_buf_num_of_pages;

	char **mptree_buffer;
	int mncapacity, mnpage_size;

	int mndisk_start_pos, mndisk_write_start_pos;
	int mntree_size, mncur_page_no, mncur_page_pos;
	int mnmin_inmem_level; 
	int mnmax_tree_depth, mnum_of_entries;
	int mndfs_entries_len, mnmax_dfsentries_len, mndfs_sup_sum, mnmax_dfs_sup_sum;

	ACTIVE_NODE *mpactive_stack;
	int mnactive_top;

	char *mpitem_bitmap;
	int mnpreorder;

	int FillPage(int node_size);
	void UpdateAncestors(int bitmap);
	void Dump(int newnode_size);
	void DumpAll();
	void OutputTreeStatis();

	bool SearchInBuf(int ndisk_pos, int npat_len);
	bool SearchOnDisk(int ndisk_pos, int npat_len);

	void PruneNonClosedInBuf(int ndisk_pos, int npat_len, int nsupport);
	void PruneNonClosedOnDisk(int ndisk_pos, int npat_len, int nsupport);


public: 

	void Init();
	void PrintfStatistics(FILE *fpsum_file);
	void Destroy();

	void InsertInternalNode(HEADER_NODE* pheader_table, char* ptgt_stat_array, int num_of_items);
	void MoveNext();
	void WriteInternalNode();

	void InsertCommonPrefixNode(int *pitems, int num_of_items, int nsup, char* ptgt_stat);
	void WriteCommonPrefixNode(int num_of_nodes);

	void WriteLeafNode(int *pitems, int num_of_items, int nsup, char* ptgt_stat);

	bool IsOnBorder(int *pitemset, int nlen, int nsup);
	void PruneNonClosed(int *pitemset, int nlen, int nsupport, int nup_level);

	int GetTreeSize();
};

int binary_search(ENTRY *pentries, int nlength, int ntgt_item);

extern CTreeOutBufManager gotree_bufmanager;


//======== inline routines
inline ENTRY* NewEntryArray(int length)
{
	IncMemSize(sizeof(ENTRY)*length);
	return new ENTRY[length];
}
inline void DelEntryArray(ENTRY *pentries, int length)
{
	DecMemSize(sizeof(ENTRY)*length);
	delete []pentries;
}

inline int* NewCFPItemset(int length)
{
	IncMemSize(sizeof(int)*length);
	return new int[length];
}
inline void DelCFPItemset(int *pitemset, int length)
{
	DecMemSize(sizeof(int)*length);
	delete []pitemset;
}
inline char* NewTgtStatArray(int length)
{
	IncMemSize(sizeof(char)*length);
	return new char[length];
}
inline void DelTgtStatArray(char* parray, int length)
{
	DecMemSize(sizeof(char)*length);
	delete []parray;
}

inline ACTIVE_NODE* NewActiveStack(int depth)
{
	IncMemSize(sizeof(ACTIVE_NODE)*depth);
	return new ACTIVE_NODE[depth];
}
inline void DelActiveStack(ACTIVE_NODE* pactive_stack, int depth)
{
	DecMemSize(sizeof(ACTIVE_NODE)*depth);
	delete []pactive_stack;
}

inline char* NewCFPBufPage(int npage_size)
{
	char *pbuf_page;

	IncMemSize(npage_size);
	pbuf_page = new char[npage_size];
	memset(&(pbuf_page[npage_size-sizeof(int)]), 0, sizeof(int));
	return pbuf_page;
}
inline void DelCFPBufPage(char* pbuf_page, int npage_size)
{
	DecMemSize(npage_size);
	delete []pbuf_page;
}
inline char** NewCFPBufPointers(int length)
{
	IncMemSize(length*sizeof(char*));
	return new char*[length];
}
inline void DelCFPBufPointers(char** ppbuf_pointers, int length)
{
	DecMemSize(length*sizeof(char*));
	delete []ppbuf_pointers;
}
//========