
#include <time.h>
#include <sys/timeb.h>
#include <math.h>

#include "gen_tidlist.h"

CTidListGenerator gotidlist_generator;

//------ generating the tid lists of individual items ------
void CTidListGenerator::GenItemTidLists(char* szoutput_name)
{
	char szcfp_stat_filename[200];
	TID_LIST_FULL *ptid_lists;
	struct timeb start, end;
	int i;

	ftime(&start);

	gdused_mem_size = 0;
	gdmax_used_mem_size = 0;
	mnmax_tidlist_len = 0;

	sprintf(szcfp_stat_filename, "%s.cfptree.stat", szoutput_name);
	ReadTreeStatis(szcfp_stat_filename);
	DelCharArray(gptgt_stat_array, gntgt_stat_size);

	if(gntree_size==0)
		return;

	ptid_lists = new TID_LIST_FULL[gnum_of_items];
	IncMemSize(sizeof(TID_LIST_FULL)*gnum_of_items);
	memset(ptid_lists, 0, sizeof(TID_LIST_FULL)*gnum_of_items);
	GetItemSup(szoutput_name, ptid_lists);
	
	for(i=0;i<gnum_of_items;i++)
	{
		if(ptid_lists[i].nlen>0 && ptid_lists[i].nlen<gndb_size)
			ptid_lists[i].ptid_list = NewIntArray(ptid_lists[i].nlen);
	}

	GenItemTidLists(szoutput_name, ptid_lists);

	OutputItemTidLists(ptid_lists, szoutput_name);

	for(i=0;i<gnum_of_items;i++)
	{
		if(ptid_lists[i].ptid_list!=NULL)
			DelIntArray(ptid_lists[i].ptid_list, ptid_lists[i].nlen);
	}
	delete []ptid_lists;
	DecMemSize(sizeof(TID_LIST_FULL)*gnum_of_items);


	ftime(&end);
	gdgen_tidlist_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;
	gdgen_tidlist_max_mem_size = gdmax_used_mem_size;

	if(gdused_mem_size!=0)
		printf("Error: there are unreleased memory\n");

	printf("Time for generating single items' tid-lists: %f\n", gdgen_tidlist_time);
	printf("#lists: %d\n", gnum_of_items);
	printf("\n");

}

void CTidListGenerator::GetItemSup(char* szoutput_name, TID_LIST_FULL *ptid_lists)
{
	FILE *fp;
	char szitemsup_filename[200];
	int i;

	sprintf(szitemsup_filename, "%s.itemsup", szoutput_name);
	fp = fopen(szitemsup_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szitemsup_filename);
		return;
	}

	for(i=0;i<gnum_of_items;i++)
		fscanf(fp, "%d", &ptid_lists[i].nlen);
	fclose(fp);

}

void CTidListGenerator::GenItemTidLists(char* szoutput_name, TID_LIST_FULL *ptid_lists)
{
	FILE *fp;
	char sztdb_filename[200];
	int i, nlen, nitem, ntid, *ptid_list_lens;

	sprintf(sztdb_filename, "%s.tdb", szoutput_name);
	fp = fopen(sztdb_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztdb_filename);
		return;
	}

	ptid_list_lens = NewIntArray(gnum_of_items, 0);

	ntid = 0;
	fread(&nlen, sizeof(int), 1, fp);
	while(!feof(fp))
	{
		for(i=0;i<nlen;i++)
		{
			fread(&nitem, sizeof(int), 1, fp);
			if(ptid_lists[nitem].ptid_list!=NULL)
				ptid_lists[nitem].ptid_list[ptid_list_lens[nitem]++] = ntid;
		}

		ntid++;
		fread(&nlen, sizeof(int), 1, fp);
	}
	fclose(fp);

	for(i=0;i<gnum_of_items;i++)
	{
		if(ptid_lists[i].ptid_list!=NULL && ptid_list_lens[i]!=ptid_lists[i].nlen)
			printf("Error: inconsistent tid list length: %d %d\n", ptid_list_lens[i], ptid_lists[i].nlen);
	}

	DelIntArray(ptid_list_lens, gnum_of_items);
}

void CTidListGenerator::OutputItemTidLists(TID_LIST_FULL *ptid_lists, char* szoutput_name)
{
	FILE *fp;
	char szoutput_filename[200];
	ITEM_TLIST_DIR_NODE *ptid_list_dir;
	int i, ntid_list_pos;

	sprintf(szoutput_filename, "%s.item.tidlist", szoutput_name);
	fp = fopen(szoutput_filename, "wb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	ptid_list_dir = new ITEM_TLIST_DIR_NODE[gnum_of_items];
	IncMemSize(sizeof(ITEM_TLIST_DIR_NODE)*gnum_of_items);

	ntid_list_pos = 0;
	for(i=0;i<gnum_of_items;i++)
	{
		ptid_list_dir[i].nlen = ptid_lists[i].nlen;
		if(ptid_lists[i].ptid_list!=NULL)
		{
			ptid_list_dir[i].ndisk_pos = ntid_list_pos;
			fwrite(ptid_lists[i].ptid_list, sizeof(int), ptid_lists[i].nlen, fp);
			ntid_list_pos += sizeof(int)*ptid_lists[i].nlen;
		}
	}
	fclose(fp);

	sprintf(szoutput_filename, "%s.item.tidlist.dir", szoutput_name);
	fp = fopen(szoutput_filename, "wb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	fwrite(ptid_list_dir, sizeof(ITEM_TLIST_DIR_NODE), gnum_of_items, fp);

	fclose(fp);

	delete []ptid_list_dir;
	DecMemSize(sizeof(ITEM_TLIST_DIR_NODE)*gnum_of_items);
}


/*=======================================================
Generate the full tid list of all entries, no matter whether
it is closed or not.
========================================================*/
void CTidListGenerator::GenPatTidLists(char* szoutput_name)
{
	char szcfp_filename[200], szcfp_stat_filename[200], sztid_list_filename[200];
	ENTRY *pentries;
	int num_of_entries, nfile_pos, i;
	TID_LIST_FULL *ptid_lists;
	struct timeb start, end;

	ftime(&start);

	gdused_mem_size = 0;
	gdmax_used_mem_size = 0;
	mndfs_list_len = 0;
	mnmax_dfs_list_len = 0;
	mnmax_tidlist_len = 0;

	sprintf(szcfp_stat_filename, "%s.cfptree.stat", szoutput_name);
	ReadTreeStatis(szcfp_stat_filename);
	DelCharArray(gptgt_stat_array, gntgt_stat_size);

	if(gntree_size==0)
		return;

	sprintf(szcfp_filename, "%s.cfptree", szoutput_name);
	mfpcfp_file = fopen(szcfp_filename, "rb");
	if(mfpcfp_file==NULL)
	{
		printf("Error: cannot open file %s for read\n", szcfp_filename);
		return;
	}

	sprintf(sztid_list_filename, "%s.tidlist", szoutput_name);
	mfp_list = fopen(sztid_list_filename, "wb");
	if(mfp_list==NULL)
	{
		printf("Error: cannot open file %s for write\n", sztid_list_filename);
		return;
	}

	mpentry_buf = NewEntryArray(gnmax_dfsentries_len);
	mptid_list_buf = new TID_LIST_FULL[gnmax_dfsentries_len];
	IncMemSize(sizeof(TID_LIST_FULL)*gnmax_dfsentries_len);
	mnentry_buf_pos = 0;
	mptidlist_dir_nodes = new PAT_DIR_NODE[gnum_of_entries];
	IncMemSize(sizeof(PAT_DIR_NODE)*gnum_of_entries);
	for(i=0;i<gnum_of_entries;i++)
	{
		mptidlist_dir_nodes[i].nflag = (1<<CLOSED_FLAG_BITPOS);
		mptidlist_dir_nodes[i].nparent_preorder = -1;
		mptidlist_dir_nodes[i].ntidlist_pos = 0;
	}
	memset(mptidlist_dir_nodes, 0, sizeof(PAT_DIR_NODE)*gnum_of_entries);
	mntidlist_pos = 0;

	pentries = mpentry_buf;
	ptid_lists = mptid_list_buf;

	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);
	if(num_of_entries<0)
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
	else
		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);

	if((num_of_entries==1 || num_of_entries<0) && pentries[0].support==gndb_size && pentries[0].child!=0)
	{
		nfile_pos = ftell(mfpcfp_file);
		if(nfile_pos!=pentries[0].child)
			fseek(mfpcfp_file, pentries[0].child-nfile_pos, SEEK_CUR);
		fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);
		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
	}

	if(num_of_entries>1)
	{
		for(i=0;i<num_of_entries;i++)
			ptid_lists[i].ptid_list = NewIntArray(pentries[i].support);
		GenItemTidLists(szoutput_name, pentries, ptid_lists, num_of_entries);
		mnentry_buf_pos += num_of_entries;
		for(i=0;i<num_of_entries;i++)
		{
			if(pentries[i].support>=gnmin_sup)
			{
				if(pentries[i].child!=0)
					gen_pat_tid_list(&pentries[i], &ptid_lists[i], gndb_size, pentries, ptid_lists, i);
				else
				{
					OutputOneTidList(pentries[i].npreorder, gndb_size, &ptid_lists[i]);
					if(mnmax_dfs_list_len<mndfs_list_len+ptid_lists[i].nlen)
						mnmax_dfs_list_len = mndfs_list_len+ptid_lists[i].nlen;
				}
			}
		}
		for(i=0;i<num_of_entries;i++)
			DelIntArray(ptid_lists[i].ptid_list, ptid_lists[i].nlen);
		mnentry_buf_pos -= num_of_entries;
	}
	else if(pentries[0].support<gndb_size && pentries[0].support>=gnmin_sup)
	{
		ptid_lists[0].ptid_list = NewIntArray(pentries[0].support);
		GenItemTidLists(szoutput_name, pentries, ptid_lists, 1);
		OutputOneTidList(pentries->npreorder, gndb_size, &ptid_lists[0]);
		mnmax_dfs_list_len = ptid_lists[0].nlen;
		if(pentries[0].child!=0)
			printf("Error: the child of the entry should be 0\n");
		DelIntArray(ptid_lists[0].ptid_list, ptid_lists[0].nlen);
	}

	fclose(mfpcfp_file);
	fclose(mfp_list);

	delete []mptid_list_buf;
	DecMemSize(sizeof(TID_LIST_FULL)*gnmax_dfsentries_len);
	DelEntryArray(mpentry_buf, gnmax_dfsentries_len);

	OutputTidListPos(szoutput_name, mptidlist_dir_nodes, gnum_of_entries);
	delete []mptidlist_dir_nodes;
	DecMemSize(sizeof(PAT_DIR_NODE)*gnum_of_entries);

	ftime(&end);
	gdgen_tidlist_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;
	gdgen_tidlist_max_mem_size = gdmax_used_mem_size;

	if(gdused_mem_size!=0)
		printf("Error: there are unreleased memory\n");

	printf("Time for generating tid-lists: %f\n", gdgen_tidlist_time);
	printf("#lists: %d\n", mnum_of_lists);
	printf("\n");
}


//generate the tid-list of single items from tdb file
void CTidListGenerator::GenItemTidLists(char* szoutput_name, ENTRY *pentries, TID_LIST_FULL *ptid_lists, int num_of_entries)
{
	FILE *fp;
	char sztdb_filename[200];
	int i, nlen, nitem, ntid, *pitem_order_map, norder;

	sprintf(sztdb_filename, "%s.tdb", szoutput_name);
	fp = fopen(sztdb_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztdb_filename);
		return;
	}

	pitem_order_map = NewIntArray(gnum_of_items, -1);
	for(i=0;i<num_of_entries;i++)
	{
		ptid_lists[i].nlen = 0;
		pitem_order_map[pentries[i].item] = i;
	}

	ntid = 0;
	fread(&nlen, sizeof(int), 1, fp);
	while(!feof(fp))
	{
		for(i=0;i<nlen;i++)
		{
			fread(&nitem, sizeof(int), 1, fp);
			norder = pitem_order_map[nitem];
			if(norder>=0 && ptid_lists[norder].ptid_list!=NULL)
				ptid_lists[norder].ptid_list[ptid_lists[norder].nlen++] = ntid;
		}

		ntid++;
		fread(&nlen, sizeof(int), 1, fp);
	}
	fclose(fp);
	DelIntArray(pitem_order_map, gnum_of_items);

	for(i=0;i<num_of_entries;i++)
	{
		if(ptid_lists[i].ptid_list!=NULL && pentries[i].support!=ptid_lists[i].nlen)
			printf("Error: inconsistent tid list length\n");
	}
}


void CTidListGenerator::gen_pat_tid_list(ENTRY* pparent_entry, TID_LIST_FULL *pparent_list, int ngrandparent_sup, ENTRY *pcandidate_entries, TID_LIST_FULL *pcandidate_tid_lists, int num_of_candidate_entries)
{
	ENTRY *pentries;
	TID_LIST_FULL *ptid_lists;
	int num_of_entries, nfile_pos, i, j;

	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=pparent_entry->child)
		fseek(mfpcfp_file, pparent_entry->child-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptid_lists = &mptid_list_buf[mnentry_buf_pos];

	if(num_of_entries==1 || num_of_entries<0)
	{
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
		if(pentries->support<pparent_entry->support)
		{
			OutputOneTidList(pparent_entry->npreorder, ngrandparent_sup, pparent_list);
			mndfs_list_len += pparent_list->nlen;
			if(mnmax_dfs_list_len<mndfs_list_len)
				mnmax_dfs_list_len = mndfs_list_len;

			if(pentries->support>=gnmin_sup)
			{
				j = 0;
				while(j<num_of_candidate_entries && pcandidate_entries[j].item!=pentries[0].item)
					j++;
				if(j>=num_of_candidate_entries)
					printf("Error: cannot find item %d in the parent entries\n", pentries[0].item);
				else
				{
					IntersectTidLists(pparent_list, &pcandidate_tid_lists[j], ptid_lists, pentries[0].support);
					if(pentries[0].child!=0)
					{
						mnentry_buf_pos++;
						gen_pat_tid_list(pentries, ptid_lists, pparent_entry->support, pcandidate_entries, pcandidate_tid_lists, num_of_candidate_entries);
						mnentry_buf_pos--;
					}
					else
					{
						OutputOneTidList(pentries[0].npreorder, pparent_entry->support, ptid_lists);
						if(mnmax_dfs_list_len<mndfs_list_len+ptid_lists->nlen)
							mnmax_dfs_list_len = mndfs_list_len+ptid_lists->nlen;
					}
					DelIntArray(ptid_lists->ptid_list, ptid_lists->nlen);
				}
			}
			mndfs_list_len -= pparent_list->nlen;
		}
		else
		{
			mptidlist_dir_nodes[pparent_entry->npreorder].ntidlist_pos = mntidlist_pos;
			ptid_lists = pparent_list;
			if(pentries[0].child!=0)
			{
				mnentry_buf_pos++;
				gen_pat_tid_list(pentries, ptid_lists, ngrandparent_sup, pcandidate_entries, pcandidate_tid_lists, num_of_candidate_entries);
				mnentry_buf_pos--;
			}
			else
			{
				OutputOneTidList(pentries[0].npreorder, ngrandparent_sup, ptid_lists);
				if(mnmax_dfs_list_len<mndfs_list_len+ptid_lists->nlen)
					mnmax_dfs_list_len = mndfs_list_len+ptid_lists->nlen;
			}
		}
	}
	else if(num_of_entries>1)
	{
		OutputOneTidList(pparent_entry->npreorder, ngrandparent_sup, pparent_list);
		mndfs_list_len += pparent_list->nlen;
		if(mnmax_dfs_list_len<mndfs_list_len)
			mnmax_dfs_list_len = mndfs_list_len;

		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
		mnentry_buf_pos += num_of_entries;

		j = 0;
		for(i=0;i<num_of_entries;i++)
		{
			if(pentries[i].support>=gnmin_sup)
			{
				ptid_lists[i].nlen = 0;
				while(j<num_of_candidate_entries && pcandidate_entries[j].item<pentries[i].item)
					j++;
				if(j>=num_of_candidate_entries || pcandidate_entries[j].item>pentries[i].item)
					printf("Error: cannot find item %d in the candidate items\n", pentries[i].item);
				else
				{
					IntersectTidLists(pparent_list, &pcandidate_tid_lists[j], &ptid_lists[i], pentries[i].support);
					if(pentries[i].child!=0)
						gen_pat_tid_list(&pentries[i], &ptid_lists[i], pparent_entry->support, pentries, ptid_lists, i);
					else
					{
						OutputOneTidList(pentries[i].npreorder, pparent_entry->support, &ptid_lists[i]);
						if(mnmax_dfs_list_len<mndfs_list_len+ptid_lists[i].nlen)
							mnmax_dfs_list_len = mndfs_list_len+ptid_lists[i].nlen;
					}
				}
			}
		}
		for(i=0;i<num_of_entries;i++)
			DelIntArray(ptid_lists[i].ptid_list, ptid_lists[i].nlen);
		mnentry_buf_pos -= num_of_entries;
		mndfs_list_len -= pparent_list->nlen;
	}
	else
		printf("Error with number of entires\n");
}

void CTidListGenerator::IntersectTidLists(TID_LIST_FULL *ptid_list1, TID_LIST_FULL *ptid_list2, TID_LIST_FULL *presult_tid_list, int nresult_len)
{
	int i, j;

	if(ptid_list1->nlen==nresult_len)
		printf("Error: the two lists cann be of the same length\n");

	i = 0;
	j = 0;
	presult_tid_list->nlen = 0;
	presult_tid_list->ptid_list = NewIntArray(nresult_len);
	
	while(i<ptid_list1->nlen && j<ptid_list2->nlen)
	{
		if(ptid_list1->ptid_list[i]==ptid_list2->ptid_list[j])
		{
			presult_tid_list->ptid_list[presult_tid_list->nlen++] = ptid_list1->ptid_list[i];
			i++;
			j++;
		}
		else if(ptid_list1->ptid_list[i]<ptid_list2->ptid_list[j])
			i++;
		else
			j++;
	}

	if(nresult_len!=presult_tid_list->nlen)
		printf("Error: inconsistent list length\n");
}

void CTidListGenerator::OutputOneTidList(int nentry_no, int nparent_sup, TID_LIST_FULL *ptid_list)
{
	if(nentry_no<0 || nentry_no>=gnum_of_entries)
		printf("Error with preorder\n");

	mnum_of_lists++;
	if(mnmax_tidlist_len<ptid_list->nlen)
		mnmax_tidlist_len = ptid_list->nlen;

	mptidlist_dir_nodes[nentry_no].ntidlist_pos = mntidlist_pos;

	fwrite(&ptid_list->nlen, sizeof(int), 1, mfp_list);
	fwrite(ptid_list->ptid_list, sizeof(int), ptid_list->nlen, mfp_list);

	mntidlist_pos += (ptid_list->nlen+1)*sizeof(int);

}

void CTidListGenerator::OutputTidListPos(char *szoutput_name, PAT_DIR_NODE *ptidlist_dir_nodes, int ntotal_entries)
{
	FILE *fp;
	char szoutput_filename[200];

	sprintf(szoutput_filename, "%s.tidlist.dir", szoutput_name);
	fp = fopen(szoutput_filename, "wb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	fwrite(&ntotal_entries, sizeof(int), 1, fp);
	fwrite(&mnum_of_lists, sizeof(int), 1, fp);
	fwrite(&mnmax_dfs_list_len, sizeof(int), 1, fp);
	fwrite(&mnmax_tidlist_len, sizeof(int), 1, fp);

	fwrite(ptidlist_dir_nodes, sizeof(PAT_DIR_NODE), ntotal_entries, fp);

	fclose(fp);
}

//------------------------------------------------------------------
//routines for loading tid lists of entries
int LoadTidListPos(char* sztidlist_pos_filename, PAT_DIR_NODE *&ptidlist_dir_nodes, int &nmax_tidlist_len)
{
	FILE *fp;
	int ntotal_entries, num_of_lists, nmax_dfs_list_len;

	fp = fopen(sztidlist_pos_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztidlist_pos_filename);
		return 0;
	}

	fread(&ntotal_entries, sizeof(int), 1, fp);
	fread(&num_of_lists, sizeof(int), 1, fp);
	fread(&nmax_dfs_list_len, sizeof(int), 1, fp);
	fread(&nmax_tidlist_len, sizeof(int), 1, fp);

	ptidlist_dir_nodes = new PAT_DIR_NODE[ntotal_entries];
	IncMemSize(sizeof(PAT_DIR_NODE)*ntotal_entries);

	fread(ptidlist_dir_nodes, sizeof(PAT_DIR_NODE), ntotal_entries, fp);

	fclose(fp);

	return ntotal_entries;
}

int LoadTidListHeader(char* sztidlist_pos_filename, FILE* &fp, int &nmax_tidlist_len)
{
	int ntotal_entries, num_of_lists, nmax_dfs_list_len;

	fp = fopen(sztidlist_pos_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztidlist_pos_filename);
		return 0;
	}

	fread(&ntotal_entries, sizeof(int), 1, fp);
	fread(&num_of_lists, sizeof(int), 1, fp);
	fread(&nmax_dfs_list_len, sizeof(int), 1, fp);
	fread(&nmax_tidlist_len, sizeof(int), 1, fp);

	return ntotal_entries;
}

int LoadOneTidListPos(FILE* fp, int npreorder)
{
	PAT_DIR_NODE pat_dir_node;
	int ndisk_pos, ncur_pos;

	ndisk_pos = sizeof(int)*4+sizeof(PAT_DIR_NODE)*npreorder;

	ncur_pos = ftell(fp);
	if(ndisk_pos!=ncur_pos)
		fseek(fp, ndisk_pos-ncur_pos, SEEK_CUR);

	fread(&pat_dir_node, sizeof(PAT_DIR_NODE), 1, fp);

	return pat_dir_node.ntidlist_pos;
}


int LoadOneTidList(FILE *fp, int ndisk_pos, int *ptid_list)
{
	int nfile_pos, nlist_len;

	nfile_pos = ftell(fp);
	if(nfile_pos!=ndisk_pos)
		fseek(fp, ndisk_pos-nfile_pos, SEEK_CUR);

	fread(&nlist_len, sizeof(int), 1, fp);
	fread(ptid_list, sizeof(int), nlist_len, fp);

	return nlist_len;
}

int LoadOneTidList(FILE *fpdir, FILE *fptidlist, int npreorder, int *ptid_list, int nlist_len)
{
	int nloaded_list_len, ntidlist_disk_pos;

	ntidlist_disk_pos = LoadOneTidListPos(fpdir, npreorder);
	nloaded_list_len = LoadOneTidList(fptidlist, ntidlist_disk_pos, ptid_list);
	if(nlist_len!=nloaded_list_len)
		LogErrMsg("", "LoadOneTidList", "Error: inconsistent tid list length");

	return nloaded_list_len;
}


//======================================================================
//routines for loading tid lists of items
int LoadItemListPos(char *szinput_name, TIDLIST_NODE *ptidlist_nodes, int num_of_items)
{
	char szdir_filename[200], szerrmsg[200];
	FILE *fp;
	int i, nfile_pos, ndisk_pos;

	sprintf(szdir_filename, "%s.item.tidlist.dir", szinput_name);
	fp = fopen(szdir_filename, "rb");
	if(fp==NULL)
	{
		sprintf(szerrmsg, "Error: cannot open file %s for read.", szdir_filename);
		LogErrMsg("", "LoadItemListPos", szerrmsg);
		return -1;
	}

	for(i=0;i<num_of_items;i++)
	{
		nfile_pos = ftell(fp);
		ndisk_pos = ptidlist_nodes[i].nitem*sizeof(ITEM_TLIST_DIR_NODE);
		if(ndisk_pos!=nfile_pos)
			fseek(fp, ndisk_pos-nfile_pos, SEEK_CUR);
		fread(&ptidlist_nodes[i].ndisk_pos, sizeof(int), 1, fp);
		fread(&ptidlist_nodes[i].nitem_tidlist_len, sizeof(int), 1, fp);
	}

	fclose(fp);

	return 0;
}

int LoadOneItemListPos(FILE *fp, int nitem, int &ntidlist_len)
{
	int nfile_pos, ndisk_pos;

	nfile_pos = ftell(fp);
	ndisk_pos = nitem*sizeof(ITEM_TLIST_DIR_NODE);
	if(ndisk_pos!=nfile_pos)
		fseek(fp, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(&ndisk_pos, sizeof(int), 1, fp);
	fread(&ntidlist_len, sizeof(int), 1, fp);

	return ndisk_pos;
}

void LoadItemTidlists(char* szinput_name, TIDLIST_NODE *ptidlist_nodes, int num_of_items)
{
	char sztidlist_filename[200], szerrmsg[200];
	FILE *fp;
	int i, nfile_pos;

	sprintf(sztidlist_filename, "%s.item.tidlist", szinput_name);
	fp = fopen(sztidlist_filename, "rb");
	if(fp==NULL)
	{
		sprintf(szerrmsg, "Error: cannot open file %s for read.", sztidlist_filename);
		LogErrMsg("", "LoadOneItemTidlist", szerrmsg);
		return;
	}

	for(i=0;i<num_of_items;i++)
	{
		nfile_pos = ftell(fp);
		if(ptidlist_nodes[i].ndisk_pos!=nfile_pos)
			fseek(fp, ptidlist_nodes[i].ndisk_pos-nfile_pos, SEEK_CUR);
		ptidlist_nodes[i].pitem_tid_list = NewIntArray(ptidlist_nodes[i].nitem_tidlist_len);
		fread(ptidlist_nodes[i].pitem_tid_list, sizeof(int), ptidlist_nodes[i].nitem_tidlist_len, fp);
	}

	fclose(fp);
}

void LoadOneItemTidlist(FILE *fp, int ndisk_pos, int *ptid_list, int nlist_len)
{
	int nfile_pos;

	nfile_pos = ftell(fp);
	if(ndisk_pos!=nfile_pos)
		fseek(fp, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(ptid_list, sizeof(int), nlist_len, fp);
}



int GenTidList(FILE *fp, TIDLIST_NODE *pnodes, int num_of_items, int *ptid_list, int *pitem_tid_list, int nsup_lowerbound)
{
	int i, ntidlist_len;

	ntidlist_len = 0;
	for(i=0;i<num_of_items;i++)
	{
		if(pnodes[i].nitem_tidlist_len!=gndb_size)
		{
			LoadOneItemTidlist(fp, pnodes[i].ndisk_pos, pitem_tid_list, pnodes[i].nitem_tidlist_len);
			if(ntidlist_len>0)
				ntidlist_len = get_intersection(ntidlist_len, ptid_list, pnodes[i].nitem_tidlist_len, pitem_tid_list, ptid_list);
			else 
			{
				ntidlist_len = pnodes[i].nitem_tidlist_len;
				memcpy(ptid_list, pitem_tid_list, sizeof(int)*ntidlist_len);
			}
			if(ntidlist_len==nsup_lowerbound)
				break;
		}
	}

	return ntidlist_len;
}

