#pragma once 

#include "Global.h"
#include "cfptree_outbuf.h"


#define CLOSED_FLAG_BITPOS 0
#define DIFF_LIST_FLAG_BITPOS 1

struct PAT_DIR_NODE
{
	int nflag;
	int ntidlist_pos;
	int nparent_preorder;
};

struct TID_LIST_FULL
{
	int nlen;
	int *ptid_list;
};

struct ITEM_TLIST_DIR_NODE
{
	int ndisk_pos;
	int nlen;
};

struct TIDLIST_NODE
{
	int nitem;
	int nstatus;
	int ndisk_pos;
	int nitem_tidlist_len;
	int *pitem_tid_list;
	int ntidlist_len;
	int *ptid_list;
};

class CTidListGenerator
{
	FILE *mfpcfp_file, *mfp_list;
	ENTRY *mpentry_buf;
	int mnentry_buf_pos;
	PAT_DIR_NODE *mptidlist_dir_nodes;
	TID_LIST_FULL *mptid_list_buf;
	int mntidlist_pos, mnum_of_lists, mndfs_list_len, mnmax_dfs_list_len, mnmax_tidlist_len;

	void GenItemTidLists(char* szoutput_name, ENTRY *pentries, TID_LIST_FULL *ptid_lists, int num_of_entries);

	void gen_pat_tid_list(ENTRY* pparent_entry, TID_LIST_FULL *pparent_list, int ngrandparent_sup, ENTRY *pcandidate_entries, TID_LIST_FULL *pcandidate_tid_lists, int num_of_candidate_entries);
	void IntersectTidLists(TID_LIST_FULL *ptid_list1, TID_LIST_FULL *ptid_list2, TID_LIST_FULL *presult_tid_list, int nresult_len);	
	void OutputOneTidList(int nentry_no, int nparent_sup, TID_LIST_FULL *ptid_list);
	void OutputTidListPos(char *szoutput_name, PAT_DIR_NODE *ptidlist_dir_nodes, int ntotal_entries);


	void GetItemSup(char* szoutput_name, TID_LIST_FULL *ptid_lists);
	void GenItemTidLists(char* szoutput_name, TID_LIST_FULL *ptid_lists);
	void OutputItemTidLists(TID_LIST_FULL *ptid_lsits, char* szoutput_name);


public:
	void GenPatTidLists(char* szoutput_name);
	void GenItemTidLists(char* szoutput_name);

};

extern CTidListGenerator gotidlist_generator;

int LoadTidListPos(char* sztidlist_pos_filename, PAT_DIR_NODE *&ptidlist_dir_nodes, int &nmax_tidlist_len);
int LoadOneTidList(FILE *fp, int ndisk_pos, int *ptid_list);

int LoadTidListHeader(char* sztidlist_pos_filename, FILE* &fp, int &nmax_tidlist_len);
int LoadOneTidListPos(FILE* fp, int npreorder);
int LoadOneTidList(FILE *fpdir, FILE *fptidlist, int npreorder, int *ptid_list, int nlist_len);

int LoadItemListPos(char *szinput_name, TIDLIST_NODE *ptidlist_nodes, int num_of_items);
void LoadItemTidlists(char* szinput_name, TIDLIST_NODE *ptidlist_nodes, int num_of_items);
void LoadOneItemTidlist(FILE *fp, int ndisk_pos, int *ptid_list, int nlist_len);
int GenTidList(FILE *fp, TIDLIST_NODE *pnodes, int num_of_items, int* ptid_list, int *pitem_tid_list, int nsup_lowerbound);

int LoadOneItemListPos(FILE *fp, int nitem, int &ntidlist_len);
