#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>


#include "FPtree.h"
#include "cfptree_ehta.h"
#include "output_html.h"
#include "mtc.h"
#include "gen_tidlist.h"

void PrintSummary();

int main(int argc, char *argv[])
{
	FPtree theFPMiner;
	struct timeb start, end;
	
	
	if(argc!=2)
	{
		printf("Usage\n");
		printf("\t%s para_file\n", argv[0]);
		return 0;
	}

	ftime(&start);

	gpcontext_attr_map = NULL;
	gpcomparing_attr_map = NULL;

	GetParameters(argv[1]);

	theFPMiner.MinePats();
	//gocfptree_ehta.Traverse(gszoutput_filename);
	gotidlist_generator.GenItemTidLists(gszoutput_filename);

	if(gnsignal_type==IS_RULE)
	{
		gpsup_testnums = NULL;
		if(gntgt_attr_type==CONTINUOUS && gnmin_sup<CLT_THRESHOLD)
			gotidlist_generator.GenPatTidLists(gszoutput_filename); 
		else if(gbgen_tid_list || gnoutput_mode==OUTPUT_REPRESENTATIVE && gdmax_local_pvalue<1) 
			gomultitest_corrector.GenPatTidLists(gszoutput_filename); //diff_list

		if(gncorrection_method==PERMUTATION || gncorrection_method==PERMUTATION_SUPERSET)
		{
			gomultitest_corrector.GenPermPvalues(gszoutput_filename);
		}
		else
		{
			gocfptree_ehta.GenAssocRules(gszoutput_filename);
		}

		SortRules(gszoutput_filename);

		if(gpsup_testnums!=NULL)
			delete []gpsup_testnums;

	}

	if(gpcontext_attr_map!=NULL)
		delete gpcontext_attr_map;
	if(gpcomparing_attr_map!=NULL)
		delete gpcomparing_attr_map;

	ftime(&end);
	gdtotal_run_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;

	PrintSummary();

	_CrtDumpMemoryLeaks();

	return 0;
}


void PrintSummary()
{
	if(gdused_mem_size!=0)
		printf("Error with memory: %.2f are not released\n", gdused_mem_size);

	FILE *fp_sum, *fp_time;
	char szsum_filename[200];

	if(gnsignal_type==IS_RULE)
	{ 
		if(gncorrection_method==PERMUTATION)
			sprintf(szsum_filename, "rules.perm.sum.txt");
		else if(gncorrection_method==PERMUTATION_SUPERSET)
			sprintf(szsum_filename, "rules.perm-superset.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM)
			sprintf(szsum_filename, "rules.simu.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET)
			sprintf(szsum_filename, "rules.simu-subset.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_SIB)
			sprintf(szsum_filename, "rules.simu-subset-sib.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_LEFT_SIB)
			sprintf(szsum_filename, "rules.simu-subset-left-sib.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_ALLSIB)
			sprintf(szsum_filename, "rules.simu-subset-allsib.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUPERSET)
			sprintf(szsum_filename, "rules.simu-superset.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_HYBRID)
			sprintf(szsum_filename, "rules.simu-hybrid.sum.txt");
		else if(gncorrection_method==SIMULATED_PERM_SUBSETS)
			sprintf(szsum_filename, "rules.simu-subsets.sum.txt");
		else 
			sprintf(szsum_filename, "rules.sum.txt");

		fp_sum = fopen(szsum_filename, "a+");
		if(fp_sum==NULL)
		{
			printf("Error: cannot open file %s for appending\n", szsum_filename);
			return;
		}
		fprintf(fp_sum, "RULE %s ", gszdata_filename);

		fprintf(fp_sum, "PARAMETERS  ");
		fprintf(fp_sum, "%d %d %.3f %.2E %.2E ", gnmin_sup, gnmax_len, gdmin_diff, gdmax_pvalue, gdmax_local_pvalue);
		if(gncorrection_method==PERMUTATION)
			fprintf(fp_sum, "permutation\t");
		else if(gncorrection_method==PERMUTATION_SUPERSET)
			fprintf(fp_sum, "permutation-superset\t");
		else if(gncorrection_method==SIMULATED_PERM)
			fprintf(fp_sum, "simulation\t");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET)
			fprintf(fp_sum, "simu-subset\t");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_SIB)
			fprintf(fp_sum, "simu-subset-sib\t");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_LEFT_SIB)
			fprintf(fp_sum, "simu-subset-left-sib\t");
		else if(gncorrection_method==SIMULATED_PERM_SUBSET_ALLSIB)
			fprintf(fp_sum, "simu-subset-allsib\t");
		else if(gncorrection_method==SIMULATED_PERM_SUPERSET)
			fprintf(fp_sum, "simu-superset\t");
		else if(gncorrection_method==SIMULATED_PERM_HYBRID)
			fprintf(fp_sum, "simu-hybrid\t");
		else if(gncorrection_method==SIMULATED_PERM_SUBSETS)
			fprintf(fp_sum, "simu-subsets\t");
		fprintf(fp_sum, "%.3f ", (double)gnPVALUE_BUF_SIZE/(1<<20));
		if(gbdiff_tid_list==true)
			fprintf(fp_sum, "perm_diff_list=yes\t");
		else
			fprintf(fp_sum, "perm_diff_list=no\t");


		fprintf(fp_sum, "TEST_NUM  ");
		fprintf(fp_sum, "%d\t", gnum_of_tests);

		fprintf(fp_sum, "THRESHOLD  ");
		fprintf(fp_sum, "%.2E %.2E  ", gdBC_pvalue_thres, gdpermFWER_pvalue_thres);
		fprintf(fp_sum, "%.2E %.2E\t", gosign_rule_nums.dBH_pvalue_thres, gosign_rule_nums.dpermBH_pvalue_thres);

		fprintf(fp_sum, "SIGN_RULE_NUM\t");
		fprintf(fp_sum, "%d %d %d  ", gosign_rule_nums.num_of_sign_rules, gosign_rule_nums.num_of_BCsign_rules, gosign_rule_nums.num_of_BHsign_rules);
		fprintf(fp_sum, "%d %d %d %d\t", gosign_rule_nums.num_of_perm_sign_rules, gosign_rule_nums.num_of_perm_BCsign_rules, gosign_rule_nums.num_of_perm_BHsign_rules, gosign_rule_nums.num_of_permFWER_rules);

		fprintf(fp_sum, "RUN_TIME\t");
		fprintf(fp_sum, "%.3f %.3f %.3f %.3f %.3f %.3f %.3f\t", gdtotal_run_time, gdbuild_cfptree_time, gdgen_tidlist_time, gdgen_rule_time, gdsort_rule_time, gdgen_rep_rule_time, gdperm_time);

		fprintf(fp_sum, "MEM_STAT\t");
		fprintf(fp_sum, "%.2fMB %.2fMB %.2fMB %.2fMB  %.2fMB\t", gdbuild_tree_max_mem_size/(1<<20), gdgen_tidlist_max_mem_size/(1<<20), gdgenrule_max_mem_size/(1<<20), gdsort_rule_max_mem_size/(1<<20), gdgen_rep_rule_max_mem_size/(1<<20));

		fprintf(fp_sum, "\n");

		fclose(fp_sum);

		fp_time = fopen("rules.time.txt", "wt");
		if(fp_time==NULL)
			printf("Error: cannot open file 'rules.time.txt' for write\n");
		else
		{
			fprintf(fp_time, "%.4f\n", gdbuild_cfptree_time+gdgen_rule_time+gdsort_rule_time);
			fclose(fp_time);
		}
	}
	else
	{
		fp_sum = fopen("EHTA.sum.txt", "a+");
		if(fp_sum == NULL)
		{
			printf("Error[PrintSummary]: cannot open file fg.sum.txt\n");
			return;
		}
		fprintf(fp_sum, "EHTA %s ", gszdata_filename);

		fprintf(fp_sum, "PARAMETERS  ");
		fprintf(fp_sum, "%d %d %.2E %.2E\t", gnmin_sup, gnmax_len, gdmin_diff, gdmax_pvalue);
		if(gncompare_mode==gncompare_mode)
			fprintf(fp_sum, "pairwise\t");
		else
			fprintf(fp_sum, "attribute-wise\t");

		fprintf(fp_sum, "TEST_NUM  ");
		fprintf(fp_sum, "%d %d\t", gnum_of_contexts, gnum_of_tests);
		//fprintf(fp_sum, "%d %d %d %d\t", gnfreq_pat_num, gnnonclosed_freq_pat_num, gninfreq_pat_num, gnum_of_closed_pats);

		fprintf(fp_sum, "SIGN_RULE_NUM\t");
		fprintf(fp_sum, "%d %d  ", gnum_of_sign_hypotheses, gnum_of_BCsign_hypotheses);
		fprintf(fp_sum, "%d\t", gnum_of_BHsign_hypotheses);

		fprintf(fp_sum, "RUN_TIME\t");
		fprintf(fp_sum, "%.2f ", gdbuild_cfptree_time);
		fprintf(fp_sum, "%.2f %.2f %.4f  ", gdgen_hypotheses_time, gdanalyze_hypotheses_time, gdanalyze_hypotheses_time/gnum_of_sign_hypotheses);
		
		
		fprintf(fp_sum, "MEM_STAT\t");
		fprintf(fp_sum, "%.2fMB %.2fMB %.2fMB\t", gdbuild_tree_max_mem_size/(1<<20), gdgenH_max_mem_size/(1<<20), gdanalyzeH_max_mem_size/(1<<20));
		//fprintf(fp_sum, "%.2fMB %.2fMB\t", (double)gntree_init_size/(1<<20), (double)gntree_max_size/(1<<20));

		fprintf(fp_sum, "\n");
		fclose(fp_sum);
	}
}
