#include <time.h>
#include <sys/timeb.h>
#include <math.h>

#include "global.h"
#include "mtc.h"
#include "cfptree_ehta.h"
#include "pvalue.h"

#include "stocc.h"


int gnlocal_pvalue_buf_size;
double* gplocal_pvalue_buf;
double** gpplocal_sup_pvalues;
bool *gplocal_sup_filled_flags;
int gnlocal_pvalue_cutoff_sup;
double *gplocal_high_sup_pvalues; 
int gnlocal_buffered_high_sup;


CRandomMersenne *gpperm_data_rng;

int gnum_of_randgen_retries;

CMultiTestCorrector  gomultitest_corrector;


void CMultiTestCorrector::GenPatTidLists(char* szoutput_name)
{
	char szcfp_filename[200], szcfp_stat_filename[200], sztid_list_filename[200];
	ENTRY *pentries;
	int num_of_entries, nfile_pos, i, nlist_len, nparent_preorder;
	TID_LIST *ptid_lists;
	struct timeb start, end;

	ftime(&start);

	gdused_mem_size = 0;
	gdmax_used_mem_size = 0;
	mndfs_list_len = 0;
	mnmax_dfs_list_len = 0;
	mnmax_tidlist_len = 0;

	sprintf(szcfp_stat_filename, "%s.cfptree.stat", szoutput_name);
	ReadTreeStatis(szcfp_stat_filename);
	DelCharArray(gptgt_stat_array, gntgt_stat_size);

	if(gntree_size==0)
		return;

	sprintf(szcfp_filename, "%s.cfptree", szoutput_name);
	mfpcfp_file = fopen(szcfp_filename, "rb");
	if(mfpcfp_file==NULL)
	{
		printf("Error: cannot open file %s for read\n", szcfp_filename);
		return;
	}

	sprintf(sztid_list_filename, "%s.tidlist", szoutput_name);
	mfp_list = fopen(sztid_list_filename, "wb");
	if(mfp_list==NULL)
	{
		printf("Error: cannot open file %s for write\n", sztid_list_filename);
		return;
	}

	mpentry_buf = NewEntryArray(gnmax_dfsentries_len);
	mptid_list_buf = new TID_LIST[gnmax_dfsentries_len];
	IncMemSize(sizeof(TID_LIST)*gnmax_dfsentries_len);
	mnentry_buf_pos = 0;
	mppat_dir_nodes = new PAT_DIR_NODE[gnum_of_entries];
	IncMemSize(sizeof(PAT_DIR_NODE)*gnum_of_entries);
	memset(mppat_dir_nodes, 0, sizeof(PAT_DIR_NODE)*gnum_of_entries);
	for(i=0;i<gnum_of_entries;i++)
		mppat_dir_nodes[i].nparent_preorder = -2;
	mntidlist_pos = 0;

	pentries = mpentry_buf;
	ptid_lists = mptid_list_buf;

	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);
	if(num_of_entries<0)
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
	else
		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);

	if((num_of_entries==1 || num_of_entries<0) && pentries[0].support==gndb_size && pentries[0].child!=0)
	{
		mppat_dir_nodes[pentries[0].npreorder].nparent_preorder = -1;
		nparent_preorder = pentries[0].npreorder;
		nfile_pos = ftell(mfpcfp_file);
		if(nfile_pos!=pentries[0].child)
			fseek(mfpcfp_file, pentries[0].child-nfile_pos, SEEK_CUR);
		fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);
		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
	}
	else
		nparent_preorder = -1;

	if(num_of_entries>1)
	{
		for(i=0;i<num_of_entries;i++)
		{
			ptid_lists[i].ptid_list = NewIntArray(pentries[i].support);
			ptid_lists[i].pdiff_list = NULL;
		}
		GenItemTidLists(szoutput_name, pentries, ptid_lists, num_of_entries);
		mnentry_buf_pos += num_of_entries;
		for(i=0;i<num_of_entries;i++)
		{
			mppat_dir_nodes[pentries[i].npreorder].nparent_preorder = nparent_preorder;
			if((pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
			{
				if(pentries[i].child!=0)
					gen_pat_tid_list(&pentries[i], &ptid_lists[i], gndb_size, pentries, ptid_lists, i);
				else
				{
					nlist_len = OutputOneTidList(pentries[i].npreorder, gndb_size, &ptid_lists[i]);
					if(mnmax_dfs_list_len<mndfs_list_len+nlist_len)
						mnmax_dfs_list_len = mndfs_list_len+nlist_len;
				}
			}
		}
		for(i=0;i<num_of_entries;i++)
			DelIntArray(ptid_lists[i].ptid_list, ptid_lists[i].nlen);
		mnentry_buf_pos -= num_of_entries;
	}
	else if(pentries[0].support<gndb_size)// && pentries[0].support>=gnmin_sup)
	{
		mppat_dir_nodes[pentries[0].npreorder].nparent_preorder = nparent_preorder;
		ptid_lists[0].ptid_list = NewIntArray(pentries[0].support);
		ptid_lists[0].pdiff_list = NULL;
		GenItemTidLists(szoutput_name, pentries, ptid_lists, 1);
		nlist_len = OutputOneTidList(pentries->npreorder, gndb_size, &ptid_lists[0]);
		mnmax_dfs_list_len = nlist_len;
		if(pentries[0].child!=0)
			printf("Error: the child of the entry should be 0\n");
		DelIntArray(ptid_lists[0].ptid_list, ptid_lists[0].nlen);
	}

	fclose(mfpcfp_file);
	fclose(mfp_list);

	delete []mptid_list_buf;
	DecMemSize(sizeof(TID_LIST)*gnmax_dfsentries_len);
	DelEntryArray(mpentry_buf, gnmax_dfsentries_len);

	OutputPatDirNodes(szoutput_name, mppat_dir_nodes, gnum_of_entries);
	delete []mppat_dir_nodes;
	DecMemSize(sizeof(PAT_DIR_NODE)*gnum_of_entries);

	ftime(&end);
	gdgen_tidlist_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;
	gdgen_tidlist_max_mem_size = gdmax_used_mem_size;

	if(gdused_mem_size!=0)
		printf("Error: there are unreleased memory\n");

	printf("Time for generating tid-lists: %f\n", gdgen_tidlist_time);
	printf("#lists: %d\n", mnum_of_lists);
	printf("\n");
}

void CMultiTestCorrector::gen_pat_tid_list(ENTRY* pparent_entry, TID_LIST *pparent_list, int ngrandparent_sup, ENTRY *pcandidate_entries, TID_LIST *pcandidate_tid_lists, int num_of_candidate_entries)
{
	ENTRY *pentries;
	TID_LIST *ptid_lists;
	int num_of_entries, nfile_pos, i, j, nparent_list_len, nlist_len;

	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=pparent_entry->child)
		fseek(mfpcfp_file, pparent_entry->child-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptid_lists = &mptid_list_buf[mnentry_buf_pos];

	if(num_of_entries==1 || num_of_entries<0)
	{
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
		mppat_dir_nodes[pentries->npreorder].nparent_preorder = pparent_entry->npreorder;
		if(pentries->support<pparent_entry->support)
		{
			nparent_list_len = OutputOneTidList(pparent_entry->npreorder, ngrandparent_sup, pparent_list);
			mndfs_list_len += nparent_list_len;
			if(mnmax_dfs_list_len<mndfs_list_len)
				mnmax_dfs_list_len = mndfs_list_len;
			if((pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0)
			{
				j = 0;
				while(j<num_of_candidate_entries && pcandidate_entries[j].item!=pentries[0].item)
					j++;
				if(j>=num_of_candidate_entries)
					printf("Error: cannot find item %d in the parent entries\n", pentries[0].item);
				else
				{
					IntersectTidLists(pparent_list, &pcandidate_tid_lists[j], ptid_lists, pentries[0].support);
					if(pentries[0].child!=0)
					{
						mnentry_buf_pos++;
						gen_pat_tid_list(pentries, ptid_lists, pparent_entry->support, pcandidate_entries, pcandidate_tid_lists, num_of_candidate_entries);
						mnentry_buf_pos--;
					}
					else
					{
						nlist_len = OutputOneTidList(pentries[0].npreorder, pparent_entry->support, ptid_lists);
						if(mnmax_dfs_list_len<mndfs_list_len+nlist_len)
							mnmax_dfs_list_len = mndfs_list_len+nlist_len;
					}
					DelIntArray(ptid_lists->ptid_list, ptid_lists->nlen);
					if(ptid_lists->ndiff_len>0)
						DelIntArray(ptid_lists->pdiff_list, ptid_lists->ndiff_len);
				}
			}
			mndfs_list_len -= nparent_list_len;
		}
		else
		{
			if((pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0)
			{
				ptid_lists = pparent_list;
				if(pentries[0].child!=0)
				{
					mnentry_buf_pos++;
					gen_pat_tid_list(pentries, ptid_lists, ngrandparent_sup, pcandidate_entries, pcandidate_tid_lists, num_of_candidate_entries);
					mnentry_buf_pos--;
				}
				else
				{
					nlist_len = OutputOneTidList(pentries[0].npreorder, ngrandparent_sup, ptid_lists);
					if(mnmax_dfs_list_len<mndfs_list_len+nlist_len)
						mnmax_dfs_list_len = mndfs_list_len+nlist_len;
				}
			}			
		}
	}
	else if(num_of_entries>1)
	{
		nparent_list_len = OutputOneTidList(pparent_entry->npreorder, ngrandparent_sup, pparent_list);
		mndfs_list_len += nparent_list_len;
		if(mnmax_dfs_list_len<mndfs_list_len)
			mnmax_dfs_list_len = mndfs_list_len;

		fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
		mnentry_buf_pos += num_of_entries;

		j = 0;
		for(i=0;i<num_of_entries;i++)
		{
			mppat_dir_nodes[pentries[i].npreorder].nparent_preorder = pparent_entry->npreorder;
			ptid_lists[i].nlen = 0;
			ptid_lists[i].ndiff_len = 0;
			while(j<num_of_candidate_entries && pcandidate_entries[j].item<pentries[i].item)
				j++;
			if(j>=num_of_candidate_entries || pcandidate_entries[j].item>pentries[i].item)
				printf("Error: cannot find item %d in the candidate items\n", pentries[i].item);
			else
			{
				IntersectTidLists(pparent_list, &pcandidate_tid_lists[j], &ptid_lists[i], pentries[i].support);
				if((pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
				{
					if(pentries[i].child!=0)
						gen_pat_tid_list(&pentries[i], &ptid_lists[i], pparent_entry->support, pentries, ptid_lists, i);
					else
					{
						nlist_len = OutputOneTidList(pentries[i].npreorder, pparent_entry->support, &ptid_lists[i]);
						if(mnmax_dfs_list_len<mndfs_list_len+nlist_len)
							mnmax_dfs_list_len = mndfs_list_len+nlist_len;
					}
				}
			}
		}
		for(i=0;i<num_of_entries;i++)
		{
			if(ptid_lists[i].nlen>0)
			{
				DelIntArray(ptid_lists[i].ptid_list, ptid_lists[i].nlen);
				if(ptid_lists[i].ndiff_len>0)
					DelIntArray(ptid_lists[i].pdiff_list, ptid_lists[i].ndiff_len);
			}
		}
		mnentry_buf_pos -= num_of_entries;
		mndfs_list_len -= nparent_list_len;
	}
	else
		printf("Error with number of entires\n");
}

void CMultiTestCorrector::IntersectTidLists(TID_LIST *ptid_list1, TID_LIST *ptid_list2, TID_LIST *presult_tid_list, int nresult_len)
{
	int i, j;

	if(ptid_list1->nlen==nresult_len)
		printf("Error: the two lists cann be of the same length\n");

	i = 0;
	j = 0;
	presult_tid_list->nlen = 0;
	presult_tid_list->ptid_list = NewIntArray(nresult_len);
	presult_tid_list->ndiff_len = 0;
	if(nresult_len>ptid_list1->nlen/2)
		presult_tid_list->pdiff_list = NewIntArray(ptid_list1->nlen-nresult_len);
	else
		presult_tid_list->pdiff_list = NULL;
	
	while(i<ptid_list1->nlen && j<ptid_list2->nlen)
	{
		if(ptid_list1->ptid_list[i]==ptid_list2->ptid_list[j])
		{
			presult_tid_list->ptid_list[presult_tid_list->nlen++] = ptid_list1->ptid_list[i];
			i++;
			j++;
		}
		else if(ptid_list1->ptid_list[i]<ptid_list2->ptid_list[j])
		{
			if(presult_tid_list->pdiff_list!=NULL)
				presult_tid_list->pdiff_list[presult_tid_list->ndiff_len++] = ptid_list1->ptid_list[i];
			i++;
		}
		else
			j++;
	}
	if(i<ptid_list1->nlen && presult_tid_list->pdiff_list!=NULL)
	{
		while(i<ptid_list1->nlen)
		{
			presult_tid_list->pdiff_list[presult_tid_list->ndiff_len++] = ptid_list1->ptid_list[i];
			i++;
		}
	}

	if(nresult_len!=presult_tid_list->nlen)
		printf("Error: inconsistent list length\n");
	if(presult_tid_list->pdiff_list!=NULL && presult_tid_list->nlen+presult_tid_list->ndiff_len!=ptid_list1->nlen)
		printf("Error: inconsistent list length\n");
}

int CMultiTestCorrector::OutputOneTidList(int nentry_no, int nparent_sup, TID_LIST *ptid_list)
{
	int i, j, ndiff_len, nlist_len;

	mnum_of_lists++;

	mppat_dir_nodes[nentry_no].nflag |= (1<<CLOSED_FLAG_BITPOS);
	mppat_dir_nodes[nentry_no].ntidlist_pos = mntidlist_pos;
	if(ptid_list->nlen<=nparent_sup/2)
	{
		fwrite(&ptid_list->nlen, sizeof(int), 1, mfp_list);
		fwrite(ptid_list->ptid_list, sizeof(int), ptid_list->nlen, mfp_list);
		mntidlist_pos += (ptid_list->nlen+1)*sizeof(int);
		nlist_len = ptid_list->nlen;
	}
	else
	{
		mppat_dir_nodes[nentry_no].nflag |= (1<<DIFF_LIST_FLAG_BITPOS);
		ndiff_len = nparent_sup-ptid_list->nlen;
		if(nparent_sup==gndb_size)
		{
			fwrite(&ndiff_len, sizeof(int), 1, mfp_list);
			i = 0;
			j = 0;
			while(i<gndb_size && j<ptid_list->nlen)
			{
				if(i==ptid_list->ptid_list[j])
				{
					i++;
					j++;
				}
				else 
				{
					if(i>ptid_list->ptid_list[j])
						printf("Error: i cannot be larger\n");
					fwrite(&i, sizeof(int), 1, mfp_list);
					i++;
				}
			}
			while(i<gndb_size)
			{
				fwrite(&i, sizeof(int), 1, mfp_list);
				i++;
			}
		}
		else
		{
			fwrite(&ndiff_len, sizeof(int), 1, mfp_list);
			fwrite(ptid_list->pdiff_list, sizeof(int), ndiff_len, mfp_list);
		}
		mntidlist_pos += (ndiff_len+1)*sizeof(int);

		nlist_len = ndiff_len;
	}

	if(mnmax_tidlist_len<nlist_len)
		mnmax_tidlist_len = nlist_len;

	return nlist_len;
}

int CMultiTestCorrector::LoadOneTidList(FILE *fp, int ndisk_pos, int *ptid_list)
{
	int nfile_pos, nlist_len;

	//if((mppat_dir_nodes[nentry_no].nflag & (1<<CLOSED_FLAG_BITPOS))==0)
	//{
	//	printf("Error: this entry has no tid list\n");
	//	return 0;
	//}

	nfile_pos = ftell(fp);
	if(nfile_pos!=ndisk_pos)
		fseek(fp, ndisk_pos-nfile_pos, SEEK_CUR);

	fread(&nlist_len, sizeof(int), 1, fp);
	fread(ptid_list, sizeof(int), nlist_len, fp);

	return nlist_len;
}



int CMultiTestCorrector::GetOneTidList(FILE *fp, PAT_DIR_NODE *ppat_dir_nodes, int npreorder, int *ppat_tid_list, int *ptemp_list1, int *ptemp_list2, int *ptemp_list3)
{
	int npat_tidlist_len, ndiff_list_len, nunion_len, ndiff_len, *ptemp_list, i, j;

	npat_tidlist_len = 0;

	if(ppat_dir_nodes[npreorder].nflag & (1<<DIFF_LIST_FLAG_BITPOS)) //diff list
	{
		ndiff_list_len = 0;
		while(npreorder>=0 && (ppat_dir_nodes[npreorder].nflag & (1<<DIFF_LIST_FLAG_BITPOS)))
		{
			npat_tidlist_len = LoadOneTidList(fp, ppat_dir_nodes[npreorder].ntidlist_pos, ptemp_list3);
			nunion_len = get_union(ndiff_list_len, ptemp_list1, npat_tidlist_len, ptemp_list3, ptemp_list2);
			if(nunion_len!=ndiff_list_len+npat_tidlist_len)
				printf("Error: there should no no overlap between two consecutive diff-list\n");
			ndiff_list_len = nunion_len;
			ptemp_list = ptemp_list2;
			ptemp_list2 = ptemp_list1;
			ptemp_list1 = ptemp_list;
			npreorder = ppat_dir_nodes[npreorder].nparent_preorder;
			while(npreorder>=0 && (ppat_dir_nodes[npreorder].nflag & (1<<CLOSED_FLAG_BITPOS))==0)
				npreorder = ppat_dir_nodes[npreorder].nparent_preorder;
		}
		if(npreorder>=0)
		{
			npat_tidlist_len = LoadOneTidList(fp, ppat_dir_nodes[npreorder].ntidlist_pos, ptemp_list3);
			ndiff_len = get_diffset(npat_tidlist_len, ptemp_list3, ndiff_list_len, ptemp_list1, ppat_tid_list);
			if(ndiff_len!=npat_tidlist_len-ndiff_list_len)
				printf("Error: the tid list length should be the difference between the parent list length and the diff-list length\n");
			npat_tidlist_len = ndiff_len;
		}
		else if(npreorder==-1)
		{
			i = 0;
			j = 0;
			npat_tidlist_len = 0;
			while(i<gndb_size && j<ndiff_list_len)
			{
				if(i==ptemp_list1[j])
				{
					i++;
					j++;
				}
				else if(i<ptemp_list1[j])
					ppat_tid_list[npat_tidlist_len++] = i++;
				else
					j++;
			}
			while(i<gndb_size)
				ppat_tid_list[npat_tidlist_len++] = i++;
		}
		else
			printf("Error: the preorder of the entry cannot be -2\n");
	}
	else
		npat_tidlist_len = LoadOneTidList(fp, ppat_dir_nodes[npreorder].ntidlist_pos, ppat_tid_list);
	
	return npat_tidlist_len;
}


void CMultiTestCorrector::GenItemTidLists(char* szoutput_name, ENTRY *pentries, TID_LIST *ptid_lists, int num_of_entries)
{
	FILE *fp;
	char sztdb_filename[200];
	int i, nlen, nitem, ntid, *pitem_order_map, norder;

	sprintf(sztdb_filename, "%s.tdb", szoutput_name);
	fp = fopen(sztdb_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztdb_filename);
		return;
	}

	pitem_order_map = NewIntArray(gnum_of_items, -1);
	for(i=0;i<num_of_entries;i++)
	{
		ptid_lists[i].nlen = 0;
		ptid_lists[i].ndiff_len = 0;
		pitem_order_map[pentries[i].item] = i;
	}

	ntid = 0;
	fread(&nlen, sizeof(int), 1, fp);
	while(!feof(fp))
	{
		for(i=0;i<nlen;i++)
		{
			fread(&nitem, sizeof(int), 1, fp);
			norder = pitem_order_map[nitem];
			if(norder>=0 && ptid_lists[norder].ptid_list!=NULL)
				ptid_lists[norder].ptid_list[ptid_lists[norder].nlen++] = ntid;
		}

		ntid++;
		fread(&nlen, sizeof(int), 1, fp);
	}
	fclose(fp);
	DelIntArray(pitem_order_map, gnum_of_items);

	for(i=0;i<num_of_entries;i++)
	{
		if(ptid_lists[i].ptid_list!=NULL && pentries[i].support!=ptid_lists[i].nlen)
			printf("Error: inconsistent tid list length\n");
	}
}

void CMultiTestCorrector::OutputPatDirNodes(char *szoutput_name, PAT_DIR_NODE *ppat_dir_nodes, int ntotal_entries)
{
	FILE *fp;
	char szoutput_filename[200];
	int i;

	for(i=0;i<ntotal_entries;i++)
	{
		if((ppat_dir_nodes[i].nflag & (1<<CLOSED_FLAG_BITPOS)) && ppat_dir_nodes->nparent_preorder==-2)
			printf("Error: the parent preorder of the entry cannot be -2\n");
	}

	sprintf(szoutput_filename, "%s.tidlist.dir", szoutput_name);
	fp = fopen(szoutput_filename, "wb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	fwrite(&ntotal_entries, sizeof(int), 1, fp);
	fwrite(&mnum_of_lists, sizeof(int), 1, fp);
	fwrite(&mnmax_dfs_list_len, sizeof(int), 1, fp);
	fwrite(&mnmax_tidlist_len, sizeof(int), 1, fp);
	fwrite(ppat_dir_nodes, sizeof(PAT_DIR_NODE), ntotal_entries, fp);

	fclose(fp);
}

int CMultiTestCorrector::LoadPatDirNodes(char* szoutput_name, PAT_DIR_NODE *&ppat_dir_nodes)
{
	FILE *fp;
	char szoutput_filename[200];
	int ntotal_entries;

	sprintf(szoutput_filename, "%s.tidlist.dir", szoutput_name);
	fp = fopen(szoutput_filename, "rb");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szoutput_filename);
		return 0;
	}

	fread(&ntotal_entries, sizeof(int), 1, fp);
	fread(&mnum_of_lists, sizeof(int), 1, fp);
	fread(&mnmax_dfs_list_len, sizeof(int), 1, fp);
	fread(&mnmax_tidlist_len, sizeof(int), 1, fp);

	ppat_dir_nodes = new PAT_DIR_NODE[ntotal_entries];
	IncMemSize(sizeof(PAT_DIR_NODE)*ntotal_entries);

	fread(ppat_dir_nodes, sizeof(PAT_DIR_NODE), ntotal_entries, fp);

	fclose(fp);

	return ntotal_entries;
}

//========================================================================================================

void GenOnePermutationTid(int ndb_size, int num_of_tgt_values, int* ptgt_sups, char* pone_permutation, CRandomMersenne *prng)
{
	int i, k, ntid;

	for(i=0;i<ndb_size;i++)
		pone_permutation[i] = -1;

	for(i=0;i<num_of_tgt_values-1;i++)
	{
		for(k=0;k<ptgt_sups[i];k++)
		{
			//ntid = (int)(ndb_size*prng->Random());
			ntid = prng->IRandom(0, ndb_size-1);
			while(pone_permutation[ntid]>=0)
			{
				//ntid = (int)(ndb_size*prng->Random());
				ntid = prng->IRandom(0, ndb_size-1);
				gnum_of_randgen_retries++;
			}
			pone_permutation[ntid] = i;
		}
	}

	for(i=0;i<ndb_size;i++)
	{
		if(pone_permutation[i]==-1)
			pone_permutation[i] = num_of_tgt_values-1;
	}
}

void GenOnePermutationTidClass(int ndb_size, int num_of_tgt_values, int* ptgt_sups, char* pone_permutation, char* pprev_permutation, CRandomMersenne *prng)
{
	int i, ntid, nclass_label;

	for(i=0;i<ndb_size;i++)
	{
		//ntid = (int)(ndb_size*prng->Random());
		ntid = prng->IRandom(0, ndb_size-1);
		nclass_label = pprev_permutation[ntid];
		while(ptgt_sups[nclass_label]==0)
		{
			//ntid = (int)(ndb_size*prng->Random());
			ntid = prng->IRandom(0, ndb_size-1);
			nclass_label = pprev_permutation[ntid];
		}
		pone_permutation[i] = nclass_label;
		ptgt_sups[nclass_label]--;
	}
}

void GenOnePermutationTidClass(int ndb_size, int num_of_tgt_values, int* ptgt_sups, char* pone_permutation, int* ptgt_values, CRandomMersenne *prng)
{
	int i, ntid, nclass_label;

	for(i=0;i<ndb_size;i++)
	{
		//ntid = (int)(ndb_size*prng->Random());
		ntid = prng->IRandom(0, ndb_size-1);
		nclass_label = ptgt_values[ntid];
		while(ptgt_sups[nclass_label]==0)
		{
			//ntid = (int)(ndb_size*prng->Random());
			ntid = prng->IRandom(0, ndb_size-1);
			nclass_label = ptgt_values[ntid];
		}
		pone_permutation[i] = nclass_label;
		ptgt_sups[nclass_label]--;
	}
}

//Durstenfeld, Richard (July 1964). "Algorithm 235: Random permutation". Communications of the ACM 7 (7): 420
void GenOnePermutationSwap(int ndb_size, int num_of_tgt_values, int* ptgt_sups, char* pone_permutation, int* ptgt_values, CRandomMersenne *prng)
{
	int i, ntid, nclass_label;

	for(i=0;i<ndb_size;i++)
		pone_permutation[i] = ptgt_values[i];
	for(i=ndb_size-1;i>0;i--)
	{
		ntid = prng->IRandom(0, i);
		if(ntid!=i)
		{
			nclass_label = pone_permutation[i];
			pone_permutation[i] = pone_permutation[ntid];
			pone_permutation[ntid] = nclass_label;
		}
	}
}

void CMultiTestCorrector::GenPermutations(char* szoutput_name, int ndb_size, int num_of_permutations, char**ppdata_permutations)
{
	int i, *ptgt_sups, num_of_tgt_values;

	if(gsztarget_value[0]!=0) // the target value is 1
	{
		num_of_tgt_values = 2;
		ptgt_sups = NewIntArray(num_of_tgt_values);
		ptgt_sups[1] = ((int*)gptgt_stat_array)[0];
		ptgt_sups[0] = gndb_size-ptgt_sups[1];
	}
	else
	{
		num_of_tgt_values = gnum_of_tgt_values;
		ptgt_sups = NewIntArray(num_of_tgt_values);
		memcpy(ptgt_sups, (int*)gptgt_stat_array, gntgt_stat_size);
	}

	gnum_of_randgen_retries = 0;

	if(gnseeding_method==SEEDING_GLOBAL)
	{
		printf("Global seeding\n");
		gpperm_data_rng = new CRandomMersenne((unsigned int)time(NULL));
		//gprm_rng = new CRandomMersenne(0);
	}

	if(gndata_perm_method==DATA_PERM_RAND_TID)
	{
		printf("permutation method: rand tid\n");
		if(gnseeding_method==SEEDING_GLOBAL)
		{
			for(i=0;i<num_of_permutations;i++)
				GenOnePermutationTid(gndb_size, num_of_tgt_values, ptgt_sups, ppdata_permutations[i], gpperm_data_rng);
		}
		else
		{
			for(i=0;i<num_of_permutations;i++)
			{
				CRandomMersenne rng((unsigned int)time(NULL)+i);
				GenOnePermutationTid(gndb_size, num_of_tgt_values, ptgt_sups, ppdata_permutations[i], &rng);
			}
		}
	}
	else if(gndata_perm_method==DATA_PERM_RAND_TID_CLASS)
	{
		printf("permutation method: rand tid class\n");
		int *pperm_tgt_sups, *ptgt_values;

		ptgt_values = NewIntArray(ndb_size);
		LoadTransTgtValues(szoutput_name, ptgt_values);

		pperm_tgt_sups = NewIntArray(num_of_tgt_values);
		if(gnseeding_method==SEEDING_GLOBAL)
		{
			memcpy(pperm_tgt_sups, ptgt_sups, sizeof(int)*num_of_tgt_values);
			GenOnePermutationTidClass(gndb_size, num_of_tgt_values, pperm_tgt_sups, ppdata_permutations[0], ptgt_values, gpperm_data_rng);
			for(i=1;i<num_of_permutations;i++)
			{
				memcpy(pperm_tgt_sups, ptgt_sups, sizeof(int)*num_of_tgt_values);
				//GenOnePermutationTidClass(gndb_size, num_of_tgt_values, pperm_tgt_sups, ppdata_permutations[i], ppdata_permutations[i-1], gpperm_data_rng);
				GenOnePermutationTidClass(gndb_size, num_of_tgt_values, pperm_tgt_sups, ppdata_permutations[i], ptgt_values, gpperm_data_rng);
			}
		}
		else
		{
			for(i=0;i<num_of_permutations;i++)
			{
				CRandomMersenne rng((unsigned int)time(NULL)+i);

				memcpy(pperm_tgt_sups, ptgt_sups, sizeof(int)*num_of_tgt_values);
				if(1 || i==0)
					GenOnePermutationTidClass(gndb_size, num_of_tgt_values, pperm_tgt_sups, ppdata_permutations[i], ptgt_values, &rng);
				else
					GenOnePermutationTidClass(gndb_size, num_of_tgt_values, pperm_tgt_sups, ppdata_permutations[i], ppdata_permutations[i-1], &rng);
			}
		}
		DelIntArray(pperm_tgt_sups, num_of_tgt_values);
		DelIntArray(ptgt_values, ndb_size);
	}
	else //gndata_perm_method==DATA_PERM_SWAP
	{
		printf("permutation method: swap\n");

		int *ptgt_values;
		ptgt_values = NewIntArray(ndb_size);
		LoadTransTgtValues(szoutput_name, ptgt_values);

		if(gnseeding_method==SEEDING_GLOBAL)
		{
			for(i=0;i<num_of_permutations;i++)
				GenOnePermutationSwap(gndb_size, num_of_tgt_values, ptgt_sups, ppdata_permutations[i], ptgt_values, gpperm_data_rng);
		}
		else
		{
			for(i=0;i<num_of_permutations;i++)
			{
				CRandomMersenne rng((unsigned int)time(NULL)+i);
				GenOnePermutationSwap(gndb_size, num_of_tgt_values, ptgt_sups, ppdata_permutations[i], ptgt_values, &rng);
			}
		}

		DelIntArray(ptgt_values, ndb_size);
	}



	if(gnseeding_method==SEEDING_GLOBAL)
		delete gpperm_data_rng;

	DelIntArray(ptgt_sups, num_of_tgt_values);
	printf("%d permutations generated.\n", num_of_permutations);

	//AnalyzePermData(szoutput_name, ppdata_permutations, ndb_size, num_of_permutations);
}

void CMultiTestCorrector::AnalyzePermData(char* szoutput_name, char **ppdata_permutations, int ndb_size, int num_of_permutations)
{
	FILE *fp;
	char szpermdiff_filename[200];
	int num_of_diffs, i, j, k, ndiff_label_num;
	double *pdiff_matrix, ddiff, davg, dstddev, dmin, dmax;
	double *pdiff_array, davg_wtorig, dstddev_wtorig, dmin_wtorig, dmax_wtorig;
	int *ptgt_values;

	if(gndata_perm_method==DATA_PERM_RAND_TID)
		sprintf(szpermdiff_filename, "%s.rand-tid.permdiff", szoutput_name);
	else if(gndata_perm_method==DATA_PERM_RAND_TID_CLASS)
		sprintf(szpermdiff_filename, "%s.rand-tid-class.permdiff", szoutput_name);
	else if(gndata_perm_method==DATA_PERM_SWAP)
		sprintf(szpermdiff_filename, "%s.swap.permdiff", szoutput_name);

	fp = fopen(szpermdiff_filename, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szpermdiff_filename);
		return;
	}

	num_of_diffs = num_of_permutations*(num_of_permutations-1)/2;
	pdiff_matrix = new double[num_of_permutations*(num_of_permutations-1)/2];
	davg = 0;
	dstddev = 0;
	dmin = 1;
	dmax = 0;

	ptgt_values = NewIntArray(ndb_size);
	LoadTransTgtValues(szoutput_name, ptgt_values);
	pdiff_array = new double[num_of_permutations];
	davg_wtorig = 0;
	dstddev_wtorig = 0;
	dmin_wtorig = 1;
	dmax_wtorig = 0;

	for(i=0;i<num_of_permutations;i++)
	{
		for(j=0;j<i;j++)
		{
			ndiff_label_num = 0;
			for(k=0;k<ndb_size;k++)
			{
				if(ppdata_permutations[i][k]!=ppdata_permutations[j][k])
					ndiff_label_num++;
			}
			ddiff = (double)ndiff_label_num/ndb_size;
			pdiff_matrix[i*(i-1)/2+j] = ddiff;
			davg += ddiff;
			dstddev += ddiff*ddiff;
			if(dmin>ddiff)
				dmin = ddiff;
			if(dmax<ddiff)
				dmax = ddiff;
		}

		ndiff_label_num = 0;
		for(k=0;k<ndb_size;k++)
		{
			if(ppdata_permutations[i][k]!=ptgt_values[k])
				ndiff_label_num++;
		}
		ddiff = (double)ndiff_label_num/ndb_size;
		pdiff_array[i] = ddiff;
		davg_wtorig += ddiff;
		dstddev_wtorig += ddiff*ddiff;
		if(dmin_wtorig>ddiff)
			dmin_wtorig = ddiff;
		if(dmax_wtorig<ddiff)
			dmax_wtorig = ddiff;
	}
	davg /= num_of_diffs;
	dstddev = sqrt((dstddev-davg*davg*num_of_diffs)/(num_of_diffs-1));

	qsort(pdiff_matrix, num_of_diffs, sizeof(double), comp_double);

	printf("Average difference: %.6f (%.6f)\n", davg, dstddev);
	printf("Min difference: %.3f\n", dmin);
	printf("Max difference: %.3f\n", dmax);
	printf("Median difference: %.3f\n\n", pdiff_matrix[num_of_diffs/2]);

	for(i=0;i<num_of_diffs;i++)
		fprintf(fp, "%f\n", pdiff_matrix[i]);

	delete []pdiff_matrix;


	qsort(pdiff_array, num_of_permutations, sizeof(double), comp_double);
	davg_wtorig /= num_of_permutations;
	dstddev_wtorig = sqrt((dstddev_wtorig-davg_wtorig*davg_wtorig*num_of_permutations)/(num_of_permutations-1));
	printf("Average difference with original data: %.6f (%.6f)\n", davg_wtorig, dstddev_wtorig);
	printf("Min difference with original data: %.3f\n", dmin_wtorig);
	printf("Max difference with original data: %.3f\n", dmax_wtorig);
	printf("Median difference with original data: %.3f\n\n", pdiff_array[num_of_permutations/2]);

	delete []pdiff_array;
	delete []ptgt_values;

	fclose(fp);
}


void CMultiTestCorrector::GenPermPvaluesPrecomputedTidLists(char* szoutput_name)
{
	char szattrvalue_filename[200], szcfp_filename[200], szcfp_stat_filename[200], sztid_list_filename[200], szperm_filename[200];
	char szrule_filename[200];
	struct timeb start, end;
	int i, ntotal_entries;

	ftime(&start);

	gdused_mem_size = 0;
	gdmax_used_mem_size = 0;
	gnum_of_tests = 0;
	gnunbuffered_pvalues = 0;
	gnpartially_buffered_pvalues = 0;


	sprintf(szcfp_filename, "%s.cfptree", szoutput_name);
	mfpcfp_file = fopen(szcfp_filename, "rb");
	if(mfpcfp_file==NULL)
	{
		printf("Error: cannot open file %s for read\n", szcfp_filename);
		return;
	}

	sprintf(szattrvalue_filename, "%s.attrvalue2item.txt", szoutput_name);
	LoadAttrNValues(szattrvalue_filename);

	sprintf(szcfp_stat_filename, "%s.cfptree.stat", szoutput_name);
	ReadTreeStatis(szcfp_stat_filename);
	if(gntree_size==0)
		return;

	//------------------------------------------------------------
	//generate p-values adjusted by permutation tests
	ntotal_entries = LoadPatDirNodes(szoutput_name, mppat_dir_nodes);
	sprintf(sztid_list_filename, "%s.tidlist", szoutput_name);
	mfp_list = fopen(sztid_list_filename, "rb");
	if(mfp_list==NULL)
	{
		printf("Error: cannot open file %s for write\n", sztid_list_filename);
		return;
	}
	sprintf(szperm_filename, "%s.perm", szoutput_name);
	mfp_perm = fopen(szperm_filename, "wb");
	if(mfp_perm==NULL)
	{
		printf("Error: cannot open file %s for write\n", szperm_filename);
		return;
	}

	mppat_pvalues = new PAT_PVALUE[mnum_of_lists];
	IncMemSize(sizeof(PAT_PVALUE)*mnum_of_lists);

	mptid_list = NewIntArray(mnmax_tidlist_len);

	//generate permutations
	mpperm_matrix = NewCharArray(gndb_size*gnum_of_repetitions);
	mppdata_permutations = new char*[gnum_of_repetitions];
	IncMemSize(sizeof(char*)*gnum_of_repetitions);
	for(i=0;i<gnum_of_repetitions;i++)
		mppdata_permutations[i] = &mpperm_matrix[i*gndb_size];
	GenPermutations(szoutput_name, gndb_size, gnum_of_repetitions, mppdata_permutations);

	mpentry_buf = NewEntryArray(gnmax_dfsentries_len);
	mptgt_stat_buf = NewCharArray(gnmax_dfsentries_len*gntgt_stat_size);
	mpperm_tgt_stat_buf = NewCharArray((gnmax_tree_depth+1)*gnum_of_repetitions*gntgt_stat_size);
	mpmin_perm_pvalues = new MIN_PVALUE_STAT[gnum_of_repetitions];
	IncMemSize(gnum_of_repetitions*sizeof(MIN_PVALUE_STAT));
	for(i=0;i<gnum_of_repetitions;i++)
		mpmin_perm_pvalues[i].dpvalue = 1;
	mnentry_buf_pos = 0;
	mndepth = 0;

	if(gntgt_attr_type==NOMINAL && gntest_statisitic_method==FISHER_EXACT_TEST)
		InitFactorials(gpdfactorials, gndb_size);

	gpsup_testnums = new int[gndb_size];
	memset(gpsup_testnums, 0, sizeof(int)*gndb_size);

	for(i=0;i<gnum_of_repetitions;i++)
		memcpy(&mpperm_tgt_stat_buf[i*gntgt_stat_size], gptgt_stat_array, gntgt_stat_size);

	calc_perm_pvalues(0, mpperm_tgt_stat_buf);

	if(gntgt_attr_type==NOMINAL && gntest_statisitic_method==FISHER_EXACT_TEST)
		DelFactorials(gpdfactorials, gndb_size);

	DelCharArray(mpperm_tgt_stat_buf, (gnmax_tree_depth+1)*gnum_of_repetitions*gntgt_stat_size);

	DelCharArray(mpperm_matrix, gndb_size*gnum_of_repetitions);
	delete []mppdata_permutations;
	DecMemSize(sizeof(char*)*gnum_of_repetitions);

	DelIntArray(mptid_list, mnmax_tidlist_len);
	delete []mppat_dir_nodes;
	DecMemSize(sizeof(PAT_DIR_NODE)*ntotal_entries);

	fclose(mfp_list);
	fclose(mfp_perm);

	ftime(&end);
	gdgen_rule_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;

	printf("Time for permutation: %.3f\n", gdgen_rule_time);
	printf("#unbuffered p-values: %d, #partially buffered p-values: %d\n", 	gnunbuffered_pvalues, gnpartially_buffered_pvalues);
	printf("\n");

	qsort(mpmin_perm_pvalues, gnum_of_repetitions, sizeof(MIN_PVALUE_STAT), comp_min_pvalue);
	gdpermFWER_pvalue_thres = mpmin_perm_pvalues[(int)(gnum_of_repetitions*gdmax_pvalue)].dpvalue;
	OutputMinPvalues(mpmin_perm_pvalues, gnum_of_repetitions, szoutput_name);
	delete []mpmin_perm_pvalues;
	DecMemSize(gnum_of_repetitions*sizeof(MIN_PVALUE_STAT));

	GetAdjustedPvalues(szperm_filename);
	OutputPvlaues(szoutput_name);

	//--------------------------------------------------------
	//extract rules 
	gnum_of_output_rules = 0;
	gntotal_context_len = 0;

	mpsign_rule_flags = NewIntArray(gnum_of_entries, -1);
	for(i=0;i<mnum_of_lists;i++)
	{
		if(gdmax_pvalue>=1 || mppat_pvalues[i].deffect_size>=gdmin_diff && mppat_pvalues[i].dorig_pvalue<=gdmax_pvalue) // || mppat_pvalues[i].dadj_pvalue<=dmax_pvalue))
			mpsign_rule_flags[mppat_pvalues[i].npreorder] = i;
	}
	rewind(mfpcfp_file);

	mppattern = NewIntArray(gnum_of_attrs);
	mnpat_len = 0;
	mopat_info.nsupport = gndb_size;
	mopat_info.ptgt_stat = NewCharArray(gntgt_stat_size);
	memcpy(mopat_info.ptgt_stat, gptgt_stat_array, gntgt_stat_size);
	morule.pattern = mppattern;
	morule.ppat_info = &mopat_info;
	morule.dcond_pvalue = 0;
	mnentry_buf_pos = 0;

	sprintf(szrule_filename, "%s.rules.txt", szoutput_name);
	mfptext = fopen(szrule_filename, "wt");
	if(mfptext==NULL)
		printf("Error: cannot open file %s for write\n", szrule_filename);
	else
	{
		extract_rules(0);
		fclose(mfptext);
	}
	
	fclose(mfpcfp_file);
	

	DelCharArray(mopat_info.ptgt_stat, gntgt_stat_size);
	DelIntArray(mppattern, gnum_of_attrs);

	DelCharArray(gptgt_stat_array, gntgt_stat_size);
	DelEntryArray(mpentry_buf, gnmax_dfsentries_len);
	DelCharArray(mptgt_stat_buf, gnmax_dfsentries_len*gntgt_stat_size);

	delete []mppat_pvalues;
	DecMemSize(sizeof(PAT_PVALUE)*mnum_of_lists);
	DelIntArray(mpsign_rule_flags, gnum_of_entries);

	delete []gpAttributes;
	DecMemSize(sizeof(ATTRIBUTE)*gnum_of_attrs);
	DelCharArray(gszattr_name_buf, gnattr_name_buf_size);
	delete []gpAttrValues;
	DecMemSize(sizeof(ATTR_VALUE)*gnum_of_items);
	DelCharArray(gszattr_value_buf, gnattr_value_buf_size);

	OutputRuleSummary(szoutput_name);

	ftime(&end);
	gdgen_rule_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;
	gdgenrule_max_mem_size = gdmax_used_mem_size;

	if(gnum_of_tests!=mnum_of_lists)
		printf("Error: inconsistent number of tests performed\n");

	printf("#tests: %d\n", gnum_of_tests);
	printf("Time for p-value correction with %d permutations: %f\n", gnum_of_repetitions, gdgen_rule_time);
	printf("\n");
}

void CMultiTestCorrector::calc_perm_pvalues(int ndisk_pos, char* pparent_perm_tgt_stat)
{
	ENTRY *pentries;
	char *ptgt_stat_array, *pperm_tgt_stat;
	int num_of_entries, nfile_pos, i;

	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=ndisk_pos)
		fseek(mfpcfp_file, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptgt_stat_array = &mptgt_stat_buf[mnentry_buf_pos*gntgt_stat_size];
	pperm_tgt_stat = &mpperm_tgt_stat_buf[(mndepth+1)*gnum_of_repetitions*gntgt_stat_size];

	if(num_of_entries==1 || num_of_entries<0)
	{
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
		if(num_of_entries<0)
		{
			num_of_entries = -num_of_entries;
			fseek(mfpcfp_file, sizeof(int)*(num_of_entries-1), SEEK_CUR);
		}
		fread(ptgt_stat_array, sizeof(char), gntgt_stat_size, mfpcfp_file);

		if(mppat_dir_nodes[pentries->npreorder].nflag & (1<<CLOSED_FLAG_BITPOS))
			CalcPermPvalues(pentries, ptgt_stat_array, pparent_perm_tgt_stat, pperm_tgt_stat);
		else
			pperm_tgt_stat = pparent_perm_tgt_stat;

		if(pentries[0].child!=0 && (pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0 && gndepth<gnmax_len)
		{
			mnentry_buf_pos++;
			mndepth++;
			calc_perm_pvalues(pentries[0].child, pperm_tgt_stat);
			mnentry_buf_pos--;
			mndepth--;
		}
	}
	else if(num_of_entries>1)
	{
		if(gndepth<gnmax_len)
		{
			fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
			fread(ptgt_stat_array, sizeof(char), num_of_entries*gntgt_stat_size, mfpcfp_file);
			mnentry_buf_pos += num_of_entries;

			for(i=0;i<num_of_entries;i++)
			{
				mndepth++;
				gndepth++;
				if(mppat_dir_nodes[pentries[i].npreorder].nflag & (1<<CLOSED_FLAG_BITPOS))
				{
					CalcPermPvalues(&pentries[i], &ptgt_stat_array[i*gntgt_stat_size], pparent_perm_tgt_stat, pperm_tgt_stat);
					if(pentries[i].child!=0)
						calc_perm_pvalues(pentries[i].child, pperm_tgt_stat);
				}
				else if(pentries[i].child!=0 && (pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
					calc_perm_pvalues(pentries[i].child, pparent_perm_tgt_stat);
				mndepth--;
				gndepth--;
			}
			mnentry_buf_pos -= num_of_entries;
		}
	}
	else
		printf("Error with number of entires\n");

}

void CMultiTestCorrector::CalcPermPvalues(ENTRY *pentry, char* ptgt_stat, char* pparent_perm_tgt_stat, char* pperm_tgt_stat)
{
	int nlist_len, i, j, *ptgt_sups, num_of_more_signs;
	double dscore, dpvalue, dorig_pvalue, deffect_size;

	if(pentry->support==gndb_size)
		return;

	gpsup_testnums[pentry->support]++;

	mppat_pvalues[gnum_of_tests].npreorder = pentry->npreorder;
	mppat_pvalues[gnum_of_tests].nsup = pentry->support;

	if(gneffect_size_method==CONFIDENCE)
	{
		deffect_size = ((int*)ptgt_stat)[0]/(double)pentry->support; //-(double)(((int*)gptgt_stat_array)[0]-((int*)ptgt_stat)[0])/(gndb_size-pentry->support);
		//if(deffect_size<0)
		//	deffect_size = -deffect_size;				
	}
	else //ODDS_RATIO
		deffect_size = (double)(((int*)ptgt_stat)[0])*(gndb_size-pentry->support-(((int*)gptgt_stat_array)[0]-((int*)ptgt_stat)[0]))/((pentry->support-((int*)ptgt_stat)[0])*(((int*)gptgt_stat_array)[0]-((int*)ptgt_stat)[0]));
	mppat_pvalues[gnum_of_tests].deffect_size = deffect_size;


	dorig_pvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, ptgt_stat, dscore);
	mppat_pvalues[gnum_of_tests].dorig_pvalue = dorig_pvalue;
	mppat_pvalues[gnum_of_tests].dscore = dscore;

	nlist_len = LoadOneTidList(mfp_list, mppat_dir_nodes[pentry->npreorder].ntidlist_pos, mptid_list);

	num_of_more_signs = 0;
	
	if(mppat_dir_nodes[pentry->npreorder].nflag & (1<<DIFF_LIST_FLAG_BITPOS)) //diff_list
	{
		memcpy(pperm_tgt_stat, pparent_perm_tgt_stat, gnum_of_repetitions*gntgt_stat_size);
		if(gsztarget_value[0]!=0)
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<nlist_len;j++)
				{
					if(mppdata_permutations[i][mptid_list[j]]==1) //1 is the target value
						ptgt_sups[0]--;
				}
				dpvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, &pperm_tgt_stat[i*gntgt_stat_size], dscore);
				fwrite(&dpvalue, sizeof(double), 1, mfp_perm);
				if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
				{
					mpmin_perm_pvalues[i].dpvalue = dpvalue;
					mpmin_perm_pvalues[i].nsup = pentry->support;
					mpmin_perm_pvalues[i].dconf = (double)ptgt_sups[0]/pentry->support;
				}
				if(dpvalue<=dorig_pvalue)
					num_of_more_signs++;
			}
		}
		else
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<nlist_len;j++)
					ptgt_sups[mppdata_permutations[i][mptid_list[j]]]--;
				dpvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, &pperm_tgt_stat[i*gntgt_stat_size], dscore);				
				fwrite(&dpvalue, sizeof(double), 1, mfp_perm);
				if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
				{
					mpmin_perm_pvalues[i].dpvalue = dpvalue;
					mpmin_perm_pvalues[i].nsup = pentry->support;
					mpmin_perm_pvalues[i].dconf = (double)ptgt_sups[0]/pentry->support;
				}
				if(dpvalue<=dorig_pvalue)
					num_of_more_signs++;
			}
		}
	}
	else
	{
		memset(pperm_tgt_stat, 0, gnum_of_repetitions*gntgt_stat_size);
		if(gsztarget_value[0]!=0)
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<nlist_len;j++)
				{
					if(mppdata_permutations[i][mptid_list[j]]==1) //1 is the target  value
						ptgt_sups[0]++;
				}
				dpvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, &pperm_tgt_stat[i*gntgt_stat_size], dscore);
				fwrite(&dpvalue, sizeof(double), 1, mfp_perm);
				if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
				{
					mpmin_perm_pvalues[i].dpvalue = dpvalue;
					mpmin_perm_pvalues[i].nsup = pentry->support;
					mpmin_perm_pvalues[i].dconf = (double)ptgt_sups[0]/pentry->support;
				}
				if(dpvalue<=dorig_pvalue)
					num_of_more_signs++;
			}
		}
		else
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<nlist_len;j++)
					ptgt_sups[mppdata_permutations[i][mptid_list[j]]]++;
				dpvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, &pperm_tgt_stat[i*gntgt_stat_size], dscore);				
				fwrite(&dpvalue, sizeof(double), 1, mfp_perm);
				if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
				{
					mpmin_perm_pvalues[i].dpvalue = dpvalue;
					mpmin_perm_pvalues[i].nsup = pentry->support;
					mpmin_perm_pvalues[i].dconf = (double)ptgt_sups[0]/pentry->support;
				}
				if(dpvalue<=dorig_pvalue)
					num_of_more_signs++;
			}
		}
	}

	mppat_pvalues[gnum_of_tests].dind_adj_pvalue = (double)num_of_more_signs/gnum_of_repetitions;

	gnum_of_tests++;
}


void CMultiTestCorrector::extract_rules(int ndisk_pos)
{
	ENTRY *pentries;
	char *ptgt_stat_array;
	int num_of_entries, nfile_pos, i, j, *pitems, norig_pat_len, norder;
	TGT_SUM *ptgt_sum;


	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=ndisk_pos)
		fseek(mfpcfp_file, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptgt_stat_array = &mptgt_stat_buf[mnentry_buf_pos*gntgt_stat_size];

	if(num_of_entries==1 || num_of_entries<0)
	{
		norig_pat_len = mnpat_len;

		fread(pentries, sizeof(ENTRY)-sizeof(int), 1, mfpcfp_file);	
		if(num_of_entries<0)
			num_of_entries = -num_of_entries;
		pitems = &mppattern[mnpat_len];
		fread(pitems, sizeof(int), num_of_entries, mfpcfp_file);
		fread(ptgt_stat_array, sizeof(char), gntgt_stat_size, mfpcfp_file);	
		for(i=0;i<num_of_entries;i++)
		{
			if(gpAttrValues[pitems[i]].bis_context_item)
				mppattern[mnpat_len++] = pitems[i];
		}

		if(gbrule_multiclass_pairwise)
		{
			for(j=0;j<gnum_of_tgt_values;j++)
			{
				norder = mpsign_rule_flags[pentries->npreorder*gnum_of_tgt_values+j];
				if(norder>=0)
				{
					morule.ppat_info->npreorder = pentries->npreorder;
					morule.npat_len = mnpat_len;

					mopat_info.nsupport = pentries->support;
					memcpy(mopat_info.ptgt_stat, ptgt_stat_array, gntgt_stat_size);
					mopat_info.dmean = ((int*)mopat_info.ptgt_stat)[j]/(double)mopat_info.nsupport;

					morule.dpvalue = mppat_pvalues[norder].dorig_pvalue;
					morule.dscore = mppat_pvalues[norder].dscore;
					morule.dadjusted_pvalue = mppat_pvalues[norder].dadj_pvalue;
					morule.ntgt_class = mppat_pvalues[norder].ntgt_class;

					OutputOneRule(mfptext, &morule);
					gnum_of_output_rules++;
					gntotal_context_len += morule.npat_len;
				}
			}
		}
		else
		{
			norder = mpsign_rule_flags[pentries->npreorder];
			if(norder>=0)
			{
				morule.ppat_info->npreorder = pentries->npreorder;
				morule.npat_len = mnpat_len;

				mopat_info.nsupport = pentries->support;
				memcpy(mopat_info.ptgt_stat, ptgt_stat_array, gntgt_stat_size);
				if(gntgt_attr_type==CONTINUOUS || gntgt_attr_type==CONTINUOUS_NORMAL)
				{
					ptgt_sum = (TGT_SUM*)mopat_info.ptgt_stat;
					mopat_info.dmean = ptgt_sum->dsum/mopat_info.nsupport;
					mopat_info.dstd_dev = sqrt((ptgt_sum->dsquare_sum-ptgt_sum->dsum*mopat_info.dmean)/(mopat_info.nsupport-1));
				}
				else if(gsztarget_value[0]!=0)
					mopat_info.dmean = ((int*)mopat_info.ptgt_stat)[0]/(double)mopat_info.nsupport;

				morule.dpvalue = mppat_pvalues[norder].dorig_pvalue;
				morule.dscore = mppat_pvalues[norder].dscore;
				morule.dadjusted_pvalue = mppat_pvalues[norder].dadj_pvalue;
				morule.ntgt_class = mppat_pvalues[norder].ntgt_class;

				OutputOneRule(mfptext, &morule);
				gnum_of_output_rules++;
				gntotal_context_len += morule.npat_len;
			}
		}

		if(pentries[0].child!=0 && pentries[0].support>=gnmin_sup && (pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0)
		{
			mnentry_buf_pos++;
			extract_rules(pentries[0].child);
			mnentry_buf_pos--;
		}
		mnpat_len = norig_pat_len;
	}
	else if(num_of_entries>1)
	{
		if(gndepth<gnmax_len)
		{
			fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
			fread(ptgt_stat_array, sizeof(char), num_of_entries*gntgt_stat_size, mfpcfp_file);
			mnentry_buf_pos += num_of_entries;

			for(i=0;i<num_of_entries;i++)
			{
				if(gpAttrValues[pentries[i].item].bis_context_item)
				{
					gndepth++;
					mppattern[mnpat_len++] = pentries[i].item;

					if(gbrule_multiclass_pairwise)
					{
						for(j=0;j<gnum_of_tgt_values;j++)
						{
							norder = mpsign_rule_flags[pentries[i].npreorder*gnum_of_tgt_values+j];
							if(norder>=0)
							{
								morule.ppat_info->npreorder = pentries[i].npreorder;
								morule.npat_len = mnpat_len;
								mopat_info.nsupport = pentries[i].support;
								memcpy(mopat_info.ptgt_stat, &ptgt_stat_array[i*gntgt_stat_size], gntgt_stat_size);
								mopat_info.dmean = (double)(((int*)mopat_info.ptgt_stat)[j])/mopat_info.nsupport;

								morule.dpvalue = mppat_pvalues[norder].dorig_pvalue;
								morule.dscore = mppat_pvalues[norder].dscore;
								morule.dadjusted_pvalue = mppat_pvalues[norder].dadj_pvalue;
								morule.ntgt_class = mppat_pvalues[norder].ntgt_class;

								OutputOneRule(mfptext, &morule);
								gnum_of_output_rules++;
								gntotal_context_len += morule.npat_len;	
							}
						}
					}
					else
					{
						norder = mpsign_rule_flags[pentries[i].npreorder];

						if(norder>=0)
						{
							morule.ppat_info->npreorder = pentries[i].npreorder;
							morule.npat_len = mnpat_len;
							mopat_info.nsupport = pentries[i].support;
							memcpy(mopat_info.ptgt_stat, &ptgt_stat_array[i*gntgt_stat_size], gntgt_stat_size);
							if(gntgt_attr_type==CONTINUOUS || gntgt_attr_type==CONTINUOUS_NORMAL)
							{
								ptgt_sum = (TGT_SUM*)mopat_info.ptgt_stat;
								mopat_info.dmean = ptgt_sum->dsum/mopat_info.nsupport;
								mopat_info.dstd_dev = sqrt((ptgt_sum->dsquare_sum-ptgt_sum->dsum*mopat_info.dmean)/(mopat_info.nsupport-1));
							}
							else if(gsztarget_value[0]!=0)
								mopat_info.dmean = (double)(*((int*)mopat_info.ptgt_stat))/mopat_info.nsupport;

							morule.dpvalue = mppat_pvalues[norder].dorig_pvalue;
							morule.dscore = mppat_pvalues[norder].dscore;
							morule.dadjusted_pvalue = mppat_pvalues[norder].dadj_pvalue;
							morule.ntgt_class = mppat_pvalues[norder].ntgt_class;

							OutputOneRule(mfptext, &morule);
							gnum_of_output_rules++;
							gntotal_context_len += morule.npat_len;
							
						}
					}

					if(pentries[i].child!=0 && pentries[i].support>=gnmin_sup && (pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
						extract_rules(pentries[i].child);
					mnpat_len--;
					gndepth--;
				}
			}
			mnentry_buf_pos -= num_of_entries;
		}
	}
	else
		printf("Error with number of entires\n");
}


void CMultiTestCorrector::GetAdjustedPvalues(char* szperm_filename)
{
	double *pperm_pvalues;
	int i, j, num_of_lower_pvalues;

	mfp_perm = fopen(szperm_filename, "rb");
	if(mfp_perm==NULL)
	{
		printf("Error: cannot open file %s for read\n", szperm_filename);
		return;
	}

	for(i=0;i<gnum_of_tests;i++)
		mppat_pvalues[i].dadj_pvalue = 0;

/*
	pperm_pvalues = new double[gnum_of_repetitions];
	IncMemSize(sizeof(double)*gnum_of_repetitions);

	for(i=0;i<gnum_of_tests;i++)
	{
		fread(pperm_pvalues, sizeof(double), gnum_of_repetitions, mfp_perm);
		qsort(pperm_pvalues, gnum_of_repetitions, sizeof(double), comp_double);

		for(j=0;j<gnum_of_tests;j++)
		{
			num_of_lower_pvalues = binary_search(pperm_pvalues, gnum_of_repetitions, mppat_pvalues[j].dorig_pvalue);
			mppat_pvalues[j].dadj_pvalue += num_of_lower_pvalues;
		}
	}

	delete []pperm_pvalues;
	DecMemSize(sizeof(double)*gnum_of_repetitions);
*/

	int ninc_step, nblock_size, nremain_size;

	for(j=0;j<gnum_of_tests;j++)
	{
		if(mppat_pvalues[j].dorig_pvalue>=gdmax_pvalue*2)
			mppat_pvalues[j].dadj_pvalue = mppat_pvalues[j].dorig_pvalue;
	}


	ninc_step = 20000;
	nblock_size = ninc_step*gnum_of_repetitions;

	pperm_pvalues = new double[nblock_size];
	IncMemSize(sizeof(double)*nblock_size);

	i = 0;
	while(i+ninc_step<gnum_of_tests)
	{
		fread(pperm_pvalues, sizeof(double), nblock_size, mfp_perm);
		qsort(pperm_pvalues, nblock_size, sizeof(double), comp_double);

		for(j=0;j<gnum_of_tests;j++)
		{
			if(mppat_pvalues[j].dorig_pvalue<gdmax_pvalue*2)
			{
				num_of_lower_pvalues = binary_search(pperm_pvalues, nblock_size, mppat_pvalues[j].dorig_pvalue);
				mppat_pvalues[j].dadj_pvalue += num_of_lower_pvalues;
			}
		}
		i += ninc_step;
	}
	if(i<gnum_of_tests)
	{
		nremain_size = (gnum_of_tests-i)*gnum_of_repetitions;
		fread(pperm_pvalues, sizeof(double), nremain_size, mfp_perm);
		qsort(pperm_pvalues, nremain_size, sizeof(double), comp_double);

		for(j=0;j<gnum_of_tests;j++)
		{
			if(mppat_pvalues[j].dorig_pvalue<gdmax_pvalue*2)
			{
				num_of_lower_pvalues = binary_search(pperm_pvalues, nremain_size, mppat_pvalues[j].dorig_pvalue);
				mppat_pvalues[j].dadj_pvalue += num_of_lower_pvalues;
			}
		}
	}

	delete []pperm_pvalues;
	DecMemSize(sizeof(double)*nblock_size);


	fclose(mfp_perm);
	for(i=0;i<gnum_of_tests;i++)
		mppat_pvalues[i].dadj_pvalue /= (gnum_of_tests*gnum_of_repetitions);
}

void CMultiTestCorrector::OutputPvlaues(char* szoutput_name)
{
	FILE *fp;
	char szoutput_filename[200];
	int i;

	sprintf(szoutput_filename, "%s.pvalues", szoutput_name);
	fp = fopen(szoutput_filename, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szoutput_filename);
		return;
	}

	for(i=0;i<gnum_of_tests;i++)
	{
		//fprintf(fp, "%d ", mppat_pvalues[i].npreorder);
		fprintf(fp, "%d %d %.3E %.3E\n", mppat_pvalues[i].npreorder, mppat_pvalues[i].nsup, mppat_pvalues[i].dorig_pvalue, mppat_pvalues[i].dadj_pvalue);
	}

	fclose(fp);
}

void CMultiTestCorrector::OutputMinPvalues(MIN_PVALUE_STAT *pmin_perm_pvalues, int num_of_repetitions, char* szoutput_name)
{
	FILE *fp;
	char szoutput_filename[200];
	int i;

	sprintf(szoutput_filename, "%s.perm.minpvalues", szoutput_name);
	fp = fopen(szoutput_filename, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szoutput_filename);
		return;
	}

	for(i=0;i<num_of_repetitions;i++)
		fprintf(fp, "%d\t%.3f\t%.3E\n", pmin_perm_pvalues[i].nsup, pmin_perm_pvalues[i].dconf, pmin_perm_pvalues[i].dpvalue);

	fclose(fp);
}


//=======================================================================================
void CMultiTestCorrector::GenPermPvalues(char* szoutput_name)
{
	char szattrvalue_filename[200], szcfp_filename[200], szcfp_stat_filename[200], szperm_filename[200];
	char szrule_filename[200];
	struct timeb start, end;
	int i, num_of_sign_rules;

	ftime(&start);

	gdused_mem_size = 0;
	gdmax_used_mem_size = 0;
	gnum_of_tests = 0;
	gnunbuffered_pvalues = 0;
	gnpartially_buffered_pvalues = 0;

	sprintf(szattrvalue_filename, "%s.attrvalue2item.txt", szoutput_name);
	LoadAttrNValues(szattrvalue_filename);

	sprintf(szcfp_stat_filename, "%s.cfptree.stat", szoutput_name);
	ReadTreeStatis(szcfp_stat_filename);
	if(gntree_size==0)
		return;

	if(gntgt_attr_type==NOMINAL && gsztarget_value[0]==0 && gnum_of_tgt_values>2 && gncompare_mode==PAIR_WISE)
		gbrule_multiclass_pairwise = true;
	else
		gbrule_multiclass_pairwise = false;


	sprintf(szcfp_filename, "%s.cfptree", szoutput_name);
	mfpcfp_file = fopen(szcfp_filename, "rb");
	if(mfpcfp_file==NULL)
	{
		printf("Error: cannot open file %s for read\n", szcfp_filename);
		return;
	}

	sprintf(szperm_filename, "%s.perm", szoutput_name);
	mfp_perm = fopen(szperm_filename, "wb");
	if(mfp_perm==NULL)
	{
		printf("Error: cannot open file %s for write\n", szperm_filename);
		return;
	}

	if(gbrule_multiclass_pairwise)
	{
		mppat_pvalues = new PAT_PVALUE[gnum_of_entries*gnum_of_tgt_values];
		IncMemSize(sizeof(PAT_PVALUE)*gnum_of_entries*gnum_of_tgt_values);
	}
	else
	{
		mppat_pvalues = new PAT_PVALUE[gnum_of_entries];
		IncMemSize(sizeof(PAT_PVALUE)*gnum_of_entries);
	}

	mpmin_perm_pvalues = new MIN_PVALUE_STAT[gnum_of_repetitions];
	IncMemSize(gnum_of_repetitions*sizeof(MIN_PVALUE_STAT));
	for(i=0;i<gnum_of_repetitions;i++)
		mpmin_perm_pvalues[i].dpvalue = 1;
	mpone_rule_perm_pvalues = NewDoubleArray(gnum_of_repetitions);

	//generate permutations
	mpperm_matrix = NewCharArray(gndb_size*gnum_of_repetitions);
	mppdata_permutations = new char*[gnum_of_repetitions];
	IncMemSize(sizeof(char*)*gnum_of_repetitions);
	for(i=0;i<gnum_of_repetitions;i++)
		mppdata_permutations[i] = &mpperm_matrix[i*gndb_size];
	GenPermutations(szoutput_name, gndb_size, gnum_of_repetitions, mppdata_permutations);

	//for dfs traversal
	mpentry_buf = NewEntryArray(gnmax_dfsentries_len);
	mptgt_stat_buf = NewCharArray(gnmax_dfsentries_len*gntgt_stat_size);
	mpperm_tgt_stat_buf = NewCharArray(gnmax_tree_depth*gnum_of_repetitions*gntgt_stat_size);
	mpdfs_tidlist_node_buf = new TID_LIST[gnmax_dfsentries_len];
	IncMemSize(sizeof(TID_LIST)*gnmax_dfsentries_len);
	mpdfs_tid_list_buf = NewIntArray(gnmax_dfs_sup_sum*2);
	mnentry_buf_pos = 0;
	mndepth = 0;
	mndfs_tidlist_buf_pos = 0;

	if(gntgt_attr_type==NOMINAL && (gntest_statisitic_method==FISHER_EXACT_TEST || gbrule_multiclass_pairwise))
		InitFactorials(gpdfactorials, gndb_size);

	gpsup_testnums = new int[gndb_size];
	memset(gpsup_testnums, 0, sizeof(int)*gndb_size);

	if(gncorrection_method==PERMUTATION_SUPERSET)
	{
		printf("Permutation: get tid lists from supersets\n");
		calc_perm_pvalues_superset(szoutput_name, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0);
	}
	else 
	{
		printf("Permutation: get tid lists from subsets\n");
		calc_perm_pvalues_subset(szoutput_name, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0);
	}

	if(gntgt_attr_type==NOMINAL && (gntest_statisitic_method==FISHER_EXACT_TEST || gbrule_multiclass_pairwise))
		DelFactorials(gpdfactorials, gndb_size);

	//release memory for dfs traversal
	DelCharArray(mpperm_tgt_stat_buf, gnmax_tree_depth*gnum_of_repetitions*gntgt_stat_size);
	delete []mpdfs_tidlist_node_buf;
	DecMemSize(sizeof(TID_LIST)*gnmax_dfsentries_len);
	DelIntArray(mpdfs_tid_list_buf, 2*gnmax_dfs_sup_sum);	

	//release memory for permutations
	DelCharArray(mpperm_matrix, gndb_size*gnum_of_repetitions);
	delete []mppdata_permutations;
	DecMemSize(sizeof(char*)*gnum_of_repetitions);

	DelDoubleArray(mpone_rule_perm_pvalues, gnum_of_repetitions);

	fclose(mfp_perm);

	ftime(&end);
	gdperm_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;

	printf("Time for permutation: %.3f\n", gdperm_time);
	printf("#unbuffered p-values: %d, #partially buffered p-values: %d\n", 	gnunbuffered_pvalues, gnpartially_buffered_pvalues);
	printf("\n");

	
	qsort(mpmin_perm_pvalues, gnum_of_repetitions, sizeof(MIN_PVALUE_STAT), comp_min_pvalue);
	gdpermFWER_pvalue_thres = mpmin_perm_pvalues[(int)(gnum_of_repetitions*gdmax_pvalue)].dpvalue;
	OutputMinPvalues(mpmin_perm_pvalues, gnum_of_repetitions, szoutput_name);
	delete []mpmin_perm_pvalues;
	DecMemSize(gnum_of_repetitions*sizeof(MIN_PVALUE_STAT));

	GetAdjustedPvalues(szperm_filename);
	OutputPvlaues(szoutput_name);

	//--------------------------------------------------------
	//extract rules 
	gnum_of_output_rules = 0;
	gntotal_context_len = 0;

	num_of_sign_rules = 0;
	if(gbrule_multiclass_pairwise)
	{
		mpsign_rule_flags = NewIntArray(gnum_of_entries*gnum_of_tgt_values, -1);
		for(i=0;i<gnum_of_tests;i++)
		{
			if((gdmax_pvalue>=1 || mppat_pvalues[i].dorig_pvalue<=gdmax_pvalue) && mppat_pvalues[i].deffect_size>=gdmin_diff)
			{
				mpsign_rule_flags[mppat_pvalues[i].npreorder*gnum_of_tgt_values+mppat_pvalues[i].ntgt_class] = i;
				num_of_sign_rules++;
			}
		}
	}
	else
	{
		mpsign_rule_flags = NewIntArray(gnum_of_entries, -1);
		for(i=0;i<gnum_of_tests;i++)
		{
			if((gdmax_pvalue>=1 || mppat_pvalues[i].dorig_pvalue<=gdmax_pvalue) && mppat_pvalues[i].deffect_size>=gdmin_diff)
			{
				mpsign_rule_flags[mppat_pvalues[i].npreorder] = i;
				num_of_sign_rules++;
			}
		}
	}
	rewind(mfpcfp_file);

	mppattern = NewIntArray(gnum_of_attrs);
	mnpat_len = 0;
	mopat_info.nsupport = gndb_size;
	mopat_info.ptgt_stat = NewCharArray(gntgt_stat_size);
	memcpy(mopat_info.ptgt_stat, gptgt_stat_array, gntgt_stat_size);
	morule.pattern = mppattern;
	morule.ppat_info = &mopat_info;
	morule.dcond_pvalue = 0;
	mnentry_buf_pos = 0;
	gndepth = 0;

	sprintf(szrule_filename, "%s.rules.txt", szoutput_name);
	mfptext = fopen(szrule_filename, "wt");
	if(mfptext==NULL)
		printf("Error: cannot open file %s for write\n", szrule_filename);
	else
	{
		extract_rules(0);
		fclose(mfptext);
	}

	fclose(mfpcfp_file);

	DelCharArray(mopat_info.ptgt_stat, gntgt_stat_size);
	DelIntArray(mppattern, gnum_of_attrs);

	DelCharArray(gptgt_stat_array, gntgt_stat_size);
	DelEntryArray(mpentry_buf, gnmax_dfsentries_len);
	DelCharArray(mptgt_stat_buf, gnmax_dfsentries_len*gntgt_stat_size);

	if(gbrule_multiclass_pairwise)
	{
		delete []mppat_pvalues;
		DecMemSize(sizeof(PAT_PVALUE)*gnum_of_entries*gnum_of_tgt_values);
		DelIntArray(mpsign_rule_flags, gnum_of_entries*gnum_of_tgt_values);
	}
	else
	{
		delete []mppat_pvalues;
		DecMemSize(sizeof(PAT_PVALUE)*gnum_of_entries);
		DelIntArray(mpsign_rule_flags, gnum_of_entries);
	}

	delete []gpAttributes;
	DecMemSize(sizeof(ATTRIBUTE)*gnum_of_attrs);
	DelCharArray(gszattr_name_buf, gnattr_name_buf_size);
	delete []gpAttrValues;
	DecMemSize(sizeof(ATTR_VALUE)*gnum_of_items);
	DelCharArray(gszattr_value_buf, gnattr_value_buf_size);

	OutputRuleSummary(szoutput_name);

	ftime(&end);
	gdgen_rule_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;
	gdgenrule_max_mem_size = gdmax_used_mem_size;

	if(gnum_of_output_rules!=num_of_sign_rules)
		printf("Error: inconsistent number of output rules\n");

	printf("#tests: %d\n", gnum_of_tests);
	printf("Time for p-value correction with %d permutations: %f\n", gnum_of_repetitions, gdgen_rule_time);
	printf("\n");
}

void CMultiTestCorrector::calc_perm_pvalues_superset(char* szoutput_name, int ndisk_pos, ENTRY* pparent_entry, TID_LIST *pparent_tid_list, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands)
{
	ENTRY *pentries;
	char *ptgt_stat_array, *pperm_tgt_stat;
	TID_LIST *ptid_lists;
	int num_of_entries, nfile_pos, i, norig_tidlist_buf_pos, ndiff_list_child_pos;

	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=ndisk_pos)
		fseek(mfpcfp_file, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptgt_stat_array = &mptgt_stat_buf[mnentry_buf_pos*gntgt_stat_size];
	pperm_tgt_stat = &mpperm_tgt_stat_buf[mndepth*gnum_of_repetitions*gntgt_stat_size];
	ptid_lists = &mpdfs_tidlist_node_buf[mnentry_buf_pos];

	norig_tidlist_buf_pos = mndfs_tidlist_buf_pos;
	ndiff_list_child_pos = -1;

	if(num_of_entries==1 || num_of_entries<0)
	{
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
		if(pentries[0].support>=gnmin_sup && (pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0)
		{
			if(num_of_entries<0)
			{
				num_of_entries = -num_of_entries;
				fseek(mfpcfp_file, sizeof(int)*(num_of_entries-1), SEEK_CUR);
			}
			fread(ptgt_stat_array, sizeof(char), gntgt_stat_size, mfpcfp_file);

			if(pparent_entry==NULL || pparent_entry->support==gndb_size)
			{
				if(pentries->support<gndb_size)
				{
					ptid_lists[0].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries->support;
					ptid_lists[0].pdiff_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries->support;
					GenItemTidLists(szoutput_name, pentries, ptid_lists, 1);
				}
			}
			else if(pparent_entry->support>pentries->support)
			{
				ptid_lists[0].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
				mndfs_tidlist_buf_pos += pentries->support;
				ptid_lists[0].pdiff_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
				mndfs_tidlist_buf_pos += pentries->support;	
				gen_child_tid_list_parentdiff(pparent_entry, pparent_tid_list, pcand_entries, pcand_tid_lists, num_of_cands, pentries, ptid_lists, 1);
			}
			else
			{
				ptid_lists[0] = *pparent_tid_list;
			}
				
			if(pentries[0].child!=0)
			{
				ndiff_list_child_pos = 0;
				mnentry_buf_pos++;
				mndepth++;
				calc_perm_pvalues_superset(szoutput_name, pentries[0].child, pentries, ptid_lists, ptgt_stat_array, pperm_tgt_stat, pcand_entries, pcand_tid_lists, num_of_cands);
				mnentry_buf_pos--;
				mndepth--;
			}
			else if(pentries->support<gndb_size)
			{
				ndiff_list_child_pos = 0;
				get_perm_tgt_stat(pperm_tgt_stat, ptid_lists);
				output_one_rule_perm(pentries, ptgt_stat_array, pperm_tgt_stat);
			}
		}

		if(pparent_entry!=NULL && pparent_entry->support<gndb_size)
		{
			if(pparent_entry->support>pentries->support)
			{
				if(ndiff_list_child_pos==-1)
				{
					get_perm_tgt_stat(pparent_perm_tgt_stat, pparent_tid_list);
					output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);
				}
				else
				{
					memcpy(pparent_perm_tgt_stat, pperm_tgt_stat, gnum_of_repetitions*gntgt_stat_size);
					get_perm_tgt_stat_superset(pparent_perm_tgt_stat, pparent_tid_list);
					output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);
				}
			}
			else
				memcpy(pparent_perm_tgt_stat, pperm_tgt_stat, gnum_of_repetitions*gntgt_stat_size);
		}
	}
	else if(num_of_entries>1)
	{
		if(gndepth<gnmax_len)
		{
			fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
			fread(ptgt_stat_array, sizeof(char), num_of_entries*gntgt_stat_size, mfpcfp_file);
			mnentry_buf_pos += num_of_entries;

			if(pparent_entry==NULL || pparent_entry->support==gndb_size)
			{
				for(i=0;i<num_of_entries;i++)
				{
					ptid_lists[i].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries[i].support;
					ptid_lists[i].pdiff_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries[i].support;
				}
				GenItemTidLists(szoutput_name, pentries, ptid_lists, num_of_entries);
			}
			else
			{
				for(i=0;i<num_of_entries;i++)
				{
					ptid_lists[i].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries[i].support;
					ptid_lists[i].pdiff_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries[i].support;	
				}
				ndiff_list_child_pos = gen_child_tid_list_parentdiff(pparent_entry, pparent_tid_list, pcand_entries, pcand_tid_lists, num_of_cands, pentries, ptid_lists, num_of_entries);
			}

			for(i=0;i<num_of_entries;i++)
			{
				mndepth++;
				gndepth++;
				if(gpAttrValues[pentries[i].item].bis_context_item && pentries[i].support>=gnmin_sup && (pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
				{
					if(pentries[i].child!=0)
						calc_perm_pvalues_superset(szoutput_name, pentries[i].child, &pentries[i], &ptid_lists[i], &ptgt_stat_array[i*gntgt_stat_size], pperm_tgt_stat, pentries, ptid_lists, i);
					else
					{
						get_perm_tgt_stat(pperm_tgt_stat, &ptid_lists[i]);
						output_one_rule_perm(&pentries[i], &ptgt_stat_array[i*gntgt_stat_size], pperm_tgt_stat);
					}
					if(i==ndiff_list_child_pos)
						memcpy(pparent_perm_tgt_stat, pperm_tgt_stat, gnum_of_repetitions*gntgt_stat_size);
				}
				mndepth--;
				gndepth--;
			}
			mnentry_buf_pos -= num_of_entries;
		}
		if(pparent_entry!=NULL && pparent_entry->support<gndb_size)
		{
			if(ndiff_list_child_pos==-1)
			{
				get_perm_tgt_stat(pparent_perm_tgt_stat, pparent_tid_list);
				output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);
			}
			else
			{
				get_perm_tgt_stat_superset(pparent_perm_tgt_stat, pparent_tid_list);
				output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);
			}
		}
	}
	else
		printf("Error with number of entires\n");

	mndfs_tidlist_buf_pos = norig_tidlist_buf_pos;
}


int CMultiTestCorrector::gen_child_tid_list_parentdiff(ENTRY* pparent_entry, TID_LIST *pparent_tid_list, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands, ENTRY *pchild_entries, TID_LIST *pchild_tid_lists, int num_of_child_entries)
{
	int i, j, nmax_sup, nmax_sup_pos;

	nmax_sup = 0;
	nmax_sup_pos = -1;
	for(i=0;i<num_of_child_entries;i++)
	{
		if(pchild_entries[i].support>=gnmin_sup && (pchild_entries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
		{
			if(nmax_sup<pchild_entries[i].support)
			{
				nmax_sup = pchild_entries[i].support;
				nmax_sup_pos = i;
			}
		}
	}

	j = 0;
	for(i=0;i<num_of_child_entries;i++)
	{
		pchild_tid_lists[i].nlen = 0;
		pchild_tid_lists[i].ndiff_len = 0;
		while(j<num_of_cands && pcand_entries[j].item<pchild_entries[i].item)
			j++;
		if(j>=num_of_cands || pcand_entries[j].item>pchild_entries[i].item)
			printf("Error: cannot find item %d in the candidate items\n", pchild_entries[i].item);
		else if(i==nmax_sup_pos)
		{
			pchild_tid_lists[i].nlen = get_intersectNdiffset(pparent_tid_list->nlen, pparent_tid_list->ptid_list, pcand_tid_lists[j].nlen, pcand_tid_lists[j].ptid_list, pchild_tid_lists[i].ptid_list, pparent_tid_list->pdiff_list, pparent_tid_list->ndiff_len);
			if(pchild_tid_lists[i].nlen!=pchild_entries[i].support)
				printf("Error: inconsistent tid list length\n");
			if(pparent_tid_list->ndiff_len!=pparent_entry->support-pchild_entries[i].support)
				printf("Error: inconsistent diff list length\n");
		}
		else
		{
			pchild_tid_lists[i].nlen = get_intersection(pparent_tid_list->nlen, pparent_tid_list->ptid_list, pcand_tid_lists[j].nlen, pcand_tid_lists[j].ptid_list, pchild_tid_lists[i].ptid_list);
			if(pchild_tid_lists[i].nlen!=pchild_entries[i].support)
				printf("Error: inconsistent tid list length\n");
		}
	}

	return nmax_sup_pos;
}

void CMultiTestCorrector::get_perm_tgt_stat(char* pperm_tgt_stat, TID_LIST *ptid_list)
{
	int i, j, *ptgt_sups;

	memset(pperm_tgt_stat, 0, gnum_of_repetitions*gntgt_stat_size);
	if(gsztarget_value[0]!=0)
	{
		for(i=0;i<gnum_of_repetitions;i++)
		{
			ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
			for(j=0;j<ptid_list->nlen;j++)
			{
				if(mppdata_permutations[i][ptid_list->ptid_list[j]]==1) //1 is the target value
					ptgt_sups[0]++;
			}
			if(ptgt_sups[0]>ptid_list->nlen)
				printf("Error: target support cannot be larger than tid list length\n");
		}
	}
	else
	{
		for(i=0;i<gnum_of_repetitions;i++)
		{
			ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
			for(j=0;j<ptid_list->nlen;j++)
				ptgt_sups[mppdata_permutations[i][ptid_list->ptid_list[j]]]++;
		}
	}
}

void CMultiTestCorrector::get_perm_tgt_stat_superset(char* pperm_tgt_stat, TID_LIST *ptid_list)
{
	int i, j, *ptgt_sups;

	if(gsztarget_value[0]!=0)
	{
		for(i=0;i<gnum_of_repetitions;i++)
		{
			ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
			for(j=0;j<ptid_list->ndiff_len;j++)
			{
				if(mppdata_permutations[i][ptid_list->pdiff_list[j]]==1) //1 is the target value
					ptgt_sups[0]++;
			}
			if(ptgt_sups[0]>ptid_list->nlen)
				printf("Error: target support cannot be larger than tid list length\n");
		}
	}
	else
	{
		for(i=0;i<gnum_of_repetitions;i++)
		{
			ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
			for(j=0;j<ptid_list->ndiff_len;j++)
				ptgt_sups[mppdata_permutations[i][ptid_list->pdiff_list[j]]]++;
		}
	}
}


void CMultiTestCorrector::output_one_rule_perm(ENTRY *pentry, char* ptgt_stat, char* pperm_tgt_stat)
{
	int i;
	double dscore, dpvalue, dorig_pvalue, deffect_size;

	if(pentry->support==gndb_size)
		return;

	if(gbrule_multiclass_pairwise)
	{
		int t, ntgt_sup, nglobal_tgt_sup;

		for(t=0;t<gnum_of_tgt_values;t++)
		{
			gpsup_testnums[pentry->support]++;

			mppat_pvalues[gnum_of_tests].npreorder = pentry->npreorder;
			mppat_pvalues[gnum_of_tests].nsup = pentry->support;
			mppat_pvalues[gnum_of_tests].ntgt_class = t;

			ntgt_sup = ((int*)ptgt_stat)[t];
			nglobal_tgt_sup = ((int*)gptgt_stat_array)[t];

			if(gneffect_size_method==CONFIDENCE)
				deffect_size = (double)ntgt_sup/pentry->support; 
			else //ODDS_RATIO
				deffect_size = (double)ntgt_sup/(pentry->support-ntgt_sup)*(gndb_size-pentry->support-(nglobal_tgt_sup-ntgt_sup))/(nglobal_tgt_sup-ntgt_sup);
			mppat_pvalues[gnum_of_tests].deffect_size = deffect_size;

			dorig_pvalue = CalcTwoTailedFisherPvalue(pentry->support, ntgt_sup, t);
			mppat_pvalues[gnum_of_tests].dorig_pvalue = dorig_pvalue;
			mppat_pvalues[gnum_of_tests].dscore = 0;

			for(i=0;i<gnum_of_repetitions;i++)
			{
				ntgt_sup = ((int*)(&pperm_tgt_stat[i*gntgt_stat_size]))[t];
				dpvalue = CalcTwoTailedFisherPvalue(pentry->support, ntgt_sup, t);
				mpone_rule_perm_pvalues[i] = dpvalue;
				if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
				{
					mpmin_perm_pvalues[i].dpvalue = dpvalue;
					mpmin_perm_pvalues[i].nsup = pentry->support;
					mpmin_perm_pvalues[i].dconf = (double)ntgt_sup/pentry->support;
				}
			}
			fwrite(mpone_rule_perm_pvalues, sizeof(double), gnum_of_repetitions, mfp_perm);

			gnum_of_tests++;
		}
	}
	else
	{
		gpsup_testnums[pentry->support]++;

		mppat_pvalues[gnum_of_tests].npreorder = pentry->npreorder;
		mppat_pvalues[gnum_of_tests].nsup = pentry->support;

		if(gneffect_size_method==CONFIDENCE)
			deffect_size = ((int*)ptgt_stat)[0]/(double)pentry->support; 
		else //ODDS_RATIO
			deffect_size = (double)(((int*)ptgt_stat)[0])*(gndb_size-pentry->support-(((int*)gptgt_stat_array)[0]-((int*)ptgt_stat)[0]))/((pentry->support-((int*)ptgt_stat)[0])*(((int*)gptgt_stat_array)[0]-((int*)ptgt_stat)[0]));
		mppat_pvalues[gnum_of_tests].deffect_size = deffect_size;

		dorig_pvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, ptgt_stat, dscore);
		mppat_pvalues[gnum_of_tests].dorig_pvalue = dorig_pvalue;
		mppat_pvalues[gnum_of_tests].dscore = dscore;

		for(i=0;i<gnum_of_repetitions;i++)
		{
			dpvalue = CalcRulePvalue(gndb_size, gptgt_stat_array, pentry->support, &pperm_tgt_stat[i*gntgt_stat_size], dscore);
			mpone_rule_perm_pvalues[i] = dpvalue;
			if(mpmin_perm_pvalues[i].dpvalue>dpvalue)
			{
				mpmin_perm_pvalues[i].dpvalue = dpvalue;
				mpmin_perm_pvalues[i].nsup = pentry->support;
				mpmin_perm_pvalues[i].dconf = ((int*)&pperm_tgt_stat[i*gntgt_stat_size])[0]/(double)pentry->support;
			}
		}
		fwrite(mpone_rule_perm_pvalues, sizeof(double), gnum_of_repetitions, mfp_perm);

		gnum_of_tests++;
	}
}


void CMultiTestCorrector::calc_perm_pvalues_subset(char* szoutput_name, int ndisk_pos, ENTRY* pparent_entry, TID_LIST *pparent_tid_list, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands)
{
	ENTRY *pentries;
	char *ptgt_stat_array, *pperm_tgt_stat;
	TID_LIST *ptid_lists;
	int num_of_entries, nfile_pos, i, norig_tidlist_buf_pos;

	nfile_pos = ftell(mfpcfp_file);
	if(nfile_pos!=ndisk_pos)
		fseek(mfpcfp_file, ndisk_pos-nfile_pos, SEEK_CUR);
	fread(&num_of_entries, sizeof(int), 1, mfpcfp_file);

	pentries = &mpentry_buf[mnentry_buf_pos];
	ptgt_stat_array = &mptgt_stat_buf[mnentry_buf_pos*gntgt_stat_size];
	pperm_tgt_stat = &mpperm_tgt_stat_buf[mndepth*gnum_of_repetitions*gntgt_stat_size];
	ptid_lists = &mpdfs_tidlist_node_buf[mnentry_buf_pos];

	norig_tidlist_buf_pos = mndfs_tidlist_buf_pos;

	if(num_of_entries==1 || num_of_entries<0)
	{
		fread(pentries, sizeof(ENTRY), 1, mfpcfp_file);
		if(pparent_entry!=NULL && pparent_entry->support<gndb_size && pparent_entry->support>pentries->support)
			output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);

		if(pentries[0].support>=gnmin_sup && (pentries[0].hash_bitmap & (1<<CFP_HASH_LEN))==0)
		{
			if(num_of_entries<0)
			{
				num_of_entries = -num_of_entries;
				fseek(mfpcfp_file, sizeof(int)*(num_of_entries-1), SEEK_CUR);
			}
			fread(ptgt_stat_array, sizeof(char), gntgt_stat_size, mfpcfp_file);

			if(pparent_entry==NULL || pparent_entry->support==gndb_size)
			{
				if(pentries->support<gndb_size)
				{
					ptid_lists[0].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries->support;
					ptid_lists[0].pdiff_list = NULL;
					GenItemTidLists(szoutput_name, pentries, ptid_lists, 1);
					get_perm_tgt_stat(pperm_tgt_stat, ptid_lists);
				}
			}
			else if(pparent_entry->support>pentries->support)
			{
				gen_child_tid_list_childdiff(pparent_entry, pparent_tid_list, pcand_entries, pcand_tid_lists, num_of_cands, pentries, ptid_lists, 1);
				get_perm_tgt_stat_subset(pparent_perm_tgt_stat, pperm_tgt_stat, ptid_lists);
			}
			else
			{
				pperm_tgt_stat = pparent_perm_tgt_stat;
				ptid_lists[0] = *pparent_tid_list;
			}
				
			if(pentries[0].child!=0)
			{
				mnentry_buf_pos++;
				mndepth++;
				calc_perm_pvalues_subset(szoutput_name, pentries[0].child, pentries, ptid_lists, ptgt_stat_array, pperm_tgt_stat, pcand_entries, pcand_tid_lists, num_of_cands);
				mnentry_buf_pos--;
				mndepth--;
			}
			else if(pentries->support<gndb_size)
				output_one_rule_perm(pentries, ptgt_stat_array, pperm_tgt_stat);
		}
	}
	else if(num_of_entries>1)
	{
		if(pparent_entry!=NULL && pparent_entry->support<gndb_size)
			output_one_rule_perm(pparent_entry, pparent_tgt_stat_array, pparent_perm_tgt_stat);

		if(gndepth<gnmax_len)
		{
			fread(pentries, sizeof(ENTRY), num_of_entries, mfpcfp_file);
			fread(ptgt_stat_array, sizeof(char), num_of_entries*gntgt_stat_size, mfpcfp_file);
			mnentry_buf_pos += num_of_entries;

			if(pparent_entry==NULL || pparent_entry->support==gndb_size)
			{
				for(i=0;i<num_of_entries;i++)
				{
					ptid_lists[i].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
					mndfs_tidlist_buf_pos += pentries[i].support;
					ptid_lists[i].pdiff_list = NULL;
				}
				GenItemTidLists(szoutput_name, pentries, ptid_lists, num_of_entries);
			}
			else
			{
				gen_child_tid_list_childdiff(pparent_entry, pparent_tid_list, pcand_entries, pcand_tid_lists, num_of_cands, pentries, ptid_lists, num_of_entries);
			}

			mndepth++;
			gndepth++;
			for(i=0;i<num_of_entries;i++)
			{
				if(gpAttrValues[pentries[i].item].bis_context_item && pentries[i].support>=gnmin_sup && (pentries[i].hash_bitmap & (1<<CFP_HASH_LEN))==0)
				{
					if(pparent_entry==NULL || pparent_entry->support==gndb_size)
						get_perm_tgt_stat(pperm_tgt_stat, &ptid_lists[i]);
					else
						get_perm_tgt_stat_subset(pparent_perm_tgt_stat, pperm_tgt_stat, &ptid_lists[i]);

					if(pentries[i].child!=0)
						calc_perm_pvalues_subset(szoutput_name, pentries[i].child, &pentries[i], &ptid_lists[i], &ptgt_stat_array[i*gntgt_stat_size], pperm_tgt_stat, pentries, ptid_lists, i);
					else
						output_one_rule_perm(&pentries[i], &ptgt_stat_array[i*gntgt_stat_size], pperm_tgt_stat);
				}
			}
			mndepth--;
			gndepth--;

			mnentry_buf_pos -= num_of_entries;
		}
	}
	else
		printf("Error with number of entires\n");

	mndfs_tidlist_buf_pos = norig_tidlist_buf_pos;
}

void CMultiTestCorrector::gen_child_tid_list_childdiff(ENTRY* pparent_entry, TID_LIST *pparent_tid_list, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands, ENTRY *pchild_entries, TID_LIST *pchild_tid_lists, int num_of_child_entries)
{
	int i, j;

	j = 0;
	for(i=0;i<num_of_child_entries;i++)
	{
		pchild_tid_lists[i].nlen = 0;
		pchild_tid_lists[i].ndiff_len = 0;
		while(j<num_of_cands && pcand_entries[j].item<pchild_entries[i].item)
			j++;
		if(j>=num_of_cands || pcand_entries[j].item>pchild_entries[i].item)
			printf("Error: cannot find item %d in the candidate items\n", pchild_entries[i].item);
		else if(gbdiff_tid_list && pchild_entries[i].support>pparent_entry->support-pchild_entries[i].support)
		{
			pchild_tid_lists[i].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
			mndfs_tidlist_buf_pos += pchild_entries[i].support;
			pchild_tid_lists[i].pdiff_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
			mndfs_tidlist_buf_pos += pchild_entries[i].support;	

			pchild_tid_lists[i].nlen = get_intersectNdiffset(pparent_tid_list->nlen, pparent_tid_list->ptid_list, pcand_tid_lists[j].nlen, pcand_tid_lists[j].ptid_list, pchild_tid_lists[i].ptid_list, pchild_tid_lists[i].pdiff_list, pchild_tid_lists[i].ndiff_len);
			if(pchild_tid_lists[i].nlen!=pchild_entries[i].support)
				printf("Error: inconsistent tid list length\n");
			if(pchild_tid_lists[i].ndiff_len!=pparent_entry->support-pchild_entries[i].support)
				printf("Error: inconsistent diff list length\n");
		}
		else
		{
			pchild_tid_lists[i].ptid_list = &mpdfs_tid_list_buf[mndfs_tidlist_buf_pos];
			mndfs_tidlist_buf_pos += pchild_entries[i].support;
			pchild_tid_lists[i].pdiff_list = NULL;

			pchild_tid_lists[i].nlen = get_intersection(pparent_tid_list->nlen, pparent_tid_list->ptid_list, pcand_tid_lists[j].nlen, pcand_tid_lists[j].ptid_list, pchild_tid_lists[i].ptid_list);
			if(pchild_tid_lists[i].nlen!=pchild_entries[i].support)
				printf("Error: inconsistent tid list length\n");

			pchild_tid_lists[i].ndiff_len = pparent_entry->support-pchild_entries[i].support;
		}
	}
}

void CMultiTestCorrector::get_perm_tgt_stat_subset(char* pparent_perm_tgt_stat, char* pperm_tgt_stat, TID_LIST *ptid_list)
{
	int i, j, *ptgt_sups;

	if(ptid_list->pdiff_list==NULL)//from the origianl list
	{
		memset(pperm_tgt_stat, 0, gnum_of_repetitions*gntgt_stat_size);
		if(gsztarget_value[0]!=0)
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<ptid_list->nlen;j++)
				{
					if(mppdata_permutations[i][ptid_list->ptid_list[j]]==1) //1 is the target value
						ptgt_sups[0]++;
				}
				if(ptgt_sups[0]>ptid_list->nlen)
					printf("Error: target support cannot be larger than tid list length\n");
			}
		}
		else
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<ptid_list->nlen;j++)
					ptgt_sups[mppdata_permutations[i][ptid_list->ptid_list[j]]]++;
			}
		}
	}
	else //from diff list
	{
		memcpy(pperm_tgt_stat, pparent_perm_tgt_stat, gnum_of_repetitions*gntgt_stat_size);
		if(gsztarget_value[0]!=0)
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<ptid_list->ndiff_len;j++)
				{
					if(mppdata_permutations[i][ptid_list->pdiff_list[j]]==1) //1 is the target value
						ptgt_sups[0]--;
				}
				if(ptgt_sups[0]>ptid_list->nlen)
					printf("Error: target support cannot be larger than tid list length\n");
			}
		}
		else
		{
			for(i=0;i<gnum_of_repetitions;i++)
			{
				ptgt_sups = (int*)&pperm_tgt_stat[i*gntgt_stat_size];
				for(j=0;j<ptid_list->ndiff_len;j++)
					ptgt_sups[mppdata_permutations[i][ptid_list->pdiff_list[j]]]--;
			}
		}
	}
}



int comp_pvalues_orig(const void *e1, const void *e2)
{
	PAT_PVALUE *p1, *p2;

	p1 = (PAT_PVALUE*)e1;
	p2 = (PAT_PVALUE*)e2;

	if(p1->dorig_pvalue < p2->dorig_pvalue)
		return -1;
	else if(p1->dorig_pvalue > p2->dorig_pvalue)
		return 1;
	else
		return 0;
}


int comp_double(const void *e1, const void *e2)
{
	double d1, d2;

	d1 =  *(double*)e1;
	d2 =  *(double*)e2;

	if(d1 < d2)
		return -1;
	else if(d1 > d2)
		return 1;
	else
		return 0;
}

int comp_min_pvalue(const void *e1, const void *e2)
{
	MIN_PVALUE_STAT *p1, *p2;

	p1 = (MIN_PVALUE_STAT*)e1;
	p2 = (MIN_PVALUE_STAT*)e2;

	if(p1->dpvalue < p2->dpvalue)
		return -1;
	else if(p1->dpvalue > p2->dpvalue)
		return 1;
	else
		return 0;
}


int binary_search(double *parray, int nlength, double dtgt_value)
{
	int nstart, nend, nmid, i;

	if(nlength<10)
	{
		for(i=0;i<nlength;i++)
		{
			if(parray[i]==dtgt_value)
			{
				while(i<nlength && parray[i]==dtgt_value)
					i++;
				return i;
			}
			else if(parray[i]>dtgt_value)
				return i;
		}
	}
	else 
	{
		nstart = 0;
		nend = nlength-1;
		while(nend>=nstart)
		{
			if(parray[nend]==dtgt_value)
				return nend;
			nmid = (nstart+nend)/2;
			if(parray[nmid]==dtgt_value)
			{
				if(parray[nmid+1]>dtgt_value)
					return nmid;
				else
					nstart = nmid+1;
			}
			else if(parray[nmid]<dtgt_value)
				nstart = nmid+1;
			else 
				nend = nmid-1;
		}
		if(nend<0)
			return 0;
		else
		{
			return nstart;

			while(nend<nlength && parray[nend]<=dtgt_value)
				nend++;
			return nend;
		}
	}

	return nlength;
}

