#pragma once 

#include "global.h"
#include "cfptree_outbuf.h"
#include "cfptree_ehta.h"
#include "stocc.h"

#include "gen_tidlist.h"



struct TID_LIST
{
	int nlen;
	int ndiff_len;
	int *ptid_list;
	int *pdiff_list;
};

struct PAT_PVALUE
{
	int npreorder;
	int nsup;
	double deffect_size;
	double dscore;
	double dorig_pvalue;
	double dind_adj_pvalue;
	double dadj_pvalue;
	int ntgt_class;
};

struct MIN_PVALUE_STAT
{
	double dpvalue;
	double dconf;
	int nsup;
};

struct DFS_NODE
{
	ENTRY *pentries;
	char *pperm_tgt_stat_buf;
	int ncur_pos;
};

struct PARENT_NODE
{
	ENTRY *pentry;
	int* pperm_tgt_sups;
};

struct SUP_BOUND
{
	int nupper_bound;
	int nlower_bound;
};

class CMultiTestCorrector
{
	FILE *mfp_tdb, *mfp_tdb_dir, *mfp_tgt;
	int mfp_tdb_pos, mntrans_num;

	FILE *mfpcfp_file, *mfptext;
	ENTRY *mpentry_buf;
	int mnentry_buf_pos;
	PAT_DIR_NODE *mppat_dir_nodes;
	TID_LIST *mptid_list_buf;
	int mntidlist_pos, mnum_of_lists, mndfs_list_len, mnmax_dfs_list_len, mnmax_tidlist_len;
	FILE *mfp_list;

	PAT_PVALUE *mppat_pvalues;
	FILE *mfp_perm;
	char **mppdata_permutations, *mpperm_matrix;
	char *mptgt_stat_buf;
	char *mpperm_tgt_stat_buf, *mpremain_perm_tgt_stat_buf;
	TID_LIST *mpdfs_tidlist_node_buf;
	int *mpdfs_tid_list_buf, mndfs_tidlist_buf_pos;
	MIN_PVALUE_STAT *mpmin_perm_pvalues;
	double *mpone_rule_perm_pvalues;
	int *mptid_list, mndepth;
	DFS_NODE *mpdfs_stack;
	int mntop;
	char *mpitem_bitmap;
	PARENT_NODE *mpparent_nodes;
	SUP_BOUND *mptgt_sup_bounds;

	int *mpsign_rule_flags;
	int *mppattern, mnpat_len;
	PAT_INFO mopat_info;
	ASSOCRULE morule;

	void GenItemTidLists(char* szoutput_name, ENTRY *pentries, TID_LIST *ptid_lists, int num_of_entries);

	//pre-compute tid lists
	void gen_pat_tid_list(ENTRY* pparent_entry, TID_LIST *pparent_list, int ngrandparent_sup, ENTRY *pcandidate_entries, TID_LIST *pcandidate_tid_lists, int num_of_candidate_entries);
	void IntersectTidLists(TID_LIST *ptid_list1, TID_LIST *ptid_list2, TID_LIST *presult_tid_list, int nresult_len);	
	int OutputOneTidList(int nentry_no, int nparent_sup, TID_LIST *ptid_list);
	int LoadOneTidList(FILE *fp, int ndisk_pos, int *ptid_list);
	void OutputPatDirNodes(char *szoutput_name, PAT_DIR_NODE *ppat_dir_nodes, int ntotal_entries);
	
	void GenPermutations(char* szoutput_name, int ndb_size, int num_of_permutations, char **ppdata_permutations);
	void AnalyzePermData(char* szoutput_name, char **ppdata_permutations, int ndb_size, int num_of_permutations);

	//percomputed tid lists
	void calc_perm_pvalues(int ndisk_pos, char* pparent_perm_tgt_stat);
	void CalcPermPvalues(ENTRY *pentry, char* ptgt_stat, char* pparent_perm_tgt_stat, char* pperm_tgt_stat);

	//generate tid lists on the fly and generate permutation statistics from subsets
	void calc_perm_pvalues_subset(char* szoutput_name, int ndisk_pos, ENTRY* pparent_entry, TID_LIST *pparent_tid_list, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, ENTRY *pcand_entries, TID_LIST *pcand_tidlists, int num_of_cands);
	void gen_child_tid_list_childdiff(ENTRY* pparent_entry, TID_LIST *pparent_tid_list, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands, ENTRY *pchild_entries, TID_LIST *pchild_tid_lists, int num_of_child_entries);
	void get_perm_tgt_stat_subset(char* pparent_perm_tgt_stat, char* pperm_tgt_stat, TID_LIST *ptid_list);

	//generate permutation statistics from superset
	void calc_perm_pvalues_superset(char* szoutput_name, int ndisk_pos, ENTRY* pparent_entry, TID_LIST *pparent_tid_list, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, ENTRY *pcand_entries, TID_LIST *pcand_tidlists, int num_of_cands);
	int gen_child_tid_list_parentdiff(ENTRY* pparent_entry, TID_LIST *pparent_tid_list, ENTRY *pcand_entries, TID_LIST *pcand_tid_lists, int num_of_cands, ENTRY *pchild_entries, TID_LIST *pchild_tid_lists, int num_of_child_entries);
	void get_perm_tgt_stat(char* pperm_tgt_stat, TID_LIST *ptid_list);
	void get_perm_tgt_stat_superset(char* pperm_tgt_stat, TID_LIST *ptid_list);
	void output_one_rule_perm(ENTRY *pentry, char* ptgt_stat, char* pperm_tgt_stat);

	void GetAdjustedPvalues(char* szperm_filename);
	void OutputPvlaues(char* szouput_name);

	void extract_rules(int ndisk_pos);

	void OutputMinPvalues(MIN_PVALUE_STAT *pmin_perm_pvalues, int num_of_repetitions, char* szoutput_name);



	//for simulated permuation tests
	char **mptree_buffer;
	int mnbuf_size, mnbuf_num_of_pages, mninbuf_start_pos, mninbuf_end_pos;
	int *mpcofreq_matrix, *mpentry_item_order_map;
	ENTRY *mpentries;
	SUP_BOUND **mpptgt_sup_bounds;

	void dfs_calc_simulated_pvalues_subset(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat);
	void get_perm_tgt_stat(int nrule_sup, char* pperm_tgt_stat);
	void get_perm_tgt_stat_subset(int nparent_sup, char* pparent_perm_tgt_stat, int nrule_sup, char* pperm_tgt_stat);
	
	void dfs_calc_simulated_pvalues_subset_sib(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat);

	void dfs_calc_simulated_pvalues_subset_leftsib(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, int ngrandparent_remain_sup, char* pgrandparent_remain_perm_tgt_stat, ENTRY *pgrandparent_entry, char* pgrandparent_perm_tgt_stat, ENTRY *psib_entries, char* psib_perm_tgt_stat_buf, int num_of_sibs, bool bisfreqNclosed);
	void get_tgt_sup_bounds(ENTRY *pentry, ENTRY *psib_entries, char* psib_perm_tgt_stat_buf, int num_of_sibs, ENTRY *pchild_entries, int num_of_child_entries, ENTRY* pparent_entry, char *pparent_perm_tgt_stat, bool buse_infreq_sibs, SUP_BOUND *ptgt_sup_bounds);
	void get_perm_tgt_stat(int nrule_sup, char* pperm_tgt_stat, SUP_BOUND *ptgt_sup_bounds);
	void get_perm_tgt_stat_subset(int nparent_sup, char* pparent_perm_tgt_stat, int nrule_sup, char* pperm_tgt_stat, SUP_BOUND *ptgt_sup_bounds);

	//void dfs_calc_simulated_pvalues_subset_allsib(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat, int ngrandparent_remain_sup, char* pgrandparent_remain_perm_tgt_stat, ENTRY *pgrandparent_entry, char* pgrandparent_perm_tgt_stat, ENTRY *psib_entries, char* psib_perm_tgt_stat_buf, int num_of_sibs, bool bisfreqNclosed);
	void dfs_calc_simulated_pvalues_subset_allsib(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat);
	void get_cofreq_matrix(ENTRY *pentries, int num_of_entries, int nstart_boundary);
	int load_one_node(int ndisk_pos, int nstart_boundary, ENTRY* pentries);
	void get_tgt_sup_bounds(ENTRY *pentries, int num_of_entries, int *pco_freq_matrix, SUP_BOUND **ptgt_sup_bounds);
	void get_tgt_sup_bounds(ENTRY *pentry, int num_of_entries, ENTRY* pparent_entry, char *pparent_perm_tgt_stat, int *pco_freq_matrix, SUP_BOUND **ptgt_sup_bounds);
	void update_sib_tgt_sup_bound(ENTRY *pentries, int num_of_entries, int k, int *pco_freq_matrix, char *pparent_perm_tgt_sups, int *pperm_tgt_sups, SUP_BOUND **pptgt_sup_bounds);
	void update_sib_tgt_sup_bound(ENTRY *pentries, int num_of_entries, int k, int *pco_freq_matrix, int *pperm_tgt_sups, SUP_BOUND **pptgt_sup_bounds);

	void dfs_calc_simulated_pvalues_superset(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat);
	void get_perm_tgt_stat_superset(int nrule_sup, char* pperm_tgt_stat, int nparent_sup, char* pparent_perm_tgt_stat);

	void hybrid_simulated_pvalues(char* szoutput_name);

	void dfs_calc_simulated_pvalues_subsets(int ndisk_pos, ENTRY* pparent_entry, char* pparent_tgt_stat_array, char* pparent_perm_tgt_stat);
	int get_parents(int ntop);
	void get_perm_tgt_stat_subsets(PARENT_NODE *pparent_nodes, int num_of_parents, int nrule_sup, char* pperm_tgt_stat);

	int LoadPages(int nstart_pos_boundary, int ndisk_pos);

public:

	//generate the tid list of closed entries, and generate difflist instead of full list if the former is smaller
	void GenPatTidLists(char* szoutput_name);

	void GenPermPvalues(char* szoutput_name);
	void GenPermPvaluesPrecomputedTidLists(char* szoutput_name);

	void SimulatePerm(char* szoutput_name);

	int LoadPatDirNodes(char* szoutput_name, PAT_DIR_NODE *&ppat_dir_nodes);

	int GetOneTidList(FILE *fp, PAT_DIR_NODE *ppat_dir_nodes, int npreorder, int *ppat_tid_list, int *ptemp_list1, int *ptemp_list2, int *ptemp_list3);
};

extern CMultiTestCorrector  gomultitest_corrector;


int comp_double(const void *e1, const void *e2);
int comp_min_pvalue(const void *e1, const void *e2);
int binary_search(double *parray, int nlength, double dtgt_value);

extern bool gbtwo_tailed_fisher_test;

//
#define LOCAL_PVALUE_BUF_SIZE (1<<23)
extern int gnlocal_pvalue_buf_size;
extern double* gplocal_pvalue_buf;
extern double** gpplocal_sup_pvalues;
extern bool* gplocal_sup_filled_flags;
extern int gnlocal_pvalue_cutoff_sup;
extern double *gplocal_high_sup_pvalues; 
extern int gnlocal_buffered_high_sup;

void InitLocalPvalueBuf(int nparent_sup, int nrule_sup);
double* GetLocalCumulativeDistr(int n, int x, int y, int nlower_bound);
double* GetCumulativeDistr(int y, int nlower_bound);




