#pragma once 
#include "global.h"
#include "cfptree_ehta.h"

extern double gppvalues[20];

#define MANN_WHITNEY_TEST_THRES  25

inline double LookupOneRow(double dscore, double *pone_row, int nrow_size)
{
	int i;

	i = 0;
	while(i<nrow_size && dscore>pone_row[i])
		i++;
	if(i>0)
		i--;

	return gppvalues[i];
}

//------------------ t-test -----------------------------
extern double *gppt_table[30];
extern double gpdf30_t_table[20];
extern double gpdf40_t_table[20];
extern double gpdf60_t_table[20];
extern double gpdf80_t_table[20];
extern double gpdf100_t_table[20];
extern double gpdf1000_t_table[20];

inline double LookupTtable(double dt_score, int ndf)
{
	int nrow_size = 20;

	if(dt_score==0)
		return 1;
	else if(ndf>=1000)
		return LookupOneRow(dt_score, gpdf1000_t_table, nrow_size);
	else if(ndf>=100)
		return LookupOneRow(dt_score, gpdf100_t_table, nrow_size);
	else if(ndf>=80)
		return LookupOneRow(dt_score, gpdf80_t_table, nrow_size);
	else if(ndf>=60)
		return LookupOneRow(dt_score, gpdf60_t_table, nrow_size);
	else if(ndf>=40)
		return LookupOneRow(dt_score, gpdf40_t_table, nrow_size);
	else if(ndf>=30)
		return LookupOneRow(dt_score, gpdf30_t_table, nrow_size);
	else
		return LookupOneRow(dt_score, gppt_table[ndf], nrow_size);
}


//====================== X2-test =======================================
extern double *gppx2_table[13];
extern double gpdf20_x2_table[20];
extern double gpdf30_x2_table[20];
extern double gpdf40_x2_table[20];
extern double gpdf60_x2_table[20];
extern double gpdf80_x2_table[20];
extern double gpdf100_x2_table[20];
extern double gpdf1000_x2_table[20];


inline double LookupX2table(double dx2_score, int ndf)
{
	int nrow_size = 20;

	if(dx2_score==0 || ndf>1000)
		return 1;
	else if(ndf<=12)
		return LookupOneRow(dx2_score, gppx2_table[ndf], nrow_size);
	else if(ndf<=20)
		return LookupOneRow(dx2_score, gpdf20_x2_table, nrow_size);
	else if(ndf<=30)
		return LookupOneRow(dx2_score, gpdf30_x2_table, nrow_size);
	else if(ndf<=40)
		return LookupOneRow(dx2_score, gpdf40_x2_table, nrow_size);
	else if(ndf<=60)
		return LookupOneRow(dx2_score, gpdf60_x2_table, nrow_size);
	else if(ndf<80)
		return LookupOneRow(dx2_score, gpdf80_x2_table, nrow_size);
	else if(ndf<100)
		return LookupOneRow(dx2_score, gpdf100_x2_table, nrow_size);
	else
		return LookupOneRow(dx2_score, gpdf1000_x2_table, nrow_size);

}

// -----------------------  fisher's exact test --------------------------------
//#define PVALUE_BUF_SIZE  (1<<26)
extern double *gpdfactorials;

extern int gnpvalue_buf_size;
extern int gnpvalue_cutoff_sup;
extern double* gppvalue_buf;
extern double** gppsup_pvalues;
extern int *gpsup_filled_pos;

//for those pvalues that cannot be buffered because the coverage is too high, use an array to do temporary buffering
extern double *gphigh_sup_pvalues; 
extern int gnbuffered_high_sup;
extern int gnhigh_sup_filled_pos;

extern int gnunbuffered_pvalues;
extern int gnpartially_buffered_pvalues;

double HyperGeometric(int n, int x, int y, int k);

void InitFactorials(double* &pdfactorials, int n);
void DelFactorials(double *pdfactorials, int n);

double CalcFisherPvalue(int n, int x, int y, int k); //one tailed fisher's exact test

int FillTwoTailedPvalues(double *ppvalues, int x, int y);
double CalcTwoTailedFisherPvalue(int n, int x, int y, int k);
double CalcTwoTailedFisherPvalue(int y, int k, int nclass_no);



double CalcPvalue(DIFF_ITEM *pdiff_item1, DIFF_ITEM *pdiff_item2, double &dscore, bool bhas_min_diff);
double CalcPvalue(PAT_INFO *ppat_info, DIFF_ITEM *pdiff_items, int num_of_diff_items, double &dscore, int &num_of_groups);

double CalcRulePvalue(int nglobal_sup, char* pglobal_tgt_stat, int nXsup, char* pXtgt_stat, double &dscore, int *ptid_list, double *ptgt_values);
double CalcRulePvalue(int nglobal_sup, char* pglobal_tgt_stat, int nXsup, char* pXtgt_stat, double &dscore);


//--- for Mann-Whitney test
struct GROUP_TGT_VALUE
{
	double dtgt_value;
	int ngroup_no;
};

extern GROUP_TGT_VALUE* gpgroup_tgt_values;
extern double *gpgroup_rank_avgs;
//---


//=== for the case when #classes>2 and comparison is pairwise
struct DYN_PVALUE_BUF
{
	double *ppvalues;
	int nsup;
	int nfilled_pos;
};

extern DYN_PVALUE_BUF *gpdyn_pvalue_bufs;
//===

