#include <time.h>
#include <sys/timeb.h>

#include "global.h"

int GetRowNum(char *szfilename)
{
	FILE *fp;
	int num_of_rows;
	char ch;

	fp = fopen(szfilename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szfilename);
		return 0;
	}

	num_of_rows = 0;
	ch = fgetc(fp);
	while(!feof(fp))
	{
		while(!feof(fp) && ch!='\n')
			ch = fgetc(fp);
		num_of_rows++;

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);

	return num_of_rows;
}

void GenParaFile(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_mode, char* szrep_mine_method, double drep_ratio, char* szmine_pat_option, char* szgen_hyp_option, char* szanalyze_option, char* szoutput_format, char* szoutput_name, char* szpara_filename)
{
	FILE *fp;

	fp = fopen(szpara_filename, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szpara_filename);
		return;
	}

	fprintf(fp, "data_file=%s.data\n", szdataset_name);
	fprintf(fp, "names_file=%s.names\n\n", szdataset_name);

	fprintf(fp, "materialization_mode=freq + infreq border\n\n");

	fprintf(fp, "signal_type=hypothesis\n\n");

	fprintf(fp, "context_attributes=\n");
	fprintf(fp, "comparing_attributes=\n");
	fprintf(fp, "target_attribute=%s\n", sztarget_attr);
	fprintf(fp, "target_value=%s\n", sztarget_value);
	//fprintf(fp, "test-statistic=fisher's exact test\n");
	//fprintf(fp, "test-statistic=x2\n");

	fprintf(fp, "max_len=%d\n", nmax_len);
	fprintf(fp, "min_sup=%.3f\n", dmin_sup);	
	fprintf(fp, "max_pvalue=%f\n", dmax_pvalue);
	fprintf(fp, "min_effect_size=%f\n\n", dmin_effect_size);

	fprintf(fp, "mine_pats=%s\n", szmine_pat_option);
	fprintf(fp, "gen_signals=%s\n", szgen_hyp_option);
	fprintf(fp, "analyze_signals=%s\n", szanalyze_option);
	fprintf(fp, "output_format=%s\n\n", szoutput_format);

	fprintf(fp, "output_mode=%s\n", szoutput_mode);
	fprintf(fp, "rep_mine_method=%s\n", szrep_mine_method);
	fprintf(fp, "representative_measure=diff_lift\n");
	fprintf(fp, "representative_thres=%.2f\n", drep_ratio);

	fprintf(fp, "output=%s\n", szoutput_name);

	fclose(fp);
}

void GenRepHyps(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_name, char* szrep_mine_method, double dratio)
{
	char szcmd[500];

	//GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "representative", szrep_mine_method, dratio, "yes", "yes", "look_deeper_and_broader", "text", szoutput_name, "D.para");
	GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "representative", szrep_mine_method, dratio, "yes", "yes", "no", "none", szoutput_name, "D.para");

	sprintf(szcmd, ".\\exec\\EHTA D.para\n");
	printf(szcmd);
	system(szcmd);

}


/*
void GenRepHypotheses(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_name, double dratio)
{
	FILE *fpsum;
	char szcmd[500], szsum_filename[200];
	struct timeb start, end;
	double dgen_hyp_time, dgen_rep_hyp_time;
	int num_of_hyps, num_of_rep_hyps;

	sprintf(szsum_filename, "EHTA.%.2f.sum.txt", dratio);
	fpsum = fopen(szsum_filename, "a+");
	if(fpsum==NULL)
	{
		printf("Error: cannot open file EHTA_API.sum.txt for appending\n");
		return;
	}

	GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "yes", "no", "no", "text", szoutput_name, "D.para");

	sprintf(szcmd, ".\\exec\\EHTA_API 2 D.para\n");
	printf(szcmd);
	ftime(&start);
	system(szcmd);
	ftime(&end);
	dgen_hyp_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;

	printf("CFP-tree constructed\n");

	num_of_hyps = GetRowNum("D.hypotheses.txt");

	sprintf(szcmd, ".\\exec\\EHTA_API 6 D %.3f\n", dratio);
	printf(szcmd);
	ftime(&start);
	system(szcmd);
	ftime(&end);
	dgen_rep_hyp_time = end.time-start.time+(double)(end.millitm-start.millitm)/1000;

	num_of_rep_hyps = GetRowNum("D.rep.hypotheses.txt");

	fprintf(fpsum, "%s\t%s=%s\t", szdataset_name, sztarget_attr, sztarget_value);
	fprintf(fpsum, "%d\t%.5f\t%.2E\t%.3f\t%.3f\t", nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, dratio);
	fprintf(fpsum, "%d\t%d\t%.3f\t%.3f\n", num_of_hyps, num_of_rep_hyps, dgen_hyp_time, dgen_rep_hyp_time);

	fclose(fpsum);
}
*/

void GenAllHypotheses(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_name)
{
	char szcmd[500];

	//GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "all", "", 0, "yes", "yes", "look_deeper_and_broader", "text", szoutput_name, "D.para");
	GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "all", "", 0, "yes", "yes", "no", "none", szoutput_name, "D.para");

	sprintf(szcmd, ".\\exec\\EHTA D.para\n");
	printf(szcmd);
	system(szcmd);
}

void AnalyzeHypotheses(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szanalyze_option, char* szoutput_name)
{
	char szcmd[500];

	GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "representative", "comp_items", 0.1, "no", "no", szanalyze_option, "html", szoutput_name, "D.para");

	sprintf(szcmd, ".\\exec\\EHTA D.para\n");
	printf(szcmd);
	system(szcmd);
}

void GenNAnalyzeHypotheses(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_name)
{
	char szcmd[500];

	GenParaFile(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, "representative", "comp_items", 0.1, "yes", "yes", "look_deeper_and_broader", "html", szoutput_name, "D.para");

	sprintf(szcmd, ".\\exec\\EHTA D.para\n");
	printf(szcmd);
	system(szcmd);
}

void GenHypotheses(char* szdataset_name, char* sztarget_attr, char* sztarget_value, int nmax_len, double dmin_sup, double dmax_pvalue, double dmin_effect_size, char* szoutput_name)
{
	//GenNAnalyzeHypotheses(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name);

	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "comp_items", 0.1);
	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "context", 0.1);

	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "comp_items", 0.3);
	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "context", 0.3);

	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "comp_items", 0.5);
	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "context", 0.5);

	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "comp_items", 1);
	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "context", 1);

	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "comp_items", 2);
	GenRepHyps(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name, "context", 2);

	GenAllHypotheses(szdataset_name, sztarget_attr, sztarget_value, nmax_len, dmin_sup, dmax_pvalue, dmin_effect_size, szoutput_name);

}

void VaryMinSup()
{

	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.002, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.005, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.01, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.02, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.03, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.04, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\adult_all_discrt", "class", ">50K.", 100, 0.05, 0.05, 0, "D");

	GenHypotheses("D:\\Research\\EHT\\dataset\\german-discrt", "class", "bad.", 100, 0.01, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\german-discrt", "class", "bad.", 100, 0.02, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\german-discrt", "class", "bad.", 100, 0.03, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\german-discrt", "class", "bad.", 100, 0.04, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\german-discrt", "class", "bad.", 100, 0.05, 0.05, 0, "D");

	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.01, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.02, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.04, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.05, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.06, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.08, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\mushroom", "class", "p", 100, 0.1, 0.05, 0, "D");


	GenHypotheses("D:\\Research\\EHT\\dataset\\sick_all_discrt", "class", "sick.", 100, 0.1, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\sick_all_discrt", "class", "sick.", 100, 0.15, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\sick_all_discrt", "class", "sick.", 100, 0.2, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\sick_all_discrt", "class", "sick.", 100, 0.25, 0.05, 0, "D");
	GenHypotheses("D:\\Research\\EHT\\dataset\\sick_all_discrt", "class", "sick.", 100, 0.3, 0.05, 0, "D");


	//GenHypotheses("D:\\Research\\EHT\\dataset\\breast-discrt", "class", "malignant.", 100, 0.02, 0.05, 0, "D");
	//GenHypotheses("D:\\Research\\EHT\\dataset\\cleve-heart-discrt", "class", "sick.", 100, 0.05, 0.05, 0, "D");
	//GenHypotheses("D:\\Research\\EHT\\dataset\\diabetes-discrt", "class", "1.", 100, 0.02, 0.05, 0, "D");
	//GenHypotheses("D:\\Research\\EHT\\dataset\\hepati-discrt", "class", "1.", 100, 0.1, 0.05, 0, "D");

}

