#pragma once

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <algorithm>
#include <map>

#include "global.h"

void holdout(char *szmine_dataset, char *szcheck_dataset, char *szoutput_name, char* sztarget_attr, char* sztarget_value, 
			 int nmine_min_sup, int nmine_max_len, double dmine_pvalue, double dmine_local_pvalue, 
			 int neffect_size_method, double dmine_effect_size);
void output_tgtvalues(char *szoutput_name, int *ptgt_values, int num, std::vector<int> *targets);
void read_convert(char *szcheck_dataset, std::vector<std::vector<int> *> *converted, std::vector<int> *targets, char *szoutput_name);
void holdout_rules(char *szrule_output_name, std::vector<std::vector<int> *> *converted, std::vector<int> *targets, char *szoutput_name, double dvalid_pvalue);
void valid(int nfirst_dataset_size, ASSOCRULE *pmined_rules, int num_of_mined_rules, std::vector<std::vector<int>*>* converted, std::vector<int> *targets,  std::vector<ASSOCRULE *> *pvalid_rules, int nmin_sup, double dvalid_pvalue);
void recalculate(std::vector<ASSOCRULE *> *pvalid_rules, int num_of_mined_rules, double dvalid_pvalue, SIGN_RULE_NUM &thesign_rule_nums);
void output_holdout_rules(std::vector<ASSOCRULE *> *pvalid_rules, char *szoutput_name, SIGN_RULE_NUM &thesign_rule_nums, int num_of_mined_rules, double dmine_pvalue);

void split(std::string s, std::vector< std::string > &tokens, char delim);
void copy(ASSOCRULE *dest, ASSOCRULE *src);
bool compare(ASSOCRULE* first, ASSOCRULE* second);
