#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <crtdbg.h>
#include <time.h>
#include <sys/timeb.h>

#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <algorithm>
#include <iostream>

#include "global.h"

int gnum_of_classes;
char gszmine_target_value[10];
char gszembed_target_value[10];


int main(int argc, char *argv[])
{
	if (argc != 7)
	{
		printf("Usage\n");
		printf("\t%s dataset_name target_attr target_value mine_min_sup max_pvalue output_name \n", argv[0]);
		return 0;
	}

	int nmine_min_sup = atoi(argv[4]);
	if (nmine_min_sup < 1)
	{
		printf("Error: please specify a positive integer as the minimum support threshold on the mining dataset\n");
		return -1;
	}
	double dmax_pvalue;
	dmax_pvalue = atof(argv[5]);
	if (dmax_pvalue <= 0 || dmax_pvalue>1)
	{
		printf("Error: please specify a value between 0 and 1 as the maximum p-value threshold\n");
		return -1;
	}

	RandomHoldout(argv[1], argv[2], argv[3], nmine_min_sup, 100, dmax_pvalue, 0, argv[6]);

	//_CrtDumpMemoryLeaks();

	return 0;
}
