#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <map>
using namespace std;

#include "global.h"


int gndataset_instant_num;
int gndataset_attr_num;
int gndataset_rule_num;
int gndataset_rule_sup;
double gddataset_rule_conf;

void GenSynDatasets(int num_of_rows, int num_of_pos_rows, int num_of_clmns, int nmin_v, int nmax_v, int num_of_rules, int nmin_len, int nmax_len, int nmin_sup, int nmax_sup, int nchoice, double dmin_es, double dmax_es, int num_of_datasets, char* szoutput_name)
{
	FILE *fp;
	char szcmd[500];

	fp = fopen("asgen.conf", "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file asgen.conf for write\n");
		return;
	}

	fprintf(fp, "output_file = %s\n", szoutput_name);
	fprintf(fp, "option = 0\n"); 
	fprintf(fp, "no_of_dataset = %d\n", num_of_datasets);

	fprintf(fp, "no_of_inst = %d\n", num_of_rows);
	fprintf(fp, "\n");

	fprintf(fp, "no_of_class = %d\n", gnum_of_classes);
	fprintf(fp, "target_class = %s\n", gszembed_target_value);
	if(gnum_of_classes==2)
		//fprintf(fp, "no_of_positive_inst = %d\n", num_of_pos_rows);
		fprintf(fp, "no_of_inst_with_target_class = %d\n", num_of_pos_rows);
	else
		fprintf(fp, "no_of_inst_with_target_class = %d\n", num_of_rows/gnum_of_classes);
	fprintf(fp, "\n");


	fprintf(fp, "no_of_attr = %d\n", num_of_clmns);
	fprintf(fp, "min_v = %d\n", nmin_v);
	fprintf(fp, "max_v = %d\n", nmax_v);
	fprintf(fp, "\n");

	fprintf(fp, "no_of_rule = %d\n", num_of_rules);
	fprintf(fp, "min_len=%d\n", nmin_len);
	fprintf(fp, "max_len = %d\n", nmax_len);
	fprintf(fp, "min_sup = %d\n", nmin_sup);
	fprintf(fp, "max_sup = %d\n", nmax_sup);
	fprintf(fp, "\n");

	fprintf(fp, "choice = %d\n", nchoice);
	if(nchoice==2)
	{
		fprintf(fp, "min_es = %.3E\n", dmin_es);
		fprintf(fp, "max_es = %.3E\n", dmax_es);
	}
	else
	{
		fprintf(fp, "min_es = %f\n", dmin_es);
		fprintf(fp, "max_es = %f\n", dmax_es);
	}
	fprintf(fp, "\n");
 

	fprintf(fp, "seed_for_attr = 197\n");
	fprintf(fp, "seed_for_values = 2011\n");
	fprintf(fp, "seed_for_select = 981\n");
	fprintf(fp, "\n");

	fclose(fp);

	sprintf(szcmd, ".\\exec\\ARGen  asgen.conf\n");
	printf(szcmd);
	system(szcmd);
}



void LoadAttrValues2ItemMap(char* szattrvalue_filename, map<string, int> *pitem_map)
{
	FILE *fp;
	char ch, szattrvalue[200];
	int nlen, num_of_items;

	fp = fopen(szattrvalue_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szattrvalue_filename);
		return;
	}

	num_of_items = 0;
	ch = fgetc(fp);
	while(!feof(fp))
	{
		nlen = 0;
		while(!feof(fp) && ch!='\n')
		{
			szattrvalue[nlen++] = ch;
			ch = fgetc(fp);
		}
		szattrvalue[nlen] = 0;

		(*pitem_map)[szattrvalue] = num_of_items;
		num_of_items++;

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);
}

int comp_int(const void *e1, const void *e2)
{
	int n1, n2;
	n1 = *(int*) e1;
	n2 = *(int*) e2;

	if (n1>n2)
		return 1;
	else if (n1<n2)
		return -1;
	else
		return 0;
}

void LoadAttrNames(char* sznames_filename, vector<string> *pvec_attr_names)
{
	FILE *fp;
	char ch, szname[100];
	int nlen, nattr_no;

	fp = fopen(sznames_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sznames_filename);
		return ;
	}

	nattr_no = 0;
	ch = fgetc(fp);
	while(!feof(fp))
	{
		nlen = 0;
		while(!feof(fp) && ch!=':' && ch!='\n')
		{
			szname[nlen++] = ch;
			ch = fgetc(fp);
		}
		szname[nlen] = 0;
		if(ch!=':')
			printf("Error: ':' expected\n");
		else
			ch = fgetc(fp);

		if(nlen>0)
			pvec_attr_names->push_back(szname);

		while(!feof(fp) && ch!='\n')
			ch = fgetc(fp);

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);
}

int GetTgtAttrNo(char* sznames_filename, char* sztarget_attr)
{
	FILE *fp;
	char ch, szname[100];
	int nlen, nattr_no, ntarget_attr_no;

	ntarget_attr_no = -1;

	fp = fopen(sznames_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sznames_filename);
		return -1;
	}

	nattr_no = 0;
	ch = fgetc(fp);
	while(!feof(fp))
	{
		nlen = 0;
		while(!feof(fp) && ch!=':' && ch!='\n')
		{
			szname[nlen++] = ch;
			ch = fgetc(fp);
		}
		szname[nlen] = 0;
		if(ch!=':')
			printf("Error: ':' expected\n");
		else
			ch = fgetc(fp);

		if(nlen>0)
		{
			if(strcmp(szname, sztarget_attr)==0)
			{
				ntarget_attr_no = nattr_no;
				break;
			}
			nattr_no++;
		}

		while(!feof(fp) && ch!='\n')
			ch = fgetc(fp);

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);

	return ntarget_attr_no;
}

void ConvertRules(char* szdataset_name, int num_of_attrs, int num_of_rules, char* szoutput_name)
{
	FILE *fp, *fpout;
	char szrule_filename[200], szitem_rule_filename[200], szattrvalue2item_filename[200];
	map<string, int> item_map;
	map<string, int>::iterator map_it;
	char szattrvalue[100];
	int i, j, nvalue, nsup, ntgt_sup, *ppattern, npat_len;
	double dpvalue;

	sprintf(szattrvalue2item_filename, "%s.attrvalue2item.txt", szoutput_name);
	LoadAttrValues2ItemMap(szattrvalue2item_filename, &item_map);

	sprintf(szrule_filename, "%s.rules", szdataset_name);
	fp = fopen(szrule_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szrule_filename);
		return;
	}
	sprintf(szitem_rule_filename, "%s.item.rules", szdataset_name);
	fpout = fopen(szitem_rule_filename, "wt");
	if(fpout==NULL)
	{
		printf("Error: cannot open file %s for write\n", szitem_rule_filename);
		return;
	}

	ppattern = new int[num_of_attrs];

	for(i=0;i<num_of_rules;i++)
	{
		npat_len = 0;		
		for(j=0;j<num_of_attrs;j++)
		{
			fscanf(fp, "%d", &nvalue);
			if(j>0 && nvalue>=0)
			{
				sprintf(szattrvalue, "attribute_%d=%d", j, nvalue);
				map_it = item_map.find(szattrvalue);
				if(map_it==item_map.end())
					printf("Error: cannot find attribute value %s in the map\n", szattrvalue);
				else
					ppattern[npat_len++] = map_it->second;
			}
		}
		qsort(ppattern, npat_len, sizeof(int), comp_int);
		fprintf(fpout, "%d ", npat_len);
		for(j=0;j<npat_len;j++)
			fprintf(fpout, "%d ", ppattern[j]);
		fscanf(fp, "%d", &nsup);
		fscanf(fp, "%d", &ntgt_sup);
		fscanf(fp, "%lf", &dpvalue);

		fprintf(fpout, "%d %d %E\n", nsup, ntgt_sup, dpvalue);
	}
	fclose(fp);
	fclose(fpout);

	delete []ppattern;
}

int LoadTrueRules(char* szdataset_name, ASSOCRULE *&prules, int *&pitemset_buf, int *&ptidlist_buf, int &nmax_rule_len)
{
	char szrule_filename[200], sztidlist_filename[200];
	FILE *fp;
	int npat_len, nitem, nsup, ntgt_sup, i, j;
	double dpvalue;
	int num_of_rules, npat_buf_size, npat_buf_pos, ntidlist_buf_size, ntidlist_buf_pos;

	sprintf(szrule_filename, "%s.item.rules", szdataset_name);
	fp = fopen(szrule_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szrule_filename);
		return 0;
	}

	num_of_rules = 0;
	npat_buf_size = 0;
	ntidlist_buf_size = 0;
	nmax_rule_len = 0;

	fscanf(fp, "%d", &npat_len);
	while(!feof(fp))
	{
		if(nmax_rule_len<npat_len)
			nmax_rule_len = npat_len;

		for(i=0;i<npat_len;i++)
			fscanf(fp, "%d", &nitem);
		fscanf(fp, "%d", &nsup);
		fscanf(fp, "%d", &ntgt_sup);

		fscanf(fp, "%lf", &dpvalue);

		num_of_rules++;
		npat_buf_size += npat_len;
		ntidlist_buf_size += nsup;

		fscanf(fp, "%d", &npat_len);
	}
	rewind(fp);

	prules = new ASSOCRULE[num_of_rules];
	pitemset_buf = new int[npat_buf_size];
	ptidlist_buf = new int[ntidlist_buf_size];
	num_of_rules = 0;

	npat_buf_pos = 0;
	ntidlist_buf_pos = 0;
	fscanf(fp, "%d", &npat_len);
	while(!feof(fp))
	{
		prules[num_of_rules].npat_len = npat_len;
		prules[num_of_rules].pattern = &pitemset_buf[npat_buf_pos];
		npat_buf_pos += prules[num_of_rules].npat_len;
		for(i=0;i<prules[num_of_rules].npat_len;i++)
			fscanf(fp, "%d", &prules[num_of_rules].pattern[i]);

		fscanf(fp, "%d", &prules[num_of_rules].nsup);
		fscanf(fp, "%d", &prules[num_of_rules].ntgt_sup);
		prules[num_of_rules].ptid_list = &ptidlist_buf[ntidlist_buf_pos];
		ntidlist_buf_pos += nsup;

		fscanf(fp, "%lf", &prules[num_of_rules].dpvalue);
		num_of_rules++;

		fscanf(fp, "%d", &npat_len);
	}
	fclose(fp);

	if(npat_buf_pos!=npat_buf_size)
		printf("Error: inconsistent pattern buffer size\n");
	if(ntidlist_buf_pos!=ntidlist_buf_size)
		printf("Error: inconsistent tid list buffer size\n");

	//load tid-list
	sprintf(sztidlist_filename, "%s.tid", szdataset_name);
	fp = fopen(sztidlist_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", sztidlist_filename);
		return 0;
	}

	for(i=0;i<num_of_rules;i++)
	{
		fscanf(fp, "%d", &nsup);
		if(nsup!=prules[i].nsup)
			printf("Error: inconsistent support\n");
		for(j=0;j<nsup;j++)
			fscanf(fp, "%d", &prules[i].ptid_list[j]);
		qsort(prules[i].ptid_list, nsup, sizeof(int), comp_int);
	}

	fclose(fp);

	return num_of_rules;
}


