#include <math.h>

#include "global.h"

void GetDatasetName(char* szfull_name, char* szdataset_name)
{
	int i, nlen, k;

	nlen = (int)strlen(szfull_name);
	i = nlen-1;
	while(i>=0 && szfull_name[i]!='\\' && szfull_name[i]!='/')
		i--;
	i++;
	k = 0;
	while(i<nlen && szfull_name[i]!='.')
		szdataset_name[k++] = szfull_name[i++];
	szdataset_name[k] = 0;
}

void SplitDatasets(char* szfilename, char* szoutput_suffix)
{
	FILE *fp, *fpout;
	char szoutput_filename[200];
	char ch, szstr[100], szprev_data_filename[200], szdata_filename[200], szdataset_name[200];
	int nlen;

	fp = fopen(szfilename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szfilename);
		return;
	}

	szprev_data_filename[0] = 0;

	ch = fgetc(fp);
	while(!feof(fp))
	{
		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szstr[nlen++] = ch;
			ch = fgetc(fp);
		}
		szstr[nlen] = 0;

		while(!feof(fp) && (ch==' ' || ch=='\t'))
			ch = fgetc(fp);

		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szdata_filename[nlen++] = ch;
			ch = fgetc(fp);
		}
		szdata_filename[nlen] = 0;

		if(strcmp(szdata_filename, szprev_data_filename))
		{
			if(szprev_data_filename[0]!=0)
				fclose(fpout);

			GetDatasetName(szdata_filename, szdataset_name);
			sprintf(szoutput_filename, "%s%s", szdataset_name, szoutput_suffix);
			fpout = fopen(szoutput_filename, "wt");
			if(fpout==NULL)
			{
				printf("Error: cannot open file %s for write\n", szoutput_filename);
				return;
			}
			strcpy(szprev_data_filename, szdata_filename);
		}

		fprintf(fpout, "%s %s\t", szstr, szdataset_name);

		while(!feof(fp) && ch!='\n')
		{
			ch = fgetc(fp);
			if(ch!='\r' && ch!='\n')
				fprintf(fpout, "%c", ch);
		}
		fprintf(fpout, "\n");

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);
	fclose(fpout);
}

void SplitDatasetNPara(char* szfilename, char* szoutput_suffix)
{
	FILE *fp, *fpout;
	char szoutput_filename[200];
	char ch, szstr[100], szdata_filename[200], szdataset_name[200];
	char szbuf_size[10], szdiff_list_flag[100], szprev_diff_list_flag[100];
	int nlen;

	fp = fopen(szfilename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szfilename);
		return;
	}

	szprev_diff_list_flag[0] = 0;

	ch = fgetc(fp);
	while(!feof(fp))
	{
		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szstr[nlen++] = ch;
			ch = fgetc(fp);
		}
		szstr[nlen] = 0;

		//dataset name
		while(!feof(fp) && (ch==' ' || ch=='\t'))
			ch = fgetc(fp);
		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szdata_filename[nlen++] = ch;
			ch = fgetc(fp);
		}
		szdata_filename[nlen] = 0;

		//buf size
		while(!feof(fp) && (ch==' ' || ch=='\t'))
			ch = fgetc(fp);
		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szbuf_size[nlen++] = ch;
			ch = fgetc(fp);
		}
		szbuf_size[nlen] = 0;


		//diff list flag
		while(!feof(fp) && (ch==' ' || ch=='\t'))
			ch = fgetc(fp);
		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szdiff_list_flag[nlen++] = ch;
			ch = fgetc(fp);
		}
		szdiff_list_flag[nlen] = 0;


		if(strcmp(szdiff_list_flag, szprev_diff_list_flag))
		{
			if(szprev_diff_list_flag[0]!=0)
				fclose(fpout);

			GetDatasetName(szdata_filename, szdataset_name);
			if(strcmp(szdiff_list_flag, "perm_diff_list=yes")==0)
				sprintf(szoutput_filename, "%s-%s-diff%s", szdataset_name, szbuf_size,  szoutput_suffix);
			else
				sprintf(szoutput_filename, "%s-%s-full%s", szdataset_name, szbuf_size,  szoutput_suffix);
			fpout = fopen(szoutput_filename, "wt");
			if(fpout==NULL)
			{
				printf("Error: cannot open file %s for write\n", szoutput_filename);
				return;
			}
			strcpy(szprev_diff_list_flag, szdiff_list_flag);
		}

		fprintf(fpout, "%s %s %s %s\t", szstr, szdataset_name, szbuf_size, szdiff_list_flag);

		while(!feof(fp) && ch!='\n')
		{
			ch = fgetc(fp);
			if(ch!='\r' && ch!='\n')
				fprintf(fpout, "%c", ch);
		}
		fprintf(fpout, "\n");

		if(ch=='\n')
			ch = fgetc(fp);
	}
	fclose(fp);
	fclose(fpout);
}

void SplitDatasets(char* szfilename, int nrow_sep_num, char* szoutput_prefix, char* szoutput_suffix)
{
	FILE *fp, *fpout;
	char szoutput_filename[200];
	char ch;
	int nrow_no, nconf;

	fp = fopen(szfilename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szfilename);
		return;
	}

	nrow_no = 0;
	nconf = 55;

	fpout = NULL;

	ch = fgetc(fp);
	while(!feof(fp))
	{
		sprintf(szoutput_filename, "%sC%d%s", szoutput_prefix, nconf, szoutput_suffix);
		fpout = fopen(szoutput_filename, "wt");
		if(fpout==NULL)
		{
			printf("Error: cannot open file %s for write\n", szoutput_filename);
			return;
		}

		while(!feof(fp) && nrow_no<nrow_sep_num)
		{
			while(!feof(fp) && ch!='\n')
			{
				fprintf(fpout, "%c", ch);
				ch = fgetc(fp);
			}
			fprintf(fpout, "\n");
			nrow_no++;

			if(ch=='\n')
				ch = fgetc(fp);
		}
		if(nrow_no>0)
		{
			fclose(fpout);
			nrow_no = 0;
			fpout = NULL;
			nconf += 5;
		}
	}
	fclose(fp);
	if(fpout)
		fclose(fpout);
}


void GetAvg(char* szfilename, int ngroup_clmn_no, int num_of_avg_clmns, char* szoutput_filename)
{
	FILE *fp, *fpout;
	char ch, szstr[100], szgroup_clmn[100], szprev_group_clmn[100];
	int i, nlen, num_of_rows, num=4;
	double *pavgs, *pstddevs, d;

	fp = fopen(szfilename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szfilename);
		return;
	}
	fpout = fopen(szoutput_filename, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szfilename);
		return;
	}

	szprev_group_clmn[0] = 0;
	num_of_rows = 0;

	pavgs = new double[num_of_avg_clmns];
	pstddevs = new double[num_of_avg_clmns];
	for(i=0;i<num_of_avg_clmns;i++)
	{
		pavgs[i] = 0;
		pstddevs[i] = 0;
	}

	ch = fgetc(fp);
	while(!feof(fp))
	{

		for(i=1;i<ngroup_clmn_no;i++)
		{
			nlen = 0;
			while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
			{
				szstr[nlen++] = ch;
				ch = fgetc(fp);
			}
			szstr[nlen] = 0;
			while(!feof(fp) && (ch==' ' || ch=='\t'))
				ch = fgetc(fp);
		}

		nlen = 0;
		while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
		{
			szgroup_clmn[nlen++] = ch;
			ch = fgetc(fp);
		}
		szgroup_clmn[nlen] = 0;
		while(!feof(fp) && (ch==' ' || ch=='\t'))
			ch = fgetc(fp);

		if(strcmp(szgroup_clmn, szprev_group_clmn))
		{
			if(num_of_rows>0)
			{
				fprintf(fpout, "%s\t", szprev_group_clmn);
				i = 0;
				while(i<num)
				{
					fprintf(fpout, "%.2f ", pavgs[i]/num_of_rows);
					pavgs[i] = 0;
					i++;
				}
				while(i<num+5)
				{
					fprintf(fpout, "%.3E ", pavgs[i]/num_of_rows);
					pavgs[i] = 0;
					i++;
				}
				while(i<num_of_avg_clmns)
				{
					fprintf(fpout, "%.3f ", pavgs[i]/num_of_rows);
					pavgs[i] = 0;
					i++;
				}
				fprintf(fpout, "\n");
			}
			strcpy(szprev_group_clmn, szgroup_clmn);
			num_of_rows = 0;
		}

		for(i=0;i<num_of_avg_clmns;i++)
		{
			nlen = 0;
			while(!feof(fp) && ch!=' ' && ch!='\t' && ch!='\n')
			{
				szstr[nlen++] = ch;
				ch = fgetc(fp);
			}
			szstr[nlen] = 0;
			while(!feof(fp) && (ch==' ' || ch=='\t'))
				ch = fgetc(fp);

			d = atof(szstr);
			pavgs[i] += d;
			pstddevs[i] += d*d;
		}
		num_of_rows++;

		if(!feof(fp) && ch=='\n')
			ch = fgetc(fp);
	}
	if(num_of_rows>0)
	{
		fprintf(fpout, "%s\t", szprev_group_clmn);
		i = 0;
		while(i<num)
		{
			fprintf(fpout, "%.2f ", pavgs[i]/num_of_rows);
			pavgs[i] = 0;
			i++;
		}
		while(i<num+5)
		{
			fprintf(fpout, "%.3E ", pavgs[i]/num_of_rows);
			pavgs[i] = 0;
			i++;
		}
		while(i<num_of_avg_clmns)
		{
			fprintf(fpout, "%.3f ", pavgs[i]/num_of_rows);
			pavgs[i] = 0;
			i++;
		}
		fprintf(fpout, "\n");
	}
	

	delete []pavgs;
	delete []pstddevs;


	fclose(fp);
	fclose(fpout);
}

void SortPValue(char* szpvalue_filename, char* szoutput_filename)
{
	FILE *fp, *fpout;
	int npreorder, nsup, ntgt_sup, num_of_rows, i;
	double dpvalue, *pdpvalues, doutput_thres, dconf;

	fp = fopen(szpvalue_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szpvalue_filename);
		return;
	}
	fpout = fopen(szoutput_filename, "wt");
	if(fpout==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	num_of_rows = 0;
	fscanf(fp, "%d", &npreorder);
	while(!feof(fp))
	{
		fscanf(fp, "%d", &nsup);
		fscanf(fp, "%d", &ntgt_sup);

		fscanf(fp, "%lf", &dconf);
		fscanf(fp, "%lf", &dpvalue);
		num_of_rows++;

		fscanf(fp, "%d", &npreorder);
	}
	rewind(fp);

	pdpvalues = new double[num_of_rows];

	num_of_rows = 0;
	fscanf(fp, "%d", &npreorder);
	while(!feof(fp))
	{
		fscanf(fp, "%d", &nsup);
		fscanf(fp, "%d", &ntgt_sup);

		fscanf(fp, "%lf", &dconf);

		fscanf(fp, "%lf", &dpvalue);
		pdpvalues[num_of_rows] = dpvalue;

		num_of_rows++;

		fscanf(fp, "%d", &npreorder);
	}
	fclose(fp);

	qsort(pdpvalues, num_of_rows, sizeof(double), comp_double);

	doutput_thres = 1.0E-20;
	while(pdpvalues[0]>doutput_thres*10)
		doutput_thres *= 10;
	for(i=0;i<num_of_rows;i++)
	{
		if(pdpvalues[i]>doutput_thres && (i==0 || pdpvalues[i-1]<doutput_thres))
		{
			fprintf(fpout, "%.3E %d %.3f\n", pdpvalues[i], i+1, (double)(i+1)/num_of_rows);
			doutput_thres *= 10;
			while(pdpvalues[i]>doutput_thres)
				doutput_thres *= 10;
		}
	}
	fprintf(fpout, "%.3E %d %.3f\n", pdpvalues[num_of_rows-1], num_of_rows, (double)1);
	fclose(fpout);

	delete []pdpvalues;
}


void CalcConfPvalueMatrix(char* szpvalue_filename, double dstart_conf, double dconf_interval, double dpvalue_interval, char* szoutput_filename)
{
	FILE *fp, *fpout;
	int npreorder, nsup, ntgt_sup, nconf_clmn_num, npvalue_row_num;
	double dconf, dpvalue, dmax_pvalue_power, dpvalue_bound;
	int *pconf_clmn_counts, *ppvalue_row_counts, *pconf_pvalue_matrix, nclmn_pos, nrow_pos, num_of_rows;
	int i, j;

	fp = fopen(szpvalue_filename, "rt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for read\n", szpvalue_filename);
		return;
	}
	fpout = fopen(szoutput_filename, "wt");
	if(fpout==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_filename);
		return;
	}

	nconf_clmn_num = (int)((1-dstart_conf)/dconf_interval)+1;
	if(dstart_conf>0)
		nconf_clmn_num++;
	dmax_pvalue_power = 10;
	dpvalue_bound = pow(0.1, dmax_pvalue_power);
	npvalue_row_num = (int)(dmax_pvalue_power/dpvalue_interval)+1;

	pconf_clmn_counts = new int[nconf_clmn_num];
	memset(pconf_clmn_counts, 0, sizeof(int)*nconf_clmn_num);

	ppvalue_row_counts = new int[npvalue_row_num];
	memset(ppvalue_row_counts, 0, sizeof(int)*npvalue_row_num);

	pconf_pvalue_matrix = new int[npvalue_row_num*nconf_clmn_num];
	memset(pconf_pvalue_matrix, 0, sizeof(int)*npvalue_row_num*nconf_clmn_num);

	num_of_rows = 0;

	fscanf(fp, "%d", &npreorder);
	while(!feof(fp))
	{
		fscanf(fp, "%d", &nsup);
		fscanf(fp, "%d", &ntgt_sup);
		fscanf(fp, "%lf", &dconf);
		fscanf(fp, "%lf", &dpvalue);

		if(dconf<dstart_conf)
			nclmn_pos = 0;
		else
		{
			nclmn_pos = (int)((dconf-dstart_conf)/dconf_interval);
			if(dstart_conf>0)
				nclmn_pos++;
		}
		if(dpvalue>0.05)
			nrow_pos = 0;
		else if(dpvalue>0.01)
			nrow_pos = 1;
		else if(dpvalue<=dpvalue_bound)
			nrow_pos = npvalue_row_num-1;
		else
			nrow_pos = (int)(-log10(dpvalue)/dpvalue_interval);

		pconf_clmn_counts[nclmn_pos]++;
		ppvalue_row_counts[nrow_pos]++;
		pconf_pvalue_matrix[nrow_pos*nconf_clmn_num+nclmn_pos]++;
		num_of_rows++;

		fscanf(fp, "%d", &npreorder);
	}
	fclose(fp);

	fprintf(fpout, "%11s ", " ");
	if(dstart_conf>0)
	{
		fprintf(fpout, "   <%.2f ", dstart_conf);
		for(i=1;i<nconf_clmn_num;i++)
			fprintf(fpout, "%8.2f ", (i-1)*dconf_interval+dstart_conf);
	}
	else
	{
		for(i=0;i<nconf_clmn_num;i++)
			fprintf(fpout, "%8.2f ", i*dconf_interval);
	}
	fprintf(fpout, "\n");
	for(i=0;i<npvalue_row_num;i++)
	{
		if(i==0)
			fprintf(fpout, "      >%.2f ",  0.05);
		else if(i==1)
			fprintf(fpout, "       %.2f ",  0.05);
		else if(i==npvalue_row_num-1)
			fprintf(fpout, "<=%9.2E ", dpvalue_bound);
		else
			fprintf(fpout, "%11.2E ", pow(0.1, i));

		for(j=0;j<nconf_clmn_num;j++)
			fprintf(fpout, "%8d ", pconf_pvalue_matrix[i*nconf_clmn_num+j]);
		fprintf(fpout, "%8d\n", ppvalue_row_counts[i]);
	}
	fprintf(fpout, "%11s ", " ");
	for(i=0;i<nconf_clmn_num;i++)
		fprintf(fpout, "%8d ", pconf_clmn_counts[i]);
	fprintf(fpout, "%8d ", num_of_rows);

	delete []pconf_clmn_counts;
	delete []ppvalue_row_counts;
	delete []pconf_pvalue_matrix;
}

