#include <math.h>

#include "global.h"

double *gpdfactorials;

void InitFactorials(double *pdfactorials, int n)
{
	int i;

	pdfactorials[0] = 0;
	pdfactorials[1] = 0;

	for(i=2;i<=n;i++)
		pdfactorials[i] = pdfactorials[i-1]+log10((double)i);
}

double HyperGeometric(int n, int x, int y, int k)
{
	double dpvalue;

	dpvalue = gpdfactorials[x]+gpdfactorials[y]+gpdfactorials[n-x]+gpdfactorials[n-y];
	dpvalue -= (gpdfactorials[n]+gpdfactorials[k]+gpdfactorials[x-k]+gpdfactorials[y-k]+gpdfactorials[n-x-y+k]);

	dpvalue = pow(10, dpvalue);

	return dpvalue;
}


double CalcFisherPvalue(int n, int x, int y, int k)
{
	int i;
	double dpvalue;

	//if(k<x+y-n || x>n || y>n || x<k || y<k)
	//	printf("Error: k cannot be smaller than %d\n", x+y-n);

	dpvalue = 0;

	for(i=k;i<=x && i<=y;i++)
		dpvalue += HyperGeometric(n, x, y, i);

	return dpvalue;
}

double CalcTwoTailedFisherPvalue(int n, int x, int y, int k)
{
	int i;
	double dorig_pvalue, dpvalue_sum, dpvalue;

	if(k>x)
		k = x;
	if(k>y)
		k = y;

	dorig_pvalue = HyperGeometric(n, x, y, k);
	dpvalue_sum = dorig_pvalue;

	i = y-(n-x);
	if(i<0)
		i = 0;
	while(i<k)
	{
		dpvalue = HyperGeometric(n, x, y, i);
		if(dpvalue<=dorig_pvalue)
			dpvalue_sum += dpvalue;
		else 
			break;
		i++;
	}
	i = x;
	if(i>y)
		i = y;
	while(i>k)
	{
		dpvalue = HyperGeometric(n, x, y, i);
		if(dpvalue<=dorig_pvalue)
			dpvalue_sum += dpvalue;
		else 
			break;
		i--;
	}

	return dpvalue_sum;
}


void GenPvalue(int n, int y, int num_of_classes)
{
	FILE *fp;
	char szoutput_name[200];
	double dconf, dpvalue, dHvalue, dinterval;
	int i, x, k, ninterval_num;

	x = n/num_of_classes;
	dinterval = 0.01;
	ninterval_num = (int)((double)(num_of_classes-1)/num_of_classes/dinterval)+1;

	sprintf(szoutput_name, "%d_%d_%d.pvalues.txt", n, x, y);
	fp = fopen(szoutput_name, "wt");
	if(fp==NULL)
	{
		printf("Error: cannot open file %s for write\n", szoutput_name);
		return;
	}

	gpdfactorials = new double[n+1];
	InitFactorials(gpdfactorials, n);

	if(y<=ninterval_num)
	{
		i = (x+y-n);
		if(i<0)
			i = 0;
		while(i<=x && i<=y)
		{
			dHvalue = HyperGeometric(n, x, y, i);
			dpvalue = CalcTwoTailedFisherPvalue(n, x, y, i);
			fprintf(fp, "%d %d %d %d %.4E %.4E\n", n, x, y, i, dpvalue, dHvalue);
			i++;
		}
	}
	else
	{
		for(i=0;i<ninterval_num;i++)
		{
			dconf = 1/(double)num_of_classes+i*dinterval;
			k = (int)(y*dconf);
			dpvalue = CalcTwoTailedFisherPvalue(n, x, y, k);

			fprintf(fp, "%d %d %d %.3f %.4E\n", n, x, y, dconf, dpvalue);
		}
	}

	delete []gpdfactorials;

	fclose(fp);
}

