//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//
// Candidate - Wrapper to obtain candidate erroneous bases 
// It's developed based on SGA originally writen by Jared Simpson (js18@sanger.ac.uk)
//

#include "CandidateProcess.h"
#include "HashMap.h"
#include "KmerOverlaps.h"
#include "Mask.h"

//
//
//
CandidateProcess::CandidateProcess(const CandidateParameters params) : m_params(params)  
{
    m_params.depthFilter = 10000;
}

//
CandidateProcess::~CandidateProcess()
{

}

//
CandidateResult CandidateProcess::process(const SequenceWorkItem& workItem)
{
    size_t lz_flag = Mask::getCell(workItem.idx);
    if (lz_flag)
    {
        CandidateResult result;
        return result;
    }
    CandidateResult result = correct(workItem);
    return result;
}
    
CandidateResult CandidateProcess::correct(const SequenceWorkItem& workItem)
{
    return overlapCorrectionNew(workItem);
}

//
CandidateResult CandidateProcess::overlapCorrectionNew(const SequenceWorkItem& workItem)
{
    assert(m_params.indices.pBWT != NULL);
    assert(m_params.indices.pSSA != NULL);

    SeqRecord currRead = workItem.read;

    CandidateResult result= KmerOverlaps::buildMultipleAlignment(workItem.idx, m_params.depthFilter, currRead.seq.toString(),
                                                                                m_params.kmerLength,
                                                                                m_params.minOverlap,
                                                                                m_params.minIdentity,
                                                                                7,
                                                                                m_params.indices);
    if (result.lz_indices.size() > 0)
    {
        V_UI64::iterator itr;
        for (itr = result.lz_indices.begin(); itr != result.lz_indices.end(); ++itr)
        {
            Mask::setCell(*itr); 
        }
    }
    return result;
}


//
CandidatePostProcess::CandidatePostProcess(std::ostream* pCorrectedWriter)
         :m_pCorrectedWriter(pCorrectedWriter)
{

}

//
void CandidatePostProcess::process(CandidateResult& result)
{
    result.write(*m_pCorrectedWriter);
}

