//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//
// Candidate - Wrapper to obtain candidate erroneous bases 
// It's developed based on SGA originally writen by Jared Simpson (js18@sanger.ac.uk)
//

#ifndef CORRECTPROCESS_H
#define CORRECTPROCESS_H

#include "Util.h"
#include "SequenceProcessFramework.h"
#include "SequenceWorkItem.h"
#include "BWTIndexSet.h"
#include "SampledSuffixArray.h"
#include "KmerOverlaps.h" 
#include "gzstream.h"

enum CandidateAlgorithm
{
    ECA_OVERLAP 
};

enum ECFlag
{
    ECF_NOTCORRECTED,
    ECF_CORRECTED,
    ECF_AMBIGIOUS,
    ECF_DUPLICATE
};

// Parameter object for the error corrector
struct CandidateParameters
{
    CandidateAlgorithm algorithm;

    //
    BWTIndexSet indices;

    int minOverlap;
    int numOverlapRounds;
    double minIdentity;
    int conflictCutoff;
    int depthFilter;

    int numKmerRounds;
    int kmerLength;

    bool printOverlaps;
};

typedef MultipleAlignment CandidateResult;

//
class CandidateProcess
{
    public:
        CandidateProcess(const CandidateParameters params); 
        ~CandidateProcess();

        CandidateResult process(const SequenceWorkItem& item);
        CandidateResult correct(const SequenceWorkItem& item);

        CandidateResult overlapCorrectionNew(const SequenceWorkItem& workItem);
    
    private:
        CandidateParameters m_params;
};

class CandidatePostProcess
{
   public:
       CandidatePostProcess(std::ostream* pCorrectedWriter); 
       void process(CandidateResult& result);

   private:
       std::ostream* m_pCorrectedWriter;
};

#endif
