//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//
#ifndef ERRORCORRECT_H
#define ERRORCORRECT_H

#include <map>
#include <vector>
#include <cstdint>
#include <string>

namespace ErrorCorrect
{
    static std::map<char, uint8_t> Base2Bits = {{'A', 0}, {'C', 1}, {'G', 2}, {'T', 3}};
    static std::map<uint8_t, char> Bits2Base = {{0, 'A'}, {1, 'C'}, {2, 'G'}, {3, 'T'}};
    static const size_t glz_READLENBIT = 9;
    static const size_t glz_READFLAG = 1;
};

class Corrector
{
public:
    Corrector(std::string readsFile, 
              std::string candidateFile, 
              size_t bufferSize, 
              size_t numThreads, 
              std::string outFormat, 
              std::string readsDim, 
              double logRatio, 
              std::string outputFile, 
              double e,
              size_t maxFreq);
    void importReads();
    void correct();
    void postprocess();

private:
    std::string m_inputReadsFile;
    std::string m_erroneousBasesFile;
    size_t m_bufferSize;
    size_t m_numThreads;
    std::string m_outFormat;
    std::string m_readsDim;
    double m_rtThreshold;
    std::string m_outputReadsFile;
    std::vector<uint8_t*> m_reads;
    size_t m_numReads;
    size_t m_readLen;
    double m_E;
    size_t m_maxFreq;

    void combineErrorneousBases();
    void string2bits(std::string seq, uint8_t *pbits);
    void correctError(std::vector<uint64_t>* pcandidateBases);
    void correctError(std::string line);
    char retrieveBase(uint64_t index);
    std::string toString(uint8_t *pbits, size_t n);
    void getReadsDimension();
    void learnRatio(size_t n);
};

#endif
