//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//

#include "ExtendAlignment.h"
#include <vector>

SequenceOverlap::SequenceOverlap():score(0), overlap(0), start(0) {}

//
int SequenceOverlap::getOverlapLength()
{
    return overlap;
}

//
double SequenceOverlap::getPercentIdentity()
{
    return score;
}

SequenceOverlap ExtendAlignment::ExtendAlign(const std::string& s1, const std::string& s2, int start1, int start2, int bandWidth, int penalty)
{
    SequenceOverlap output;
    int n1 = s1.length();
    int n2 = s2.length();
    int overlap = 0;
    int mismatch = 0;
    int i, j;
    i = start1;
    j = start2;
    while((i >=0) && (j >= 0))
    {
        if (s1[i] != s2[j]) 
            ++mismatch;
        if (mismatch > bandWidth) return output;
        ++overlap;
        --i;
        --j;
    }
    i = start1 + 1;
    j = start2 + 1;
    while((i < n1) && (j < n2))
    {
        if (s1[i] != s2[j])
            ++mismatch;
        if (mismatch > bandWidth) return output;
        ++overlap;
        ++i;
        ++j;
    }
    if (overlap > 0)
    {
        output.score = double(overlap - mismatch - penalty) / overlap;
        output.overlap = overlap;
        output.start = start2 - start1; 
    }
    return output;
}

SequenceOverlap ExtendAlignment::BandAlign(const std::string& s1, const std::string& s2, int bandWidth, int penalty, int minOverlap)
{
    typedef std::vector<SequenceOverlap> VSO;
    VSO outputs;
    int n1 = s1.length();
    int n2 = s2.length();
    int start1 = 0;
    int start2 = n2 - minOverlap;
    int tmpPenalty = 0;
    while (start2 >= 0) 
    {
        tmpPenalty = (penalty + start2) / AVG_REPEAT_LEN;
        SequenceOverlap result = ExtendAlign(s1, s2, start1, start2, bandWidth, tmpPenalty);
        if (result.score > 0)
            outputs.push_back(result);
        -- start2;
    }
    start2 = 0;
    start1 = n1 - minOverlap;
    while (start1 >= 0)
    {
        tmpPenalty = (penalty - start1) / AVG_REPEAT_LEN;
        SequenceOverlap result = ExtendAlign(s1, s2, start1, start2, bandWidth, tmpPenalty);
        if (result.score > 0)
        {
            result.start = - result.start;
            outputs.push_back(result);
        }
        -- start1;
    }

    double maxScore = 0;
    SequenceOverlap output;
    VSO::iterator itr;
    for (itr = outputs.begin(); itr != outputs.end(); ++itr)
    {
        if (itr->score > maxScore)
        {
            output.score = itr->score;
            output.overlap = itr->overlap;
            output.start = itr->start;
            maxScore = itr->score;
        }
    }
    return output;
}
