//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//

#ifndef EXTEND_ALIGNMENT_H
#define EXTEND_ALIGNMENT_H

#include <string>
#include <stdint.h>

struct SequenceOverlap {
    SequenceOverlap();
    double score;
    int overlap;
    int start; 
    int getOverlapLength();
    double getPercentIdentity();
};

namespace ExtendAlignment {
    SequenceOverlap ExtendAlign(const std::string& s1, const std::string& s2, int start1, int start2, int bandWidth, int penalty = 0);
    SequenceOverlap BandAlign(const std::string& s1, const std::string& s2, int bandWidth, int penalty, int minOverlap);
    static const size_t AVG_REPEAT_LEN = 7;
}

#endif
