//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//
// KmerOverlaps - Overlap computation functions, seeded by exact kmer matches
// It's developed based on SGA originally writen by Jared Simpson (js18@sanger.ac.uk)
//

#ifndef KMER_OVERLAPS_H
#define KMER_OVERLAPS_H

#include "BWTIndexSet.h"
#include "SampledSuffixArray.h"
#include <cmath> 
#include "ExtendAlignment.h" 
#include "gzstream.h"

// A pair of sequences and an overlap matching them
struct SequenceOverlapPair
{
    std::string sequence[2];
    int match_idx;
    bool is_reversed;
    SequenceOverlap overlap; 

    static bool sortByOverlapLengthDesc(const SequenceOverlapPair& a, const SequenceOverlapPair& b) 
    { 
        return abs(a.overlap.start) < abs(b.overlap.start); 
    } // absolute value smaller the overlap larger

};
typedef std::vector<SequenceOverlapPair> SequenceOverlapPairVector;

typedef std::vector<uint64_t> V_UI64;
typedef std::vector<V_UI64> VV_UI64;

struct MultipleAlignment {
    VV_UI64 lz_candidate;
    V_UI64 lz_indices;
    void getCandidate(SequenceOverlapPairVector sopv, size_t lz_baseIndex);
    void write(std::ostream& out);
    uint64_t encode(size_t index, size_t position, bool isReverse);
};

namespace KmerOverlaps
{

MultipleAlignment buildMultipleAlignment(size_t lz_index, int depthFilter, const std::string& query, 
                                         size_t k,
                                         int min_overlap,
                                         double min_identity,
                                         int bandwidth,
                                         const BWTIndexSet& indices);

SequenceOverlapPairVector retrieveMatches(const std::string& query, 
                                          size_t k,
                                          int min_overlap,
                                          double min_identity,
                                          int bandwidth,
                                          const BWTIndexSet& indices);

};

#endif
