//-----------------------------------------------
// Copyright 2016 Guangxi University
// Written by Liang Zhao(S080011@e.ntu.edu.sg)
// Released under the GPL
//-----------------------------------------------
//
// mec - Main driver program
// It's developed based on SGA, originally writen by Jared Simpson (js18@sanger.ac.uk)
//
#include <string>
#include <iostream>
#include "preprocess.h"
#include "candidate.h"
#include "index.h" 
#include "correct.h"

#define PROGRAM_BIN "mec"
#define AUTHOR "Liang Zhao"

static const char *MEC_VERSION_MESSAGE =
"mec version " PACKAGE_VERSION "\n";

static const char *MEC_USAGE_MESSAGE =
"Program: " PACKAGE_NAME "\n"
"Version: " PACKAGE_VERSION "\n"
"Contact: " AUTHOR " [" PACKAGE_BUGREPORT "]\n"
"Usage: " PROGRAM_BIN " <command> [options]\n\n"
"Commands:\n"
"    preprocess      filter and quality-trim reads\n"
"    index           build the BWT and FM-index for a set of reads\n"
"    candidate       obtain the candidate erroneous bases of reads\n"
"    correct         correct sequencing errors in a set of reads\n"
"    help            print out the help message\n"
"    version         print out the version message\n"
"\nReport bugs to " PACKAGE_BUGREPORT "\n\n";

int main(int argc, char** argv)
{
    if(argc <= 1)
    {
        std::cout << MEC_USAGE_MESSAGE;
        return 0;
    }
    else
    {
        std::string command(argv[1]);
        if(command == "help" || command == "--help")
        {
            std::cout << MEC_USAGE_MESSAGE;
            return 0;
        }
        else if(command == "version" || command == "--version")
        {
            std::cout << MEC_VERSION_MESSAGE;
            return 0;
        }
        else if(command == "preprocess")
            preprocessMain(argc - 1, argv + 1);
        else if(command == "index") 
            indexMain(argc - 1, argv + 1);
        else if (command == "candidate")
            candidateMain(argc - 1, argv + 1);
        else if(command == "correct")
            correctMain(argc - 1, argv + 1);
        else
        {
            std::cerr << "Unrecognized command: " << command << "\n";
            return 1;
        }
    }

    return 0;
}
