#include "Mask.h"
#include <string>
#include <iostream>
#include <fstream>

uint32_t* glz_pReadMask = 0;

//@--START lzhao--
//
void Mask::initReadsMask(std::string readsFileDim)
{
    //std::cout << "C1" << std::endl;
    int lz_numReads;
    int lz_readLength;
    std::ifstream fi;
    fi.open(readsFileDim.c_str());
    //std::cout << readsFileDim << "\t" << glz_pReadMask << std::endl;
    fi >> lz_numReads >> lz_readLength;
    fi.close();
    int lz_bytes = (lz_numReads * lz_readLength + 31)/32;
    glz_pReadMask = new uint32_t[lz_bytes];
    for (int i = 0; i < lz_bytes; ++i) glz_pReadMask[i] = 0;
    //std::cout << "C2" << "\t" << glz_pReadMask << std::endl;
}

//
void Mask::cleanReadsMask()
{
    if (glz_pReadMask != 0)
    {
        delete [] glz_pReadMask;
        glz_pReadMask = 0;
    }
    glz_pReadMask = 0;
}

//
size_t Mask::getCell(size_t index)
{
    size_t lz_byteIdx = index / 32;
    size_t lz_bitIdx = index % 32;
    size_t lz_flag = (glz_pReadMask[lz_byteIdx] >> (32 - (lz_bitIdx + 1))) & 0x1;
    return lz_flag;
}

//
void Mask::setCell(size_t index)
{
    size_t lz_byteIdx = 0;
    size_t lz_bitIdx = 0;
    lz_byteIdx = index / 32;
    lz_bitIdx = index % 32;
    glz_pReadMask[lz_byteIdx] |= (0x1 << (31 - lz_bitIdx));
}
//@--END lzhao--

