/*
 * Decompiled with CFR 0.152.
 */
package proteomics;

import dbmodel.DBFile;
import dbmodel.DBFile$;
import dbmodel.DBModel;
import dbmodel.DBModel$DEBUG$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import proteomics.PEPTIDEModel$;
import proteomics.PEPTIDEModel$PeptideEntry$;
import proteomics.PEPTIDEModel$PeptideHit$;
import proteomics.PEPTIDEModel$ProteinEntry$;
import proteomics.PEPTIDEModel$RunFile$;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class PEPTIDEModel {
    public static <K> DBFile.OFile<PeptideEntry, K> toPeptideFile(DBModel.OrderedCollection.OColl<PeptideEntry, K> oColl) {
        return PEPTIDEModel$.MODULE$.toPeptideFile(oColl);
    }

    public static <K> DBFile.OFile<ProteinEntry, K> toProteinFile(DBModel.OrderedCollection.OColl<ProteinEntry, K> oColl) {
        return PEPTIDEModel$.MODULE$.toProteinFile(oColl);
    }

    public static class PeptideEntry
    implements Product,
    Serializable {
        private final int id;
        private final double rt;
        private final double mz;
        private final double score;
        private final int rank;
        private final String sequence;
        private final int charge;
        private final String aa_before;
        private final String aa_after;
        private final String score_type;
        private final String search_id;
        private final int predicted_rt;
        private final int predicted_pt;
        private final List hits;

        public static PeptideEntry apply(int n, double d, double d2, double d3, int n2, String string, int n3, String string2, String string3, String string4, String string5, int n4, int n5, List<PeptideHit> list) {
            return PEPTIDEModel$PeptideEntry$.MODULE$.apply(n, d, d2, d3, n2, string, n3, string2, string3, string4, string5, n4, n5, list);
        }

        public static PeptideEntry fromProduct(Product product) {
            return PEPTIDEModel$PeptideEntry$.MODULE$.fromProduct(product);
        }

        public static PeptideEntry unapply(PeptideEntry peptideEntry) {
            return PEPTIDEModel$PeptideEntry$.MODULE$.unapply(peptideEntry);
        }

        public PeptideEntry(int id, double rt, double mz, double score, int rank, String sequence, int charge, String aa_before, String aa_after, String score_type, String search_id, int predicted_rt, int predicted_pt, List<PeptideHit> hits) {
            this.id = id;
            this.rt = rt;
            this.mz = mz;
            this.score = score;
            this.rank = rank;
            this.sequence = sequence;
            this.charge = charge;
            this.aa_before = aa_before;
            this.aa_after = aa_after;
            this.score_type = score_type;
            this.search_id = search_id;
            this.predicted_rt = predicted_rt;
            this.predicted_pt = predicted_pt;
            this.hits = hits;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rt()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mz()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.score()));
            n = Statics.mix((int)n, (int)this.rank());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sequence()));
            n = Statics.mix((int)n, (int)this.charge());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.aa_before()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.aa_after()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.score_type()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.search_id()));
            n = Statics.mix((int)n, (int)this.predicted_rt());
            n = Statics.mix((int)n, (int)this.predicted_pt());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.hits()));
            return Statics.finalizeHash((int)n, (int)14);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PeptideEntry)) return false;
            PeptideEntry peptideEntry = (PeptideEntry)object;
            if (this.rt() != peptideEntry.rt()) return false;
            if (this.mz() != peptideEntry.mz()) return false;
            if (this.score() != peptideEntry.score()) return false;
            if (this.rank() != peptideEntry.rank()) return false;
            if (this.charge() != peptideEntry.charge()) return false;
            if (this.predicted_rt() != peptideEntry.predicted_rt()) return false;
            if (this.predicted_pt() != peptideEntry.predicted_pt()) return false;
            if (this.id() != peptideEntry.id()) return false;
            String string = this.sequence();
            String string2 = peptideEntry.sequence();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.aa_before();
            String string4 = peptideEntry.aa_before();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.aa_after();
            String string6 = peptideEntry.aa_after();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.score_type();
            String string8 = peptideEntry.score_type();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.search_id();
            String string10 = peptideEntry.search_id();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            List<PeptideHit> list = this.hits();
            List<PeptideHit> list2 = peptideEntry.hits();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!peptideEntry.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PeptideEntry;
        }

        public int productArity() {
            return 14;
        }

        public String productPrefix() {
            return "PeptideEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return BoxesRunTime.boxToInteger((int)this._7());
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return BoxesRunTime.boxToInteger((int)this._12());
                }
                case 12: {
                    return BoxesRunTime.boxToInteger((int)this._13());
                }
                case 13: {
                    return this._14();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "rt";
                }
                case 2: {
                    return "mz";
                }
                case 3: {
                    return "score";
                }
                case 4: {
                    return "rank";
                }
                case 5: {
                    return "sequence";
                }
                case 6: {
                    return "charge";
                }
                case 7: {
                    return "aa_before";
                }
                case 8: {
                    return "aa_after";
                }
                case 9: {
                    return "score_type";
                }
                case 10: {
                    return "search_id";
                }
                case 11: {
                    return "predicted_rt";
                }
                case 12: {
                    return "predicted_pt";
                }
                case 13: {
                    return "hits";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public double rt() {
            return this.rt;
        }

        public double mz() {
            return this.mz;
        }

        public double score() {
            return this.score;
        }

        public int rank() {
            return this.rank;
        }

        public String sequence() {
            return this.sequence;
        }

        public int charge() {
            return this.charge;
        }

        public String aa_before() {
            return this.aa_before;
        }

        public String aa_after() {
            return this.aa_after;
        }

        public String score_type() {
            return this.score_type;
        }

        public String search_id() {
            return this.search_id;
        }

        public int predicted_rt() {
            return this.predicted_rt;
        }

        public int predicted_pt() {
            return this.predicted_pt;
        }

        public List<PeptideHit> hits() {
            return this.hits;
        }

        public String seq() {
            return this.sequence().replaceAll("\\(Oxidation\\)", "").replaceAll("\\(Carbamidomethyl\\)", "").replaceAll("\\.\\(Glu->pyro-Glu\\)", "").replaceAll("\\.\\(Gln->pyro-Glu\\)", "").replaceAll("\\.\\(Acetyl\\)", "").replaceAll("\\.\\(Ammonia-loss\\)", "");
        }

        public List<String> accessions() {
            return this.hits().map((Function1 & Serializable)_$1 -> _$1.accession());
        }

        public List<Object> starts() {
            return this.hits().map((Function1 & Serializable)_$2 -> _$2.start());
        }

        public List<Object> ends() {
            return this.hits().map((Function1 & Serializable)_$3 -> _$3.end());
        }

        public PeptideEntry copy(int id, double rt, double mz, double score, int rank, String sequence, int charge, String aa_before, String aa_after, String score_type, String search_id, int predicted_rt, int predicted_pt, List<PeptideHit> hits) {
            return new PeptideEntry(id, rt, mz, score, rank, sequence, charge, aa_before, aa_after, score_type, search_id, predicted_rt, predicted_pt, hits);
        }

        public int copy$default$1() {
            return this.id();
        }

        public double copy$default$2() {
            return this.rt();
        }

        public double copy$default$3() {
            return this.mz();
        }

        public double copy$default$4() {
            return this.score();
        }

        public int copy$default$5() {
            return this.rank();
        }

        public String copy$default$6() {
            return this.sequence();
        }

        public int copy$default$7() {
            return this.charge();
        }

        public String copy$default$8() {
            return this.aa_before();
        }

        public String copy$default$9() {
            return this.aa_after();
        }

        public String copy$default$10() {
            return this.score_type();
        }

        public String copy$default$11() {
            return this.search_id();
        }

        public int copy$default$12() {
            return this.predicted_rt();
        }

        public int copy$default$13() {
            return this.predicted_pt();
        }

        public List<PeptideHit> copy$default$14() {
            return this.hits();
        }

        public int _1() {
            return this.id();
        }

        public double _2() {
            return this.rt();
        }

        public double _3() {
            return this.mz();
        }

        public double _4() {
            return this.score();
        }

        public int _5() {
            return this.rank();
        }

        public String _6() {
            return this.sequence();
        }

        public int _7() {
            return this.charge();
        }

        public String _8() {
            return this.aa_before();
        }

        public String _9() {
            return this.aa_after();
        }

        public String _10() {
            return this.score_type();
        }

        public String _11() {
            return this.search_id();
        }

        public int _12() {
            return this.predicted_rt();
        }

        public int _13() {
            return this.predicted_pt();
        }

        public List<PeptideHit> _14() {
            return this.hits();
        }
    }

    public static class PeptideHit
    implements Product,
    Serializable {
        private final String accession;
        private final int start;
        private final int end;

        public static PeptideHit apply(String string, int n, int n2) {
            return PEPTIDEModel$PeptideHit$.MODULE$.apply(string, n, n2);
        }

        public static PeptideHit fromProduct(Product product) {
            return PEPTIDEModel$PeptideHit$.MODULE$.fromProduct(product);
        }

        public static PeptideHit unapply(PeptideHit peptideHit) {
            return PEPTIDEModel$PeptideHit$.MODULE$.unapply(peptideHit);
        }

        public PeptideHit(String accession, int start, int end) {
            this.accession = accession;
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.accession()));
            n = Statics.mix((int)n, (int)this.start());
            n = Statics.mix((int)n, (int)this.end());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PeptideHit)) return false;
            PeptideHit peptideHit = (PeptideHit)object;
            if (this.start() != peptideHit.start()) return false;
            if (this.end() != peptideHit.end()) return false;
            String string = this.accession();
            String string2 = peptideHit.accession();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!peptideHit.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PeptideHit;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PeptideHit";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "accession";
                }
                case 1: {
                    return "start";
                }
                case 2: {
                    return "end";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String accession() {
            return this.accession;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public PeptideHit copy(String accession, int start, int end) {
            return new PeptideHit(accession, start, end);
        }

        public String copy$default$1() {
            return this.accession();
        }

        public int copy$default$2() {
            return this.start();
        }

        public int copy$default$3() {
            return this.end();
        }

        public String _1() {
            return this.accession();
        }

        public int _2() {
            return this.start();
        }

        public int _3() {
            return this.end();
        }
    }

    public static class ProteinEntry
    implements Product,
    Serializable {
        private final int id;
        private final double score;
        private final int rank;
        private final String accession;
        private final String protein_description;
        private final double coverage;
        private final String sequence;
        private final String target_decoy;

        public static ProteinEntry apply(int n, double d, int n2, String string, String string2, double d2, String string3, String string4) {
            return PEPTIDEModel$ProteinEntry$.MODULE$.apply(n, d, n2, string, string2, d2, string3, string4);
        }

        public static ProteinEntry fromProduct(Product product) {
            return PEPTIDEModel$ProteinEntry$.MODULE$.fromProduct(product);
        }

        public static ProteinEntry unapply(ProteinEntry proteinEntry) {
            return PEPTIDEModel$ProteinEntry$.MODULE$.unapply(proteinEntry);
        }

        public ProteinEntry(int id, double score, int rank, String accession, String protein_description, double coverage, String sequence, String target_decoy) {
            this.id = id;
            this.score = score;
            this.rank = rank;
            this.accession = accession;
            this.protein_description = protein_description;
            this.coverage = coverage;
            this.sequence = sequence;
            this.target_decoy = target_decoy;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.score()));
            n = Statics.mix((int)n, (int)this.rank());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.accession()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.protein_description()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.coverage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sequence()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.target_decoy()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProteinEntry)) return false;
            ProteinEntry proteinEntry = (ProteinEntry)object;
            if (this.score() != proteinEntry.score()) return false;
            if (this.rank() != proteinEntry.rank()) return false;
            if (this.coverage() != proteinEntry.coverage()) return false;
            if (this.id() != proteinEntry.id()) return false;
            String string = this.accession();
            String string2 = proteinEntry.accession();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.protein_description();
            String string4 = proteinEntry.protein_description();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.sequence();
            String string6 = proteinEntry.sequence();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.target_decoy();
            String string8 = proteinEntry.target_decoy();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            if (!proteinEntry.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ProteinEntry;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "ProteinEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToDouble((double)this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "score";
                }
                case 2: {
                    return "rank";
                }
                case 3: {
                    return "accession";
                }
                case 4: {
                    return "protein_description";
                }
                case 5: {
                    return "coverage";
                }
                case 6: {
                    return "sequence";
                }
                case 7: {
                    return "target_decoy";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public double score() {
            return this.score;
        }

        public int rank() {
            return this.rank;
        }

        public String accession() {
            return this.accession;
        }

        public String protein_description() {
            return this.protein_description;
        }

        public double coverage() {
            return this.coverage;
        }

        public String sequence() {
            return this.sequence;
        }

        public String target_decoy() {
            return this.target_decoy;
        }

        public ProteinEntry copy(int id, double score, int rank, String accession, String protein_description, double coverage, String sequence, String target_decoy) {
            return new ProteinEntry(id, score, rank, accession, protein_description, coverage, sequence, target_decoy);
        }

        public int copy$default$1() {
            return this.id();
        }

        public double copy$default$2() {
            return this.score();
        }

        public int copy$default$3() {
            return this.rank();
        }

        public String copy$default$4() {
            return this.accession();
        }

        public String copy$default$5() {
            return this.protein_description();
        }

        public double copy$default$6() {
            return this.coverage();
        }

        public String copy$default$7() {
            return this.sequence();
        }

        public String copy$default$8() {
            return this.target_decoy();
        }

        public int _1() {
            return this.id();
        }

        public double _2() {
            return this.score();
        }

        public int _3() {
            return this.rank();
        }

        public String _4() {
            return this.accession();
        }

        public String _5() {
            return this.protein_description();
        }

        public double _6() {
            return this.coverage();
        }

        public String _7() {
            return this.sequence();
        }

        public String _8() {
            return this.target_decoy();
        }
    }

    public static class RunFile
    implements Product,
    Serializable {
        private final String filename;
        private final String run_id;
        private final String score_type;
        private final String score_direction;
        private final String date_time;
        private final String search_engine_version;
        private final String parameters;
        private final DBFile.OFile protein_file;
        private final DBFile.OFile peptide_file;
        private boolean protect;

        public static RunFile apply(String string) {
            return PEPTIDEModel$RunFile$.MODULE$.apply(string);
        }

        public static RunFile apply(String string, String string2) {
            return PEPTIDEModel$RunFile$.MODULE$.apply(string, string2);
        }

        public static RunFile apply(String string, String string2, String string3, String string4, String string5, String string6, String string7, DBFile.OFile<ProteinEntry, Object> oFile, DBFile.OFile<PeptideEntry, Object> oFile2) {
            return PEPTIDEModel$RunFile$.MODULE$.apply(string, string2, string3, string4, string5, string6, string7, oFile, oFile2);
        }

        public static void destructorRunFile(RunFile runFile) {
            PEPTIDEModel$RunFile$.MODULE$.destructorRunFile(runFile);
        }

        public static String entry(RunFile runFile) {
            return PEPTIDEModel$RunFile$.MODULE$.entry(runFile);
        }

        public static RunFile fromProduct(Product product) {
            return PEPTIDEModel$RunFile$.MODULE$.fromProduct(product);
        }

        public static String header() {
            return PEPTIDEModel$RunFile$.MODULE$.header();
        }

        public static RunFile unapply(RunFile runFile) {
            return PEPTIDEModel$RunFile$.MODULE$.unapply(runFile);
        }

        public static String toFile$default$3() {
            return PEPTIDEModel$RunFile$.MODULE$.toFile$default$3();
        }

        public RunFile(String filename, String run_id, String score_type, String score_direction, String date_time, String search_engine_version, String parameters, DBFile.OFile<ProteinEntry, Object> protein_file, DBFile.OFile<PeptideEntry, Object> peptide_file) {
            this.filename = filename;
            this.run_id = run_id;
            this.score_type = score_type;
            this.score_direction = score_direction;
            this.date_time = date_time;
            this.search_engine_version = search_engine_version;
            this.parameters = parameters;
            this.protein_file = protein_file;
            this.peptide_file = peptide_file;
            this.protect = true;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RunFile)) return false;
            RunFile runFile = (RunFile)object;
            String string = this.filename();
            String string2 = runFile.filename();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.run_id();
            String string4 = runFile.run_id();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.score_type();
            String string6 = runFile.score_type();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.score_direction();
            String string8 = runFile.score_direction();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.date_time();
            String string10 = runFile.date_time();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.search_engine_version();
            String string12 = runFile.search_engine_version();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            String string13 = this.parameters();
            String string14 = runFile.parameters();
            if (string13 == null) {
                if (string14 != null) {
                    return false;
                }
            } else if (!string13.equals(string14)) return false;
            DBFile.OFile<ProteinEntry, Object> oFile = this.protein_file();
            DBFile.OFile<ProteinEntry, Object> oFile2 = runFile.protein_file();
            if (oFile == null) {
                if (oFile2 != null) {
                    return false;
                }
            } else if (!oFile.equals(oFile2)) return false;
            DBFile.OFile<PeptideEntry, Object> oFile3 = this.peptide_file();
            DBFile.OFile<PeptideEntry, Object> oFile4 = runFile.peptide_file();
            if (oFile3 == null) {
                if (oFile4 != null) {
                    return false;
                }
            } else if (!oFile3.equals(oFile4)) return false;
            if (!runFile.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RunFile;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "RunFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "filename";
                }
                case 1: {
                    return "run_id";
                }
                case 2: {
                    return "score_type";
                }
                case 3: {
                    return "score_direction";
                }
                case 4: {
                    return "date_time";
                }
                case 5: {
                    return "search_engine_version";
                }
                case 6: {
                    return "parameters";
                }
                case 7: {
                    return "protein_file";
                }
                case 8: {
                    return "peptide_file";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String filename() {
            return this.filename;
        }

        public String run_id() {
            return this.run_id;
        }

        public String score_type() {
            return this.score_type;
        }

        public String score_direction() {
            return this.score_direction;
        }

        public String date_time() {
            return this.date_time;
        }

        public String search_engine_version() {
            return this.search_engine_version;
        }

        public String parameters() {
            return this.parameters;
        }

        public DBFile.OFile<ProteinEntry, Object> protein_file() {
            return this.protein_file;
        }

        public DBFile.OFile<PeptideEntry, Object> peptide_file() {
            return this.peptide_file;
        }

        public boolean protect() {
            return this.protect;
        }

        public void protect_$eq(boolean x$1) {
            this.protect = x$1;
        }

        public RunFile protection(boolean flag) {
            this.protect_$eq(flag);
            return this;
        }

        public boolean protection$default$1() {
            return true;
        }

        public void close() {
            String err = new StringBuilder(47).append("**** PEPTIDEModel.RunFile.close: Cannot delete ").append(this.filename()).toString();
            if (!this.protect()) {
                String string = this.filename();
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    try {
                        Files.deleteIfExists(Paths.get(this.filename(), new String[0]));
                    }
                    catch (Throwable throwable) {
                        DBModel$DEBUG$.MODULE$.message(err);
                    }
                    return;
                }
            }
        }

        public String toFile(String filename, String folder) {
            return PEPTIDEModel$RunFile$.MODULE$.toFile(this, filename, folder);
        }

        public String toFile$default$2() {
            return DBFile$.MODULE$.TMP();
        }

        public RunFile copy(String filename, String run_id, String score_type, String score_direction, String date_time, String search_engine_version, String parameters, DBFile.OFile<ProteinEntry, Object> protein_file, DBFile.OFile<PeptideEntry, Object> peptide_file) {
            return new RunFile(filename, run_id, score_type, score_direction, date_time, search_engine_version, parameters, protein_file, peptide_file);
        }

        public String copy$default$1() {
            return this.filename();
        }

        public String copy$default$2() {
            return this.run_id();
        }

        public String copy$default$3() {
            return this.score_type();
        }

        public String copy$default$4() {
            return this.score_direction();
        }

        public String copy$default$5() {
            return this.date_time();
        }

        public String copy$default$6() {
            return this.search_engine_version();
        }

        public String copy$default$7() {
            return this.parameters();
        }

        public DBFile.OFile<ProteinEntry, Object> copy$default$8() {
            return this.protein_file();
        }

        public DBFile.OFile<PeptideEntry, Object> copy$default$9() {
            return this.peptide_file();
        }

        public String _1() {
            return this.filename();
        }

        public String _2() {
            return this.run_id();
        }

        public String _3() {
            return this.score_type();
        }

        public String _4() {
            return this.score_direction();
        }

        public String _5() {
            return this.date_time();
        }

        public String _6() {
            return this.search_engine_version();
        }

        public String _7() {
            return this.parameters();
        }

        public DBFile.OFile<ProteinEntry, Object> _8() {
            return this.protein_file();
        }

        public DBFile.OFile<PeptideEntry, Object> _9() {
            return this.peptide_file();
        }
    }
}

