package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */

/*
 * All the converter functions
 */
public class Converter {

	public static byte[] intToBytes2(int n) {
		byte[] b = new byte[5];
		int index = 0;
		while (n > 0) {
			b[index++] = (byte) ((n & 63) | 64);
			n >>= 6;
		}
		while (index < 5)
			b[index++] = 64;
		return b;
	}

	public static int byteToInt2(byte[] b) {
		int n = 0;
		for (int i = b.length - 1; i >= 0; i--) {
			n <<= 6;
			n |= (b[i] & 63);
		}
		return n;
	}

	public static String bitToIdList(byte[] bitstring, int length) {
		int i = 0;
		String idList = new String();
		for (int j = 0; j < length; j++) {
			for (int k = 0; k < 6; k++) {
				i++;
				if ((bitstring[j] & (byte) 1 << k) != 0) {
					idList = idList + "," + i;
				}
			}

		}

		return idList;

	}

	public static int singleByteToInt(byte type) {
		for (int i = 0; i < 3; i++) {
			if ((type & (byte) 1 << i) != 0)
				return i;
		}
		return 0;
	}

}
