package sg.edu.nus;

import java.text.*;
public class DistributionCaculation {

	static double[][] x2DistriTable = {
			{ 0.0000393, 0.0001571, 0.0009821, 0.0039321, 0.157908, 2, 3.84146,
					5.02389, 6.63490, 7.87944 },
			{ 0.0100251, 0.0201007, 0.050656, 0.102587, 0.210720, 4.60517,
					5.99147, 7.37776, 9.21034, 10.5966 },
			{ 0.0717212, 0.114832, 0.215795, 0.351846, 0.584375, 6.25139,
					7.81473, 9.3484, 11.3449, 12.8381 },
			{ 0.20699, 0.2971, 0.484419, 0.710721, 1.063623, 7.77944, 9.48773,
					11.1433, 13.2767, 14.8602 },
			{ 0.41174, 0.5543, 0.831211, 1.145476, 1.61031, 9.23635, 11.0705,
					12.8325, 15.0863, 16.8602 },
			{ 0.675727, 0.872085, 1.237347, 1.63539, 2.20413, 10.6446, 12.5916,
					14.4494, 16.8116, 18.5476 },
			{ 0.9892665, 1.239043, 1.68987, 2.16735, 2.83311, 12.017, 14.0671,
					16.0128, 18.4753, 20.2777 },
			{ 1.3444419, 1.646482, 2.17973, 2.73264, 3.48954, 13.3616, 15.5073,
					17.5346, 20.0902, 21.955 },
			{ 1.73496, 2.0879, 2.70039, 3.32511, 4.16816, 14.6837, 16.919,
					19.0228, 21.666, 23.5893 },
			{ 2.15585, 2.55821, 3.24697, 3.94030, 4.86518, 15.9871, 18.307,
					20.4861, 23.2093, 25.1882 },
			{ 2.60321, 3.05347, 3.81575, 4.57481, 5.57779, 17.2750, 19.6751,
					21.92, 24.7250, 26.7569 },
			{ 3.07382, 3.57056, 4.40379, 5.22603, 6.3038, 18.5494, 21.0261,
					23.3367, 26.217, 28.2995 },
			{ 3.56503, 4.10691, 5.0087, 5.89186, 7.0415, 19.8119, 22.3621,
					24.7356, 27.6883, 29.8194 },
			{ 4.07468, 4.66043, 5.62872, 6.57063, 7.78953, 21.0642, 23.6848,
					26.119, 29.1413, 31.3193 },
			{ 4.60094, 5.22935, 6.26214, 7.26094, 8.54675, 22.3072, 24.9958,
					27.4884, 30.5779, 32.8013 } };

	static double[] pTable = { 0.995, 0.99, 0.975, 0.950, 0.9, 0.1, 0.05,
			0.025, 0.01, 0.005 };

	public static double getPValueForChiSquare(double x2value, int dof) {
		double pValue = 0;
		DecimalFormat myFormatter=new DecimalFormat("####.#####");
		int position = getPosition(x2value, dof);
		if (position == 9) {
			pValue = 0.005 - (x2value - x2DistriTable[dof - 1][position]) * 0.001;
			if (pValue < 0)
				pValue = 0;
			return Double.parseDouble(myFormatter.format(pValue));
		} else if (position > 0) {

			pValue = pTable[position]
					- (pTable[position] - pTable[position + 1])
					* (x2value - x2DistriTable[dof - 1][position])
					/ (x2DistriTable[dof - 1][position + 1] - x2DistriTable[dof - 1][position]);
			return Double.parseDouble(myFormatter.format(pValue));
		} else

			return 1;
	}

	public static int getPosition(double x2value, int dof) {
		for (int i = 9; i >= 0; i--) {
			if (x2value >= x2DistriTable[dof - 1][i]) {
				return i;
			}
		}
		return 0;
	}
/*****************************************************************************
 * Users can add their own algorithm for different statistic methods
 *****************************************************************************/
}
