package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */
import java.io.*;
import java.util.*;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.conf.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;
import org.apache.hadoop.util.*;

/******************************************
 * The reducer for the data pre-processing
 *******************************************/
public class PreprocessReducer extends MapReduceBase implements
		Reducer<Text, Text, NullWritable, Text> {
	public Text newKey = new Text("");
	public Text newValue = new Text("");
	String strValue = null;
	String finalValue = null;
	String sampleIdArray[];
	BitSet sampleIdBitset;
	String smapleList;
	String[] keyDGT;
	int sampleBitLength = 334;
	byte[] sampleBitList;
	byte[] tmpBytes;
	int snp = 0;

	public void reduce(Text key, Iterator<Text> values,
			OutputCollector<NullWritable, Text> output, Reporter reporter) {

		sampleBitList = new byte[512];
		int sampleId = 0;
		while (values.hasNext()) {
			sampleId = Integer.valueOf(values.next().toString());
			sampleBitList[sampleId / 6] = (byte) (sampleBitList[sampleId / 6] | (1 << sampleId % 6));
		}
		keyDGT = key.toString().split(" ");
		/**********************************************
		 * Converter the sample id to the bit string list
		 ************************************************/
		sampleBitList[sampleBitLength] = (byte) (sampleBitList[sampleBitLength] | (1 << Integer
				.valueOf(keyDGT[2])));
		sampleBitList[sampleBitLength + 1] = (byte) (sampleBitList[sampleBitLength + 1] | (1 << Integer
				.valueOf(keyDGT[1])));

		for (int j = 0; j < sampleBitLength; j++) {
			sampleBitList[j] = (byte) (sampleBitList[j] | (1 << 6));
		}
		snp = Integer.valueOf(keyDGT[0]);

		tmpBytes = Converter.intToBytes2(snp);
		for (int i = 0; i < 5; i++) {
			sampleBitList[sampleBitLength + 2 + i] = tmpBytes[i];
		}

		newValue.set(sampleBitList, 0, 341);
		try {

			output.collect(NullWritable.get(), newValue);

		} catch (IOException e) {
			e.printStackTrace();
		}

	}

}
