package sg.edu.nus;

/*
 * @author: Zhengkui Wang
 * 
 * National university of singapore
 */

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

/***************************************************
 * Store the Single two-locus SNPs record
 * with one single bit sample id list  
 *****************************************************/
public class SingleTwoLocusData implements Writable{
	public int firstSnp;
	public int secondSnp;
	public int firstSnpValue;
	public int secondSnpValue;
	public int x2Value;
	public int diease;
	public byte [] sampleArray=new byte[352];
	
	public void setAllValues(int ifirstsnp,int isecondsnp, int ifirstsnpvalue,int isecondsnpvalue,int ipvalue,int idiease,byte[] bsamplearray)
	{
		System.out.println("passed in is:"+Converter.bitToIdList(bsamplearray, 334));
		this.firstSnp=ifirstsnp;
		this.secondSnp=isecondsnp;
		this.secondSnpValue=isecondsnpvalue;
		this.firstSnpValue=ifirstsnpvalue;
		this.diease=idiease;
		this.x2Value=ipvalue;
		for(int i=0;i<352;i++)
			this.sampleArray[i]=bsamplearray[i];

	}

	public int getFirstSnp()
	{
		return this.firstSnp;
	}
	public int getSecondSnp()
	{
		return this.secondSnp;
	}
	public int getX2Value()
	{
		return this.x2Value;
	}
	public int getFirstSnpValue()
	{
		return this.firstSnpValue;
	}
	public int getSecondSnpValue()
	{
		return this.secondSnpValue;
	}
	public int getDiease()
	{
		return this.diease;
	}
	public byte[] getSampleArray() 
	{
		return this.sampleArray;
	}
	@Override
	public void readFields(DataInput in) throws IOException {
		this.firstSnp=in.readInt();
		this.secondSnp=in.readInt();
		this.firstSnpValue=in.readInt();
		this.secondSnpValue=in.readInt();
		this.x2Value=in.readInt();
		this.diease=in.readInt();
		this.sampleArray=WritableUtils.readCompressedByteArray(in);
	}

	@Override
	public void write(DataOutput out) throws IOException {
		out.writeInt(this.firstSnp);
		out.writeInt(this.secondSnp);
		out.writeInt(this.firstSnpValue);
		out.writeInt(this.secondSnpValue);
		out.writeInt(this.x2Value);
		out.writeInt(this.diease);
		WritableUtils.writeCompressedByteArray(out, this.sampleArray);
		
	}

	
}
