package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */
public class StatisticCollection {

	/******************************************************************
	 * Statistic method: chi-square test
	 * 
	 * @parameter: table[][]: the contingency table with cell number
	 * ptnum: how many different phenotype values in your data
	 * gtnum: how many different genotype values in your data
	 * analysisorder: the k value for k-locus analysis, for instance, it is 2
	 * for two-locus analysis
	 ************************************************************************/

	public static double caculateCS(int[][] table, int ptnum, int gtnum,
			int analysisorder) {
		double x2Value = 0;
		int ptNum = ptnum;
		int gtNum = gtnum;
		int columnNum = (int) Math.pow(gtNum, analysisorder);
		double[] rowTotalNum = new double[ptNum];
		double[] columnTotalNum = new double[columnNum];
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				table[i][j] += 1;
				rowTotalNum[i] = rowTotalNum[i] + table[i][j];
				columnTotalNum[j] = columnTotalNum[j] + table[i][j];
			}
		double tableTotalNum = 0;
		for (int i = 0; i < ptNum; i++) {
			tableTotalNum += rowTotalNum[i];
		}
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				x2Value = x2Value
						+ (Math.pow((table[i][j] - rowTotalNum[i]
								* columnTotalNum[j] / tableTotalNum), 2) * tableTotalNum)
						/ (rowTotalNum[i] * columnTotalNum[j]);
			}
		return x2Value;
	}

	/*********************************************************
	 * Statistic method: likelihood-ratio test
	 * 
	 * @parameter: table[][]: the contingency table with cell number
	 * analysisorder: the k value for k-locus analysis, for instance, it is 2
	 * for two-locus analysis
	 ***********************************************************************/
	public static double caculateLHR(int[][] table, int ptnum, int gtnum,
			int analysisorder) {
		double gValue = 0;
		int ptNum = ptnum;
		int gtNum = gtnum;
		int columnNum = (int) Math.pow(gtNum, analysisorder);
		double[] rowTotalNum = new double[ptNum];
		double[] columnTotalNum = new double[columnNum];
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				// table[i][j] += 1;
				rowTotalNum[i] = rowTotalNum[i] + table[i][j];
				columnTotalNum[j] = columnTotalNum[j] + table[i][j];
			}
		double tableTotalNum = 0;
		for (int i = 0; i < ptNum; i++) {
			tableTotalNum += rowTotalNum[i];
		}
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				if (table[i][j] != 0)
					gValue = gValue
							+ table[i][j]
							* (Math
									.log(table[i][j]
											/ (rowTotalNum[i]
													* columnTotalNum[j] / tableTotalNum)));
			}
		return 2 * gValue;
	}

	/*******************************************************************
	 * Statistic method: Normalized Mutual Information (NMI)
	 * 
	 * @parameter: table[][]: the contingency table with cell number
	 * analysisorder: the k value for k-locus analysis, for instance, it is 2
	 * for two-locus analysis
	 *************************************************************************/
	public static double caculateNMI(int[][] table, int ptnum, int gtnum,
			int analysisorder) {
		double nmiValue = 0;
		int ptNum = ptnum;
		int gtNum = gtnum;
		int columnNum = (int) Math.pow(gtNum, analysisorder);
		double[] rowTotalNum = new double[ptNum];
		double[] columnTotalNum = new double[columnNum];
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				rowTotalNum[i] = rowTotalNum[i] + table[i][j];
				columnTotalNum[j] = columnTotalNum[j] + table[i][j];
			}
		double tableTotalNum = 0;
		for (int i = 0; i < ptNum; i++) {
			tableTotalNum += rowTotalNum[i];
		}
		double hy_x1 = 0;
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				if (table[i][j] > 0)
					hy_x1 += table[i][j] * Math.log(table[i][j]);
			}
		double hy_x2 = 0;
		for (int i = 0; i < ptNum; i++) {
			if (rowTotalNum[i] > 0)
				hy_x2 += rowTotalNum[i] * Math.log(rowTotalNum[i]);
		}
		double hy = tableTotalNum * Math.log(tableTotalNum);
		for (int i = 0; i < columnNum; i++) {
			if (columnTotalNum[i] > 0)
				hy += columnTotalNum[i] * Math.log(columnTotalNum[i]);
		}

		nmiValue = 1 - (-hy_x1 + hy_x2) / hy;
		return nmiValue;
	}

	/***************************************************************************
	 * Statistic method: Uncertainty Coefficient (UC)
	 * 
	 * @parameter: table[][]: the contingency table with cell number
	 * analysisorder: the k value for k-locus analysis, for instance, it is 2
	 * for two-locus analysis UC=2*(Hy-Hy_x)/(Hy+Hx)
	 ****************************************************************************/
	public static double caculateUC(int[][] table, int ptnum, int gtnum,
			int analysisorder) {
		double ucValue = 0;
		int ptNum = ptnum;
		int gtNum = gtnum;
		int columnNum = (int) Math.pow(gtNum, analysisorder);
		double[] rowTotalNum = new double[ptNum];
		double[] columnTotalNum = new double[columnNum];
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				rowTotalNum[i] = rowTotalNum[i] + table[i][j];
				columnTotalNum[j] = columnTotalNum[j] + table[i][j];
			}
		double tableTotalNum = 0;
		for (int i = 0; i < ptNum; i++) {
			tableTotalNum += rowTotalNum[i];
		}
		double hy = 0;
		for (int i = 0; i < columnNum; i++) {
			if (columnTotalNum[i] > 0)
				hy += columnTotalNum[i] * Math.log(columnTotalNum[i]);
		}
		double hx = 0;
		for (int i = 0; i < ptNum; i++) {
			if (rowTotalNum[i] > 0)
				hx += rowTotalNum[i] * Math.log(rowTotalNum[i]);
		}
		double hy_x_row = 0;
		double hy_x_column = 0;
		for (int i = 0; i < ptNum; i++)
			for (int j = 0; j < columnNum; j++) {
				if (rowTotalNum[i] != 0 && table[i][j] > 0
						&& Math.log(table[i][j]) != 0)
					hy_x_row += table[i][j]
							/ (rowTotalNum[i] * Math.log(table[i][j]));
				if (columnTotalNum[j] != 0 && Math.log(table[i][j]) != 0) {
					hy_x_column += table[i][j]
							/ (columnTotalNum[j] * Math.log(table[i][j]));
				}
			}
		ucValue = 2 * (-hy - (hy_x_row * hy_x_row + hy_x_column * hy_x_column))
				/ (-hy - hx);
		return ucValue;
	}

}
