package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */
import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
/*
 * The mapper for the three-locus analysis
 * Input: two-locus data
 */
public class ThreeSnpsMapper extends MapReduceBase implements Mapper<LongWritable, Text, DoubleWritable, Text> 
{
	 DoubleWritable newKey=new DoubleWritable();
	 Text newValue = new Text();
	int snpTotalNum=0;
	int reducerTotalNum=0;
	Text tmpText;
	byte [] valueArray;
	byte [] firstSnp=new byte[5];
	byte [] secondSnp=new byte[5];
    @Override
    public void configure (JobConf job)
    {
   	 this.snpTotalNum=job.getInt("snp.num", 0);   
   	 this.reducerTotalNum=job.getInt("reducer.num", 0);
   	}

	public void map(LongWritable key, Text value, OutputCollector<DoubleWritable, Text> output, Reporter reporter)
	{
		 processTuple(value, output);
	}
	public void processTuple(Text value, OutputCollector<DoubleWritable, Text> output)
	{
		
		  
		tmpText=value;
		if(value==null)
			return;
		int snp=0;
		valueArray=value.getBytes();
		if(valueArray.length != 352)
			return;
		for(int i=0;i<5;i++)
		{
			firstSnp[i]=valueArray[347+i];
			secondSnp[i]=valueArray[342+i];
		}
		
				double y=1000000;
				double newKeyValue=0;
				double first=(double)Converter.byteToInt2(firstSnp);
				double second=(double)Converter.byteToInt2(secondSnp);
				
				newKeyValue= (double)Converter.byteToInt2(firstSnp)+(double)Converter.byteToInt2(secondSnp)/y;
				//key format:snp1.snp2 
				newKey.set(newKeyValue);
					try {
						output.collect(newKey, tmpText);
					} catch (IOException e) {
						e.printStackTrace();
					}  
				 
				
			
	}
	
}
