package sg.edu.nus;
/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.*;
/**********************************************************
 * The partitioning function for the three-locus analysis
 * 
 **********************************************************/
public class ThreeSnpsPartitioner implements Partitioner<DoubleWritable, Text> {

	int snpTotalNum = 0;
	int reducerTotalNum = 0;
	String splittorString=null;
	int [] splittor;
/***********************************************************
 * Using the load balancing algorithm to balance the load 
 * passing in all the necessary parameters
 ************************************************************/
	@Override
	public void configure(JobConf job) {
		this.snpTotalNum = job.getInt("snp.num", 0);
		this.reducerTotalNum = job.getInt("reducer.num", 0);
		this.splittorString=job.get("splittor");
		splittor = new int[this.reducerTotalNum];
		String[] split = this.splittorString.split(",");
		splittor = new int[split.length];
		for (int i = 0; i < split.length; i++) {
			splittor[i] = Integer.parseInt(split[i]);
		}
	}

	@Override
	public int getPartition(DoubleWritable key, Text value, int numReduceTask) {

		int snp = (int) key.get();
		return getSplittor(snp,splittor,0,this.splittor.length-1);

	}
	/*
	 * Get which reducer this two-locus data need to be sent to
	 */
	int getSplittor(int snp, int [] split, int left, int right)
	{
		int mid =(left+right)/2;
		if(left>right)
			return 0;
		if(mid==0 & snp <=split[mid])
		{return 0;}
		else if(snp <=split[mid] & snp>split[mid-1])
		{	return mid; }			
		else if(snp <= split[mid-1])
		{return getSplittor(snp, split, left,mid-1);}
		else if(snp > split[mid])
		{return getSplittor(snp,split,mid+1,right);}
		return 0;
	}

}
