package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

/*
 * Reducer of the top k retrieval job 
 * Output the global top k data
 */
public class TopKMingReducer extends MapReduceBase implements
		Reducer<IntWritable, SingleTwoLocusData, Text, Text> {

	int numOutput = 0;
	int numTopK = 0;
	int statisticMethod=0;
	Text newKey = new Text("");
	Text newValue = new Text("");
	ArrayList<SingleTwoLocusData> tupleArrayList;
	int idsBitLength = 334; // the bit string length, change according to your own samples number

	@Override
	public void configure(JobConf conf)

	{
		this.numTopK = conf.getInt("topk.num", 1);
		this.statisticMethod=conf.getInt("statistic.method", 1);
	}

	public void reduce(IntWritable key, Iterator<SingleTwoLocusData> values,
			OutputCollector<Text, Text> output, Reporter reporter) {
		try {

			
				while (values.hasNext()) {
					SingleTwoLocusData tmpTuple = values.next();
					if (this.numOutput < this.numTopK*18) {
						String value="First SNP is:"+tmpTuple.getFirstSnp()+ " "+"Second SNP is:"
						+ tmpTuple.getSecondSnp();
						switch(this.statisticMethod)
						{
						case 1:  
						{
							value += " "+ "The X^2 value:"
							+ (double)tmpTuple.getX2Value()/(double)100
							+" "+"p-value is:"
							+DistributionCaculation.getPValueForChiSquare((double)tmpTuple.getX2Value()/(double)100, 8)
							+ " "+"The PT:"
							+ tmpTuple.getDiease()
							+ " "+"First GT:"
							+ tmpTuple.getFirstSnpValue()
							+ " "+ "Second GT:"
							+ tmpTuple.getSecondSnpValue()
							+ " "+"Sample id list:"
							+ Converter.bitToIdList(tmpTuple.getSampleArray(),
									this.idsBitLength);
							break;
						}
						
						case 2: 
						{
							value += " "+ "The LR value:"
							+ (double)tmpTuple.getX2Value()/(double)100
							+" "+"p-value is:"
							+DistributionCaculation.getPValueForChiSquare((double)tmpTuple.getX2Value()/(double)100, 8)
							+ " "+"The PT:"
							+ tmpTuple.getDiease()
							+ " "+"First GT:"
							+ tmpTuple.getFirstSnpValue()
							+ " "+ "Second GT:"
							+ tmpTuple.getSecondSnpValue()
							+ " "+"Sample id list:"
							+ Converter.bitToIdList(tmpTuple.getSampleArray(),
									this.idsBitLength);
							break;
						}
						
						case 3: 
						{
							value += " "+ "The NMI value:"
							+ (double)tmpTuple.getX2Value()/(double)10000
							+ " "+"The PT:"
							+ tmpTuple.getDiease()
							+ " "+"First GT:"
							+ tmpTuple.getFirstSnpValue()
							+ " "+ "Second GT:"
							+ tmpTuple.getSecondSnpValue()
							+ " "+"Sample id list:"
							+ Converter.bitToIdList(tmpTuple.getSampleArray(),
									this.idsBitLength);
							break;
						}
						case 4: 
						{
							value += " "+ "The UC value:"
							+ (double)tmpTuple.getX2Value()/(double)10000
							+ " "+"The PT:"
							+ tmpTuple.getDiease()
							+ " "+"First GT:"
							+ tmpTuple.getFirstSnpValue()
							+ " "+ "Second GT:"
							+ tmpTuple.getSecondSnpValue()
							+ " "+"Sample id list:"
							+ Converter.bitToIdList(tmpTuple.getSampleArray(),
									this.idsBitLength);
							break;
						}
						default: 
						{
							value += " "+ "The X^2 value:"
							+ (double)tmpTuple.getX2Value()/(double)100
							+" "+"p-value is:"
							+DistributionCaculation.getPValueForChiSquare((double)tmpTuple.getX2Value()/(double)100, 8)
							+ " "+"The PT:"
							+ tmpTuple.getDiease()
							+ " "+"First GT:"
							+ tmpTuple.getFirstSnpValue()
							+ " "+ "Second GT:"
							+ tmpTuple.getSecondSnpValue()
							+ " "+"Sample id list:"
							+ Converter.bitToIdList(tmpTuple.getSampleArray(),
									this.idsBitLength);
							break;
						}
						}
						newValue.set(value);
					output.collect(newKey, newValue);
					this.numOutput++;
					
				}
				
			}

		} catch (IOException exc) {
			System.out.println(exc);
		}

	}

}
