package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */
import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

/**************************************************************
 * Mapper for two-locus analysis in Greedy distribution Model
 ***************************************************************/
public class TwoSnpsMapperGreedy extends MapReduceBase implements
		Mapper<LongWritable, Text, DoubleWritable, Text> {
	DoubleWritable newKey = new DoubleWritable();
	Text newValue = new Text();
	int snpTotalNum = 0;
	int reducerTotalNum = 0;
	String splittorString = null;
	int[] splittor = null;
	Text tempText = new Text();
	byte[] valueArray;
	byte[] tmpBytes = new byte[5];

	@Override
	public void configure(JobConf job) {
		this.snpTotalNum = job.getInt("snp.num", 0);
		this.reducerTotalNum = job.getInt("reducer.num", 0);
		this.splittorString = job.get("splittor");
		splittor = new int[this.reducerTotalNum];
		String[] split = new String[this.reducerTotalNum];
		split = this.splittorString.split(",");
		for (int i = 0; i < split.length; i++) {
			splittor[i] = Integer.parseInt(split[i]);
		}

	}

	/***********************************************
	 * Map function of two-locus analysis
	 ***********************************************/
	public void map(LongWritable key, Text value,
			OutputCollector<DoubleWritable, Text> output, Reporter reporter) {

		processTuple(value, output);
	}

	public void processTuple(Text value,
			OutputCollector<DoubleWritable, Text> output) {
		tempText = value;
		if (tempText == null)
			return;
		int snp = 0;
		valueArray = tempText.getBytes();

		for (int i = 0; i < 5; i++) {
			tmpBytes[i] = valueArray[336 + i];
		}
		snp = Converter.byteToInt2(tmpBytes);
		double y = 1000000;
		int i = getRelatedReducer(splittor, snp);
		/*
		 * Replicate and emitting as many as needed
		 */
		for (int j = 0; j < i + 1; j++) {
			double a = snp + j / y;
			newKey.set(a); // KEY FORMAT: SNP.REDUCER
			try {
				output.collect(newKey, tempText);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

	}

	/*****************************************************************
	 * get the reducer number which the SNP should be shuffled to
	 *******************************************************************/
	public int getRelatedReducer(int[] splittor, int snp) {
		int low = 0;
		int high = splittor.length - 1;
		int h = 0;
		int reducer = 0;
		while (h == 0) {
			int mid = (low + high) / 2;
			if (splittor[mid] < snp) {
				if (mid == high - 1) {
					reducer = high;
					h = 1;
				} else {
					low = mid;
				}
			} else {
				if (mid != 0 && splittor[mid - 1] >= snp) {
					high = mid;
				} else {
					reducer = mid;
					h = 1;
				}
			}
		}
		return reducer;
	}

}
