package sg.edu.nus;

/*
 * author: Zhengkui Wang
 * 
 * National university of singapore
 */

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class TwoSnpsMapperSquareChopping extends MapReduceBase implements
		Mapper<LongWritable, Text, Text, Text> {
	Text newKey = new Text();
	Text newValue = new Text();
	int snpTotalNum = 0; // store the total snps number
	int partitionNum = 0;// store the partition number which is evenly divided
	int snp = 0;// which snp;
	int total = 0;
	int locatePartition = 0;
	int position = 0;// mark the position in the circle
	int currentPosition = 0;// mark last position
	String splittorString = null;
	int[] splittor = null;
	String[] strValueSplit;
	Text tempText = new Text();
	byte[] valueArray;
	byte[] tmpBytes = new byte[5];

	@Override
	public void configure(JobConf job) {
		this.snpTotalNum = job.getInt("snp.num", 0);
		this.partitionNum = job.getInt("partition.num", 0);

	}

	public void map(LongWritable key, Text value,
			OutputCollector<Text, Text> output, Reporter reporter) {
		processTuple(key.toString(), value, output);
	}

	public void processTuple(String key, Text value,
			OutputCollector<Text, Text> output) {

		tempText = value;

		if (tempText == null)
			return;
		int snp = 0;
		valueArray = tempText.getBytes();
		// System.out.println("value length of map is:" + valueArray.length);

		for (int i = 0; i < 5; i++) {
			tmpBytes[i] = valueArray[336 + i];
		}
		snp = Converter.byteToInt2(tmpBytes);

		locatePartition = (int) (snp * this.partitionNum / this.snpTotalNum);
		total = 0;
		position = locatePartition;
		currentPosition = 0;
		for (int column = 0, gap = this.partitionNum; column <= locatePartition; column++, gap--, position = position
				+ gap) {

			newKey.set("1" + "|" + snp + "|" + position);
			currentPosition = position;
			try {
				output.collect(newKey, tempText);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		for (int column = 0; column < this.partitionNum - locatePartition; column++, currentPosition++) {
			newKey.set("0" + "|" + snp + "|" + currentPosition);
			try {
				output.collect(newKey, tempText);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

	}

	public int getRelatedReducer(int[] splittor, int snp) {
		int low = 0;
		int high = splittor.length - 1;
		int h = 0;
		int reducer = 0;
		while (h == 0) {
			int mid = (low + high) / 2;
			if (splittor[mid] < snp) {
				if (mid == high - 1) {
					reducer = high;
					h = 1;
				} else {
					low = mid;
				}
			} else {
				if (mid != 0 && splittor[mid - 1] >= snp) {
					high = mid;
				} else {
					reducer = mid;
					h = 1;
				}
			}
		}
		return reducer;
	}

}
