package sg.edu.nus;

/*
 * @author: Zhengkui Wang
 * 
 * National university of singapore
 */
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/***
 * 
 * Partitioning founction in two-locus analysis
 * 
 */
public class TwoSnpsPartitionerGreedy implements Partitioner<DoubleWritable, Text> {
	long tmp = 0;

	@Override
	public int getPartition(DoubleWritable key, Text value, int numReduceTask) {
		tmp = (long) key.get();
		return (int) ((long) (key.get() * 1000000) - tmp * 1000000);

	}

	public void configure(JobConf job) {

	}

}
