

package dbmodel

  /** Version 11.1
   *
   *  This module implements "sorting key" that is used for
   *  ordering collections.
   *
   *  Wong Limsoon
   *  12 May 2023
   */


  object KEY:

    /** [[Key]] encapsulates ordering on collections.
     *
     *  @param get is the indexing field the collection is ordered by.
     *  @param ord is the ordering used. 
     */

    case class Key[B,K](get: B => K, ord: Ordering[K]): 
    
      def reversed: Key[B,K] = Key(get, ord.reverse)
    

    object Key:

      def asc[B,K](get: B => K)(using ord: Ordering[K]): Key[B,K] = 
        Key(get, ord)
  
      def dsc[B,K](get: B => K)(using ord: Ordering[K]): Key[B,K] =
        Key(get, ord.reverse)

      def idKey[B](using ord: Ordering[B]) = asc[B,B](x => x)(using ord)

      def nullKey[B] = asc((b:B) => ())
    
    end Key

  end KEY



